/*=================================================================================
Voice statistics example
This is a VAPI based code implementation of a function which can be used to query the voice statistics of a connection.
=================================================================================*/
/*
function usage:
...
	struct _VOIP_VCEINFO voice_stat;
...

...
	get_voip_vceinfo(connid, &voice_stat);
	display_voice_stats(&voice_stat);
...
*/
#include <stdio.h>
#include <vapi.h>
#include <msp.h>
#include <comcerto-stat-combined-voice-types.h>

/*=================================================================================
	This function prints the voice info statistics fields.				
=================================================================================*/
void display_voice_stats(struct _VOIP_VCEINFO *voice_stat)
{
	/*parameters [4:5]*/
	printf("voice_stat format %d\n",voice_stat->format);
	/*parameters [8:9]*/
	printf("voice_stat call_timer %d\n",voice_stat->call_timer);
	/*parameters [10:11]*/
	printf("voice_stat cur_playout_delay %d\n",voice_stat->cur_playout_delay);
	/*parameters [12:13]*/
	printf("voice_stat min_playout_delay %d\n",voice_stat->min_playout_delay);
	/*parameters [14:15]*/
	printf("voice_stat max_playout_delay %d\n",voice_stat->max_playout_delay);
	/*parameters [16:17]*/
	printf("voice_stat clock_offset %d\n",voice_stat->clock_offset);
	/*parameters [18:19]*/
	printf("voice_stat peak_jitter %d\n",voice_stat->peak_jitter);
	/*parameters [20:21]*/
	printf("voice_stat interpolative_concealment %d\n",voice_stat->interpolative_concealment);
	/*parameters [22:23]*/
	printf("voice_stat silence_concealment %d\n",voice_stat->silence_concealment);
	/*parameters [24:25]*/
	printf("voice_stat overflow_discard %d\n",voice_stat->overflow_discard);
	/*parameters [26:27]*/
	printf("voice_stat ep_detection_errors %d\n",voice_stat->ep_detection_errors);
	/*parameters [28:29]*/
	printf("voice_stat tx_voice_packets %d\n",voice_stat->tx_voice_packets);
	/*parameters [30:31]*/
	printf("voice_stat tx_signaling_packets %d\n",voice_stat->tx_signaling_packets);
	/*parameters [32:33]*/
	printf("voice_stat tx_comfort_noise_packets %d\n",voice_stat->tx_comfort_noise_packets);
	/*parameters [34:35]*/
	printf("voice_stat total_transmit_duration %d\n",voice_stat->total_transmit_duration);
	/*parameters [36:37]*/
	printf("voice_stat voice_transmit_duration %d\n",voice_stat->voice_transmit_duration);
	/*parameters [38:39]*/
	printf("voice_stat rx_voice_packets %d\n",voice_stat->rx_voice_packets);
	/*parameters [40:41]*/
	printf("voice_stat rx_signaling_packets %d\n",voice_stat->rx_signaling_packets);
	/*parameters [42:43]*/
	printf("voice_stat rx_comfort_noise_packets %d\n",voice_stat->rx_comfort_noise_packets);
	/*parameters [44:45]*/
	printf("voice_stat total_receive_duration %d\n",voice_stat->total_receive_duration);
	/*parameters [46:47]*/
	printf("voice_stat voice_receive_duration %d\n",voice_stat->voice_receive_duration);
	/*parameters [48:49]*/
	printf("voice_stat packets_out_sequence %d\n",voice_stat->packets_out_sequence);
	/*parameters [50:51]*/
	printf("voice_stat bad_protocol_headers %d\n",voice_stat->bad_protocol_headers);
	/*parameters [52:53]*/
	printf("voice_stat late_packets %d\n",voice_stat->late_packets);
	/*parameters [54:55]*/
	printf("voice_stat early_packets %d\n",voice_stat->early_packets);
	/*parameters [56:57]*/
	printf("voice_stat rx_voice_octets %d\n",voice_stat->rx_voice_octets);
	/*parameters [58:59]*/
	printf("voice_stat lost_packets %d\n",voice_stat->lost_packets);
	/*parameters [60:61]*/
	printf("voice_stat cur_transmit_power %d\n",voice_stat->cur_transmit_power);
	/*parameters [62:63]*/
	printf("voice_stat mean_transmit_power %d\n",voice_stat->mean_transmit_power);
	/*parameters [64:65]*/
	printf("voice_stat cur_receive_power %d\n",voice_stat->cur_receive_power);
	/*parameters [66:67]*/
	printf("voice_stat mean_receive_power %d\n",voice_stat->mean_receive_power);
	/*parameters [68:69]*/
	printf("voice_stat background_noise %d\n",voice_stat->background_noise);
	/*parameters [70:71]*/
	printf("voice_stat erl_level %d\n",voice_stat->erl_level);
	/*parameters [72:73]*/
	printf("voice_stat acom_level %d\n",voice_stat->acom_level);
	/*parameters [74:75]*/
	printf("voice_stat cur_transmit_activity %d\n",voice_stat->cur_transmit_activity);
	/*parameters [76:77]*/
	printf("voice_stat cur_receive_activity %d\n",voice_stat->cur_receive_activity);
}

/*=================================================================================
	This function queries the voice info statistics.
=================================================================================*/
int get_voip_vceinfo(uint connid, struct _VOIP_VCEINFO *voice_stat)
{
	VSTATUS result;
	void *message;
	U32 response_len = DEFAULT_FIFO_MAX_SIZE;
	U8 device_response [DEFAULT_FIFO_MAX_SIZE];

	/* allocate a message to query the current options */
	message = VAPI_AllocateMessage(DEFAULT_FIFO_MAX_SIZE);
	if (message == NULL)
		return FAILURE;

	/* build the command to get the statistics*/
	result = VAPI_SetMessage(message, CMD_CLASS_STAT_CHANNEL, CMD_TYPE_STAT_VOIP_VCEINFO, 0, 0); /*0 no stats reset, 0 parameters*/
	if(result != SUCCESS)
		goto out;

	/* send the query, the response is stored in device_response*/
	result = VAPI_SendConnectionMessage(connid, (SMsg *)message, NULL, device_response, &response_len);
	if(result != SUCCESS)
		goto out;

	/* point to the beginning of the parameters*/
	memcpy(voice_stat, &device_response[sizeof(struct comcerto_api_hdr)], sizeof(struct _VOIP_VCEINFO));

out:
	VAPI_FreeMessage(message);

	return result;

}

