...
/* This MAC address will be used in the IP/UDP/RTP (UDPTL) frame as the source MAC address.
 * This MAC address must be unique.
 * On master configuration this MAC address must be the same as the one defined for eth0
 */
U8 device_mac[6] = { 0x00, 0x50, 0xFC, 0xC3, 0xBD, 0xE2 }; /* 00:50:fc:c3:bd:e2*/

/* This can be the MAC address of an equipment on the subnet having IP forward capability
 * (PC, Router, etc).
 * This destination MAC is global for the device and all channnels, unless
 * it is overwritten at channel level by the SET_ETH_HDR_CHAN (VAPI_SetEthMac channel level call)*/
U8 default_dest_mac[6] = { 0x00, 0x11, 0xD8, 0xE7, 0xA5, 0x52 }; /*00:11:d8:e7:a5:52*/

	/* This command set the VLAN ID at device level */
	/* it must be issued before VAPI_SetEthMac() */
	result = VAPI_SetDeviceVlan(device_id, 0x0100,NULL);

	/* This command set the Device MAC address */
	status = VAPI_SetEthMac(device_id, CMD_LEVEL_DEVICE, device_mac, default_dest_mac, NULL);

	switch (status)
	{
	case SUCCESS: /* If success go ahead */
 		break;

	default:
		vapi_error_handler(status);
		break;
        }
...

	U8 connection_mac[6];
	/* retrieve the MAC address to be assigned to the connection (i.e from a SIP negotiation)*/
	get_mac_address(connection_mac);
	

	/*This command set the VLAN ID at connection level */
	/* it musr be issued before VAPI_SetEthMac()*/
	result = VAPI_SetConnVlan(connection_id, 0x0101,NULL);

	/*This command set the Connection MAC address */
	status = VAPI_SetEthMac(connection_id, CMD_LEVEL_CONN, connection_mac, default_dest_mac, NULL);

	switch (status)
	{
	case SUCCESS: /* If success go ahead */
		break;

	default:
		vapi_error_handler(status);
		break;
        }
