/*IP address used as the IP source for the RTP/UDPTL traffic
* This IP address must be unique
* On master configuration this IP address must be the same as the one defined for eth0
* This IP addres is assign to the device using VAPI_SetDeviceIPAddr()
 */
	U8 device_ip[4] = { 192, 168, 0, 5 };


int set_ip_udp_parameters(int connection_id, U8 * device_ip, U8 * dst_ip, U16 dst_port)
{
	VSTATUS status;
	SIpParams ip_parameters;

	/* Set the device IP to be the scr IP address for the RTP traffic*/
	memcpy((void *)&ip_parameters.uiSrcIpAddr, device_ip, 4);
	/* Set the destination IP */
	memcpy((void *)&ip_parameters.uiDestIpAddr, dst_ip, 4);

	/* The the Source UDP port (take a base UDP port and add the connection ID which is unique) */
	ip_parameters.usSrcUdpPort = htons(DEFAULT_UDP_PORT + connection_id);
	/* The the Destinqtion UDP port (this has been get from a IP signalling negotiation) */
	ip_parameters.usDestUdpPort = htons(dst_port);

	/*RTP defined in comcerto_ip_device_level_api.h */
	ip_parameters.ucIPServiceId = SET_IP_HDR_CHANNEL_SERVICEID_DEFAULTPKT;

	status = VAPI_SetConnIpParams(connection_id, &ip_parameters, NULL);

	return status;
}