
/*============================================================================\n
*	This example show how to change the default VAPI configuration defined in the
*	without modifying the VAPI source code SVAPIConfig structure (vapi_config.c,h)
*
*	To get VAPI overwriting the default parameters the application must register the 
*	QueryVapiDefaultsEnumerate before calling VAPI_Init()
*
*	in this example not all configurations are changed but only the DTMF option and the VOPENA operation.
*
============================================================================*/

void main()
{
...
	/* registering a customized configuration */
	pfnUsrQueryVapiDefaultsEnumerate = set_default_config;
...
	result = VAPI_Init();
	if (result != SUCCESS)
		return result;	
}

VSTATUS set_default_config(IN OUT SVAPIConfig * default_config)
{

	if (default_config == NULL)
		return VAPI_ERR_NULL_POINTER_PASSED;

	/* The default values are set in the DMGR_SetVoIPDefaults() function */
	/* change the default VAPI DTMF options (default is VOIP_DTMFOPT_REMOVAL_DEFAULT) */
	default_config->pstVoIPChnlParams->stDtmfOpt.param_4.bits.removal = VOIP_DTMFOPT_REMOVAL_DISABLE;

	/* By initiaizing the uVoiceOperation to VOIP_VOPENA_MODE_DISABLE the VAPI_CreateConnection will not issue the VOPENA*/
	default_config->pstVoIPChnlParams->stVopena.mode = VOIP_VOPENA_MODE_DISABLE; /* default is VOIP_VOPENA_MODE_ENABLE_RTP*/

	/* This is the default PT seting for IFP codec. IFP is used by FoIP channel type, PT is assigned while VAPI_SwitchToT38() */
	default_config->pstVoIPChnlParams->ucAudioPt[eIFP] = 0x62;

	return SUCCESS;
}