/*=================================================================================
	This function shows how to set the RTCP options for a connection.
	It configures the RTCP report granularity, sname and 
	enable simple RTCP (no indications, extended indications, etc ...)
=================================================================================*/
#include <vapi.h>
#include <gtl.h>
#include <msp.h>
#include <vapi/comcerto-rtcp-types.h>

int set_rtcp(U32 conn_id, int granularity, int sname_len, char *sname)
{
	VSTATUS result;
	void *config_message;
	struct _SDES_CNAME sdes_cname_options;
	struct _RTCP_ENA rtcp_ena;

	U32 response_len = DEFAULT_FIFO_MAX_SIZE;
	U8 device_response [DEFAULT_FIFO_MAX_SIZE];

	/* allocate a message to query the current options */
	config_message = VAPI_AllocateMessage(DEFAULT_FIFO_MAX_SIZE);
	if (config_message == NULL)
		return -1;

	/* build the command to set the rtcp options*/
	result = VAPI_SetMessage(config_message, CMD_CLASS_CONF_CHANNEL, CMD_TYPE_CONF_CHANGE, 
			FC_SET_RTCP_GENERATION_GRANULARITY, 2, granularity, 1);
	if(result != SUCCESS)
		goto err;

	sdes_cname_options.length = sname_len;
	UT_MemCopy(&sdes_cname_options.sdes_cname, sname, sdes_cname_options.length);

	/* build the command to set the rtcp cname options*/
	result = VAPI_SetMessageFromBuffer(config_message, CMD_CLASS_CONF_CHANNEL, CMD_TYPE_CONF_CHANGE, 
			FC_SDES_CNAME, 1 + (sdes_cname_options.length/2), (U16 *)&sdes_cname_options);

	if(result != SUCCESS)
		goto err;

	/* enable simple RTCP (no indication, extended indication, etc ...)*/
	rtcp_ena.param_4.word = 0x0000;
	rtcp_ena.param_4.bits.rtcp = RTCP_ENA_RTCP_ENABLE;

	/* build the command to set the rtcp cname options*/
	result = VAPI_SetMessageFromBuffer(config_message, CMD_CLASS_CONF_CHANNEL, CMD_TYPE_CONF_CHANGE, 
			FC_RTCP_ENA, sizeof(struct _RTCP_ENA)/2, (U16 *)&rtcp_ena);

	if(result != SUCCESS)
		goto err;

	/* send the query, the response is stored in device_response*/
	result = VAPI_SendConnectionMessage(conn_id, (SMsg *)config_message, NULL, device_response, &response_len);

err:
	VAPI_FreeMessage (config_message);

	return result;

}