...
	/* Create a connection in sync mode */
	status  = VAPI_CreateConnection(DevID, my_connection_id, eVOIP, my_timeslot, U_LAW, NULL, NULL);

	switch (status)
	{
	case SUCCESS: /* If success go ahead */
		break;

	/* If the error is timeslot in use (0xFFBD) try to recover */
	case ERR_TDMDRV_INVTS:
		/* recover some data: F/W MR number, Eth MAC, dev IP, etc.*/
		status = VAPI_InitDevice(DevID, VAPI_DEV_OPMODE_RECOVER, VAPI_DEV_PROF_DEFAULT, NULL, NULL);

		status = VAPI_RecoverConnection(DevID, my_connection_id, eVOIP, 10, NULL, NULL);

		/* if the connection is recovered go ahead else call the generic error handler */
		if (status == SUCCESS)
		{
			/* in this case we don't know what is the state of the connection
			so we set it in a default configuration */
			default_configuration(my_connection_id); /* this is a customer function*/
			break;
		}
		/* destroy the connection and fall through to the default case */ 
		else if (status == VAPI_ERR_RECOVER_WRONG_TYPE)
			VAPI_DestroyConnection(my_connection_id, NULL);
		/* in all other error case (i.e VAPI_ERR_RECOVER_TIMESLOT)
		we fall through to the default error case */

	default:
		vapi_error_handler(status);
		break;
        }
...

