
/* Connection level example */

/* define a complex tone */
/* Note that from VAPI 2.7.0 is more convenient to use the VAPI utilities API
(i.e VAPI_SetMessageFromBuffer) to build a such command*/
U8 complex_tone[] = {
	 /*CADENCE_ENGINE, length = 0x18 (24) no padding required*/
			0x18, 0x00, 0x00, 0x02, 0x6f, 0x80, 0x00, 0x00, /*CC, CT, FC*/
			0x01, 0x00, 0x00, 0x40, 0x32, 0x00, 0x00, 0x10,
			0x02, 0x00 ,0xc8, 0x00, 0x2c, 0x01, 0x00, 0x20,
	/* PROGRAM_TONE_ENGINE, length =  0x2e (46) 2 bytes of padding required*/
			0x2e, 0x00, 0x00, 0x02, 0x6e, 0x80, 0x00, 0x00,
			0x02, 0x00, 0x6c, 0x07, 0xd3, 0x00, 0x00, 0x00,
			0x00, 0x00 ,0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00 ,0x00, 0x00, 0x78, 0x05, 0xfb, 0x00,
			0x00, 0x00 ,0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00 ,0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	/* VOPENA_TONEGEN , length = 0x0a (10) 2 bytes of padding required*/
			0x0a, 0x00, 0x00, 0x02, 0x00, 0x80, 0x00, 0x00,
			0x0d, 0x00 ,0x00, 0x00
};

	SMsg MyMsg;			/* message structure which handle the passthru commands */
	U8 OutBuff[MAX_FIFO_SIZE];	/* buffer to handle the passthru response */
	U32 OutBuffLen = MAX_FIFO_SIZE;

	/* create a VoIP connection (id 0), on time slot 0 in blocking mode */
	status = VAPI_CreateConnection(device_id, 0, eVOIP,0 , U_LAW, NULL, NULL);
	if (status != SUCCESS)
		return status;

	/* assign the complex tone commands buffer address to the msg fifo buffer*/
	MyMsg.pusFifo = (U16 *)&complex_tone;
	/* set the right size */
	MyMsg.uiFifoSize = sizeof(complex_tone);

	/* send the complex tone generation parameters to the connection 0 in blocking mode*/);
	status =  VAPI_PassThru(0, CMD_LEVEL_CONN, &MyMsg, NULL, OutBuff, &OutBuffLen);
	if (status != SUCCESS)
	{
		print("VAPI_PassThru complex_tone error %d", status);
		return status;
	}
