/*=================================================================================
*	This function set the NTG (Network Timming Generator) of the M823xx device
*	On the M823xx device this command is required if no exteral clock is provided.
=================================================================================*/
#include <vapi.h>
#include <msp.h>

VSTATUS set_ntg_config(U16 device_id)
{
	VSTATUS result;
	void *message;
	U32 response_len = DEFAULT_FIFO_MAX_SIZE;
	U8 device_response [DEFAULT_FIFO_MAX_SIZE];

	/* allocate a message to build the command */
	message = VAPI_AllocateMessage(DEFAULT_FIFO_MAX_SIZE);
	if (message == NULL)
		return -1;

	result = VAPI_SetMessage(message, CMD_CLASS_CONF_DEVICE, CMD_TYPE_CONF_CHANGE, FC_NTG_CONFIG, 2, 
									0x0001,	/*Enable NTG module*/
									0x0006); /*NTG Bit Clock Generation (GPIO12) & NTG Frame Pulse Generation (GPIO11)*/
	if(result != SUCCESS)
		goto err;

	/* send the command, the response is stored in device_response*/
	result = VAPI_SendDeviceMessage(device_id, (SMsg *)message, NULL, device_response, &response_len);

err:
	VAPI_FreeMessage(message);
	return result;
}
