/*=================================================================================
Hearbeat example
This is a VAPI based code implementation of a function which can be used to enable 
the heartbeat feature of the MSP and handle the heartbeat indications.
=================================================================================*/
#include <stdio.h>
#include <vapi.h>
#include <msp.h>
#include <comcerto-stat-combined-voice-types.h>
#include <ut.h>

/*define one timer per device*/
STimer t_heart_beat_timer;

/*In the application event handler 
implement a handler for the HEARTBEAT indication.*/
/*
msp_indication_handler()
{
...
	
	case eVAPI_UNDEFINED_EVENT:
		this_event = (SUndefinedEventParams *) pvData;


		// check if we received an indication from MSP
		// If yes take the appropriated handling
		if (this_event->ucCmdType != CMD_TYPE_INDICATION)
			return;

		// Device level events
		if (this_event->ucLevel == CMD_LEVEL_DEVICE)
		{
			switch(this_event->usFnCode)
			{
			case FC_DEVICE_STATUS:
				heartbeat_info = this_event->ausParams[2];

				//if the heartbeat is receive with error print out some messages
				if ((heartbeat_info & 0xFB) != 0xFB)
					printf("   (%04x)  !ERR! HEARTBEAT FAILURE (0x%02x)", this_event->ausParams[1], heartbeat_info);

				
				//restart the heartbeat timer
				restartHeartBeatTimer(this_event->ID.DevId);
				return;
				break;

			default:
				break;
			}
		}
...
}
*/

/*This function can be called once the device is configured (TDM,IP,MAC, ...)*/
VSTATUS start_msp_heartbeat(int device_id, unsigned int heartbeat_period, unsigned int gpio_period, unsigned int gpio_port)
{
	VSTATUS result;
	void *message;
	
	U32 response_len = DEFAULT_FIFO_MAX_SIZE;
	U8 device_response [DEFAULT_FIFO_MAX_SIZE];

	if(heartbeat_period > 10)
		return VAPI_ERR_INVALID_PARAM;

	message = VAPI_AllocateMessage(DEFAULT_FIFO_MAX_SIZE);

	if(message == NULL)
		return VAPI_ERR_NOMEM;

	result = VAPI_SetMessage(message, CMD_CLASS_CONF_DEVICE, CMD_TYPE_CONF_CHANGE, FC_DEVICE_STATUS,	
				4,				/* 4 parameters */
				heartbeat_period,		/* P1: Heartbeat period in seconds, Max = 10s */
				gpio_period,			/* P2: GPIO toggle period in seconds, Max = 10s */
				gpio_port,			/* P3: GPIO port select */
				0x0000				/* P4: Reserved */
				);

	if(result == SUCCESS)
		result = VAPI_SendDeviceMessage(device_id, (SMsg *)message, NULL, device_response, &response_len);
	

	VAPI_FreeMessage(message);

	return result;
}

/*This function is called when no heartbeat indication has been receive for a period set by start_msp_heartbeat*/
void  heart_beat_timeout()
{
	UT_TimerStop(&t_heart_beat_timer);

	printf("heart_beat_timeout!! Coredump process would be started!\n");

	return;
}

/*This function is called to start/resert the heartbeat timer*/
/*The heartbeat period must be < to timer TIMEOUT see below*/
#define	MSP_HEARTBEAT_PERIOD	1
void  restart_heart_beatTimer()
{
	UT_TimerStop(&t_heart_beat_timer);
	UT_TimerStart(&t_heart_beat_timer, MSP_HEARTBEAT_PERIOD, (PFNTimerFunc)heart_beat_timeout, NULL);
}



