/*============================================================================
 *      COPYRIGHT(c) 2008 Mindspeed Technologies.
 *  File Purpose : GTL CSME configuration for a Master mode device
 *  Module       : GTL
============================================================================*/
/*this configuration described a 3 MSP slave setup.
The Host controls the MSPs from POS interface */

#include "gtl_config.h"

/* default values used in default_device_configuration */
#define POS_PHYID(id)	(id)
#define POS_MAC(phyid)			{0x00,0x00,0x00,0x00,phyid,0x00}
#define HOST_MAC			{0x00,0x11,0x11,0xEF,0x68,0x7B}
#define POS_IF_NAME			"pos0"
#define MAX_STRING_INTERFACE_NAME	20

/* Structure to define the default values for the device configuration  */
static SPOSUsrData gtl_device_configuration_1 = {
	NULL,			/* pointer to next device */
	ePOS_ITF,		/* control interface type to use */
	0,			/* device ID */
	0,			/* Version information (not used) */
	eSLAVE,			/* Slave / Master mode */
	DEV_TYPE_M827XX,	/* Other Slave Device type DEV_TYPE_M823XX, DEV_TYPE_M825XX, DEV_TYPE_M826XX, DEV_TYPE_M829XX */
	True,			/* Default or custom max channels */
	0,			/* Max Channels if above flag is custom */
	(POS_PHYID(0)), 	/* Physical Identifier */
	ePOSoTSP3,		/* Physical Path Type */
	POS_MAC(POS_PHYID(0)), 	/* Device MAC Address */
	HOST_MAC,		/* Host MAC Address (used in MAAS ASSIGN only for CSME Slave) */
	(char *)POS_IF_NAME,	/* Interface name on which communication with device is taking place eg pos0 */
	1,			/* 1 : ACK is required */
	{{0}},			/* Path info*/
	0			/* Ethernet unit*/
};

/* Structure to define the default values for the device configuration  */
static SPOSUsrData gtl_device_configuration_2 = {
	NULL,			/* pointer to next device */
	ePOS_ITF,		/* control interface type to use */
	1,			/* device ID */
	0,			/* Version information (not used) */
	eSLAVE,			/* Slave / Master mode */
	DEV_TYPE_M827XX,	/* Other Slave Device type DEV_TYPE_M823XX, DEV_TYPE_M825XX, DEV_TYPE_M826XX, DEV_TYPE_M829XX */
	True,			/* Default or custom max channels */
	0,			/* Max Channels if above flag is custom */
	(POS_PHYID(1)), 	/* Physical Identifier */
	ePOSoTSP3,		/* Physical Path Type */
	POS_MAC(POS_PHYID(1)), 	/* Device MAC Address */
	HOST_MAC,		/* Host MAC Address (used in MAAS ASSIGN only for CSME Slave) */
	(char *)POS_IF_NAME,	/* Interface name on which communication with device is taking place eg pos0 */
	1,			/* 1 : ACK is required */
	{{0}},			/* Path info*/
	0			/* Ethernet unit*/
};

/* Structure to define the default values for the device configuration  */
static SPOSUsrData gtl_device_configuration_3 = {
	NULL,			/* pointer to next device */
	ePOS_ITF,		/* control interface type to use */
	2,			/* device ID */
	0,			/* Version information (not used) */
	eSLAVE,			/* Slave / Master mode */
	DEV_TYPE_M827XX,	/* Other Slave Device type DEV_TYPE_M823XX, DEV_TYPE_M825XX, DEV_TYPE_M826XX, DEV_TYPE_M829XX */
	True,			/* Default or custom max channels */
	0,			/* Max Channels if above flag is custom */
	(POS_PHYID(2)), 	/* Physical Identifier */
	ePOSoTSP3,		/* Physical Path Type */
	POS_MAC(POS_PHYID(2)), 	/* Device MAC Address */
	HOST_MAC,		/* Host MAC Address (used in MAAS ASSIGN only for CSME Slave) */
	(char *)POS_IF_NAME,	/* Interface name on which communication with device is taking place eg pos0 */
	1,			/* 1 : ACK is required */
	{{0}},			/* Path info*/
	0			/* Ethernet unit*/
};

void set_gtl_config(void)
{
	SPOSUsrData *this_device;

	/* chain devices configuration (if any) */
	gtl_device_configuration_1.pvNext = &gtl_device_configuration_2;
	gtl_device_configuration_2.pvNext = &gtl_device_configuration_3;
	gtl_device_configuration_3.pvNext = NULL;

	/* print the configuation of the device(s) */
	this_device = &gtl_device_configuration_1;
	do
	{
		printf("======================================================\n");
		printf("CONTROL_INTERFACE_TYPE  = %d\n", this_device->usControlInterface);
		printf("DEVICE_ID    = %d\n", this_device->uiDevId);
		printf("DEVICE_MODE  = %d\n", this_device->eDevMode);
		printf("DEVICE_TYPE  = %d\n", this_device->ucDevType);
		printf("USE_DEFAULT_MAX_CHANNEL = %d\n", this_device->bUseDefaultMaxChnls);
		printf("CUSTOM_MAX_CHANNEL = %d\n", this_device->usMaxChannels);
		printf("ACK_REQUIRED = %d\n", this_device->ucIsAckReqd);
		printf("POS PHY ID = %d\n", this_device->ucPhyId);
		printf("POS PATH TYPE = %d\n", this_device->ePathType);
		printf("DEVICE MAC   = %02x:%02x:%02x:%02x:%02x:%02x\n", this_device->aucDevMac[0],
									this_device->aucDevMac[1],
									this_device->aucDevMac[2],
 									this_device->aucDevMac[3],
 									this_device->aucDevMac[4],
 									this_device->aucDevMac[5]);
		printf("HOST MAC   = %02x:%02x:%02x:%02x:%02x:%02x\n", this_device->aucHostMac[0],
									this_device->aucHostMac[1],
									this_device->aucHostMac[2],
 									this_device->aucHostMac[3],
 									this_device->aucHostMac[4],
 									this_device->aucHostMac[5]);
		printf("HOST_CONTROL_INTERFACE = %s\n", this_device->pucEthDevName);
		printf("ACK_REQUIRED = %d\n", this_device->ucIsAckReqd);
		printf("PATH INFO = %d\n", this_device->PathInfo.Tsp3.DevId);
		printf("ETHERNET UNIT = %d\n", this_device->ether_unit);

		this_device = this_device->pvNext;
	} while (this_device != NULL);

}

....
	VAPI_Init(&gtl_device_configuration_1)
....


