/*============================================================================
 *      COPYRIGHT(c) 2008 Mindspeed Technologies.
 *  File Purpose : GTL CSME configuration for a Master mode device
 *  Module       : GTL
============================================================================*/
/*this configuration described a single slave setup.
The host controls the slave MSP from the PCI interface" */

#include "gtl_config.h"

/* Structure to define the default values for the device configuration  */
#define DEVICE_MAC			{0x00,0x11,0x22,0x33,0x44,0x55}

#define HOST_CONTROL_INTERFACE		"/dev/comcerto0"

#define MAX_STRING_INTERFACE_NAME	20

/* Structure to define the default values for the device configuration  */
static SPCIUsrData gtl_device_configuration_1 = {
	NULL,			/* pointer to next device (no other device in this example)*/
	ePCI_ITF,		/* control interface type to use */
	0,			/* device ID */
	0,			/* Version information (not used) */
	eSLAVE,			/* Slave / Master mode */
	DEV_TYPE_M827XX,	/* Other Slave Device type DEV_TYPE_M823XX, DEV_TYPE_M825XX, DEV_TYPE_M826XX, DEV_TYPE_M829XX */
	True,			/* Default or custom max channels */
	0,			/* Max Channels if above flag is custom */
	(char *)HOST_CONTROL_INTERFACE,	/* host interface used to control the device */
};


void set_gtl_config(void)
{
	SPCIUsrData *this_device;

	/* chain devices configuration (if any) */
	gtl_device_configuration_1.pvNext = NULL;

	/* print the configuation of the device(s) */
	this_device = &gtl_device_configuration_1;
	do
	{
		printf("======================================================\n");
		printf("CONTROL_INTERFACE_TYPE  = %d\n", this_device->usControlInterface);
		printf("DEVICE_ID    = %d\n", this_device->uiDevId);
		printf("DEVICE_MODE  = %d\n", this_device->eDevMode);
		printf("DEVICE_TYPE  = %d\n", this_device->ucDevType);
		printf("USE_DEFAULT_MAX_CHANNEL = %d\n", this_device->bUseDefaultMaxChnls);
		printf("CUSTOM_MAX_CHANNEL = %d\n", this_device->usMaxChannels);
		printf("HOST_CONTROL_INTERFACE, %s\n", this_device->pucPCIDevName);
		this_device = this_device->pvNext;
	} while (this_device != NULL);

}

....
	VAPI_Init(&gtl_device_configuration_1)
....

