/*============================================================================
 *      COPYRIGHT(c) 2008 Mindspeed Technologies.
 *  File Purpose : GTL CSME configuration for a Master mode device
 *  Module       : GTL
============================================================================*/
/*this configuration described a combined Master and slave setup.
The CSP controls its "local" MSP from eth1 interface and a external Slave from the eth0 interface"*/

#include "gtl_config.h"

/*In master mode it is always this value (unless it has been changed at u-boot level)*/
#define DEVICE_CONTROL_MASTER_MAC		{0x00,0x11,0x22,0x33,0x44,0x55}
/*In master mode it is always this interface */
#define HOST_CONTROL_MASTER_INTERFACE		"eth1"

/* default values used in default_device_configuration */
#define DEVICE_CONTROL_SLAVE_MAC		{0x00,0x11,0x22,0x33,0x44,0x66} 
#define HOST_CONTROL_SLAVE_INTERFACE		"eth0"
#define MAX_STRING_INTERFACE_NAME	20

/* Structure to define the default values for the device configuration  */
static SCSMEUsrData gtl_device_configuration_1 = {
	NULL,			/* pointer to next device */
	eCSM_ITF,		/* control interface type to use */
	0,			/* device ID */
	0,			/* Version information (not used) */
	eMASTER,		/* Slave / Master mode */
	DEV_TYPE_M823XX,	/* Other Master Device type DEV_TYPE_M825XX, DEV_TYPE_M828XX, DEV_TYPE_M821XX */
	True,			/* Default or custom max channels */
	0,			/* Max Channels if above flag is custom */
	DEVICE_CONTROL_MASTER_MAC,	/* MAC address assigned to the device for control over csmencaps */
	{0x00,0x00,0x00,0x00,0x00,0x00}, /* Control Mac address interface. It is filled by the UT_GetInterfaceMac()
					In master mode this MAC is the eth1 MAC*/
	(char *)HOST_CONTROL_MASTER_INTERFACE,	/* host interface used to control the device */
	1			/* csme ack required */
};

static SCSMEUsrData gtl_device_configuration_2 = {
	NULL,			/* pointer to next device */
	eCSM_ITF,		/* control interface type to use */
	1,			/* device ID */
	0,			/* Version information (not used) */
	eSLAVE,			/* Slave / Master mode */
	DEV_TYPE_M829XX,	/* Other Master Device type DEV_TYPE_M825XX, DEV_TYPE_M828XX, DEV_TYPE_M821XX */
	True,			/* Default or custom max channels */
	0,			/* Max Channels if above flag is custom */
	DEVICE_CONTROL_SLAVE_MAC,	/* MAC address assigned to the device for control over csmencaps */
	{0x00,0x00,0x00,0x00,0x00,0x00}, /* Control Mac address interface. It is filled by the UT_GetInterfaceMac()
					In master mode this MAC is the eth1 MAC*/
	(char *)HOST_CONTROL_SLAVE_INTERFACE,	/* host interface used to control the device */
	1			/* csme ack required */
};

void set_gtl_config(void)
{
	SCSMEUsrData *this_device;

	/* chain devices configuration (if any) */
	gtl_device_configuration_1.pvNext = &gtl_device_configuration_2;
	gtl_device_configuration_2.pvNext = NULL;

	/* this function is defined in ut.c file; it retrieves the mac address from the net interface name*/
	UT_GetInterfaceMac(gtl_device_configuration_1.pucEthDevName, (char *)gtl_device_configuration_1.aucHostMac);
	UT_GetInterfaceMac(gtl_device_configuration_2.pucEthDevName, (char *)gtl_device_configuration_2.aucHostMac);

	/* print the configuation of the device(s) */
	this_device = &gtl_device_configuration_1;
	do
	{
		printf("======================================================\n");
		printf("CONTROL_INTERFACE_TYPE  = %d\n", this_device->usControlInterface);
		printf("DEVICE_ID    = %d\n", this_device->uiDevId);
		printf("DEVICE_MODE  = %d\n", this_device->eDevMode);
		printf("DEVICE_TYPE  = %d\n", this_device->ucDevType);
		printf("USE_DEFAULT_MAX_CHANNEL = %d\n", this_device->bUseDefaultMaxChnls);
		printf("CUSTOM_MAX_CHANNEL = %d\n", this_device->usMaxChannels);
		printf("ACK_REQUIRED = %d\n", this_device->ucIsAckReqd);
		printf("DEVICE MAC   = %02x:%02x:%02x:%02x:%02x:%02x\n", this_device->aucDevMac[0],
									this_device->aucDevMac[1],
									this_device->aucDevMac[2],
 									this_device->aucDevMac[3],
 									this_device->aucDevMac[4],
 									this_device->aucDevMac[5]);
		printf("HOST MAC   = %02x:%02x:%02x:%02x:%02x:%02x\n", this_device->aucHostMac[0],
									this_device->aucHostMac[1],
									this_device->aucHostMac[2],
 									this_device->aucHostMac[3],
 									this_device->aucHostMac[4],
 									this_device->aucHostMac[5]);
		printf("HOST_CONTROL_INTERFACE, %s\n", this_device->pucEthDevName);
		this_device = this_device->pvNext;
	} while (this_device != NULL);

}

....
	VAPI_Init(&gtl_device_configuration_1)
....


