...
void comcerto_response_handler(U32 connection_id,
			       U8 command_level, S32 result, void *response_data, U32 data_length, U32 request_id)
{
	printf("Response received on endpoint id %d, request id = 0x%04x", connection_id, request_id);

	if (result != SUCCESS)
	{
		print("Endpoint %d error %d", connection_id, result);
		/* handle the error */
		vapi_error_handler(connection_id, request_id, result);
	}
	
	switch (request_id)
	{
	case ECHOCAN_SEND:
		/* mark the received response for this endpoint */
		endpoints[connection_id].response_received |= ECHOCAN_SEND_MASK;
		break;

...
}

...
	/* create a VoIP connection (id 0), on time slot 0 in blocking mode */
	status = VAPI_CreateConnection(device_id, 0, eVOIP, 0, U_LAW, NULL, NULL);
	if (status != SUCCESS)
		return status;
...

...
	/* set a specific request ID for the echocan*/
	request.uiReqId = ECHOCAN_SEND;
	/* the callback function is comcerto_response_handler*/
	request.pfnIoCompCallback = &comcerto_response_handler;

	/* For connection 0, reset the echo canceller in non blocking mode*/ 
	status = VAPI_EchoCancellerReset(0, &request);
	if (status != VAPI_ERR_PENDING)
		return status;
...
