/*=================================================================================
	This function shows how to set the DSA tag option for a connection.
=================================================================================*/
#include <vapi.h>
#include <gtl.h>
#include <msp.h>
#include <vcore.h>
#include <vapi/comcerto-ethernet-interface-types.h>

int enable_dsa(U32 device_id, U8 dsa_tag_enable, U8 dsa_tag_mode, U8 dsa_tag_length)
{
	VSTATUS result;
	void *dsa_message;
	struct _SET_ETH_DSA_ENA dsa_tag_ena;

	U32 response_len = DEFAULT_FIFO_MAX_SIZE;
	U8 device_response [DEFAULT_FIFO_MAX_SIZE];

	/* allocate a message to query the current options */
	dsa_message = VAPI_AllocateMessage(DEFAULT_FIFO_MAX_SIZE);
	if (dsa_message == NULL)
		return -1;

	/* enable DSA tag feature with RX Direction is Forwarding Packet Format*/
	dsa_tag_ena.param_4.bits.dsa_tag_enable = dsa_tag_enable;
	dsa_tag_ena.param_4.bits.dsa_tag_mode = dsa_tag_mode;
	dsa_tag_ena.param_4.bits.dsa_tag_length = dsa_tag_length;

	/* build the command to set the eth header options*/
	result = VAPI_SetMessageFromBuffer(dsa_message, CMD_CLASS_CONF_DEVICE, CMD_TYPE_CONF_CHANGE, 
			FC_SET_ETH_DSA_ENA, sizeof(struct _SET_ETH_DSA_ENA)/2, (U16 *)&dsa_tag_ena);

	if(result != SUCCESS)
		goto err;

	/* send the query, the response is stored in device_response*/
	result = VAPI_SendDeviceMessage(device_id, (SMsg *)dsa_message, NULL, device_response, &response_len);

	if(result != SUCCESS)
		goto err;

err:
	VAPI_FreeMessage (dsa_message);

	return result;

}

/*set_dsa sets DSA tag. 
* Data that is pointed by *dsa_tag should go in right endianness. Please refer to the CRM for more deteils*/
int set_dsa(U32 id, U32 conn_id, U8 dsa_tag_length, unsigned char *dsa_tag, unsigned char *src_mac, unsigned char * dst_mac)
{
	VSTATUS result;
	void *eth_message;
	U8 command_class;
	U8 command_length;
	struct _SET_ETH_HDR_GENERIC eth_hdr;

	U32 response_len = DEFAULT_FIFO_MAX_SIZE;
	U8 device_response [DEFAULT_FIFO_MAX_SIZE];

	/* allocate a message to query the current options */
	eth_message = VAPI_AllocateMessage(DEFAULT_FIFO_MAX_SIZE);
	if (eth_message == NULL)
		goto err;

	/* set ETH_HDR parameters*/
	eth_hdr.param_4.word = UT_CPU2LE16(SET_ETH_HDR_PROTOCOL_IP);
	UT_MemCopy(&eth_hdr.hostmac, dst_mac, 6);
	UT_MemCopy(&eth_hdr.assignedmac, src_mac, 6);

	/* set DSA tag */
	if (dsa_tag_length == 1)
	{
		/*DSA TAG 4 bytes*/
		UT_MemCopy(&eth_hdr.eth_options[0], dsa_tag, 4);
		eth_hdr.eth_options[2] = UT_CPU2LE16(ETH_P_8021Q); /*Tag protocoI Id*/
		eth_hdr.eth_options[3] = 0;				/*TCI field*/
		eth_hdr.eth_options[4] = UT_CPU2BE16(ETH_P_IP);	/*Assigned Packet Type */

		command_length = 10;
		
	}
	else
	{
		/*DSA TAG 8 bytes*/
		UT_MemCopy(&eth_hdr.eth_options[0], dsa_tag, 8);
		eth_hdr.eth_options[4] = UT_CPU2LE16(ETH_P_8021Q);	/*Tag protocoI Id*/
		eth_hdr.eth_options[5] = 0;				/*TCI field*/
		eth_hdr.eth_options[6] = UT_CPU2BE16(ETH_P_IP);	/*Assigned Packet Type */

		command_length = 14;
	}

	if (id == 0xFFFF)
		command_class = CMD_CLASS_CONF_CHANNEL;
	else
		command_class = CMD_CLASS_CONF_DEVICE;	

	/* build the command to set the eth header options*/
	result = VAPI_SetMessageFromBuffer(eth_message, command_class, CMD_TYPE_CONF_CHANGE, 
			FC_SET_ETH_HDR, command_length, (U16 *)&eth_hdr);

	if(result != SUCCESS)
		goto err;

	if (id == 0xFFFF)
	{
		/*device level command*/
		result = VAPI_SendDeviceMessage(conn_id, (SMsg *)eth_message, NULL, device_response, &response_len);
	}
	else
	{
		/*channel level command*/
		result = VAPI_SendConnectionMessage(conn_id, (SMsg *)eth_message, NULL, device_response, &response_len);
	}

err:
	VAPI_FreeMessage (eth_message);

	return result;

}

