/* Blocking mode example for narrow band channel*/

...
	U16 my_timeslot = 0;

	status  = VAPI_AllocateConnection(DevID, my_connection_id, eVOIP, eNarrowBand, 1, &my_timeslot, NULL, NULL); 
	switch (status)
	{
	case SUCCESS: /* If success go ahead */
		break;

	default:
		vapi_error_handler(status);
		break;
        }
...

/* Asynchronous mode example for wide band channel */
...
void create_endpoint(int endpoint_id, int endpoint_state)
{
	int result;
	SRequest request;
	U16 my_timeslots[4] = {0, 1, 2, 3, 4};

	request.uiReqId = endpoint_state;
	request.pfnIoCompCallback = &comcerto_response_handler;

	result = VAPI_AllocateConnection(device_id,
		endpoint_id,
		eVOIP,          /* type 2*/
		eWideBand,	
		4,		/* use 4 timeslots */
		my_timeslots,
		&request,
		NULL);

	switch (result)
	{
	case VAPI_ERR_PENDING /* If success go ahead */
		break;

	default:
		vapi_error_handler(result);
	break;
}
...