/*! \file vapi_pots_var.h
 @defgroup Utilities vapi pots to pots application example utilities
 *  @{
 */
 
/* Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

#ifndef _VAPI_POTS_VAR_H
#define _VAPI_POTS_VAR_H

extern u_int16_t device_id;
extern u_int16_t endpoint_id;
extern int vapi_debug_level;
extern int app_debug_level;
extern int playback_mode;
extern int stop_type;
extern int speech_format;

extern u_int16_t originate_endpoint_id;
extern u_int16_t terminate_endpoint_id;

extern struct _ENDPOINT_DESC endpoints [MAX_ENDPOINTS];
extern u_int16_t VOICE_MAIL_MODE;
extern U8* media_buffer;
extern int media_buffer_length;

/* used to store ip_address in litlle endian */
extern u_int32_t le_device_ip_address;
/* used to store ip_address in big endian */
extern u_int32_t be_device_ip_address;

/* used to store device mac in big endian */
extern u_int16_t be_device_mac_addr[3];
/* used to store device mac in little endian */
extern u_int16_t le_device_mac_addr[3];

/* used to store host mac in big endian */
extern u_int16_t be_host_mac_addr[3];
/* used to store host mac in little endian */
extern u_int16_t le_host_mac_addr[3];
/* set the default mac address to 0 */
extern u_int16_t def_mac_addr[3];

/* structure with configuration parameters, structure type is defined in gtl.h */
extern SCSMEUsrData gtl_device_configuration;

#endif
