/*! \file vapi_pots_type.h
 @defgroup Utilities vapi pots to pots application example utilities
 *  @{
 */
 
/* Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

#ifndef _VAPI_POTS_TYPE_H
#define _VAPI_POTS_TYPE_H

#include <stdlib.h>
#include <stdio.h>

#define info(fmt, args...) fprintf(stderr, __FILE__ ": " fmt "\n" , ## args)
#define PDEBUG(type, fmt, args...) do {if(type) info ("%d: " fmt, __LINE__ , ## args);} while(0)

#define DEBUG_INIT 1
#define DEBUG_FUNCTION 0
#define DEBUG_ERROR 1
#define DEBUG_SLIC_FUNC 1

#define MAX_FIFO_SIZE 252

#define STR_SIZE 50

#define MAX_ENDPOINTS 2

/* side TDM/IP*/
#define TDM	1
#define IP 	2

/* announc_mode disable/sever/caller */
#define DISABLE	0
#define SERVER	1
#define CALLER	2

/* ENABLE */
#define ENABLE	1

#define DEFAULT_UDP_PORT 30000

#define POTS_LINE (TEMPO_LINE_TYPE_SLIC << 8) /* This is defined in tempo.h*/

#define ENDPOINT_STATE_NONE 0xFFFF
#define ENDPOINT_STATE_IDLE 0
#define ENDPOINT_STATE_READY 1
#define ENDPOINT_STATE_OFF_HOOK 2
#define ENDPOINT_STATE_ON_HOOK ENDPOINT_STATE_IDLE
#define ENDPOINT_STATE_RINGING 3

#define ENDPOINT_STATE_WAIT_CREATE_CONNECTION_ACK 4
#define ENDPOINT_STATE_WAIT_DESTROY_CONNECTION_ACK 5
#define ENDPOINT_STATE_GENERATE_DIAL_TONE 6
#define ENDPOINT_STATE_WAIT_CREATE_CONNECTION_ORIGINATE_ACK 7
#define ENDPOINT_STATE_WAIT_CREATE_CONNECTION_TERMINATE_ACK 8
#define ENDPOINT_STATE_WAIT_IP_PARAMETERS_ORIGINATE_ACK 9
#define ENDPOINT_STATE_WAIT_IP_PARAMETERS_TERMINATE_ACK 10
#define ENDPOINT_STATE_WAIT_ENABLE_CONNECTION_ORIGINATE_ACK 11
#define ENDPOINT_STATE_WAIT_ENABLE_CONNECTION_TERMINATE_ACK 12
#define ENDPOINT_STATE_WAIT_LOOPBACK_ACK 14
#define ENDPOINT_STATE_CALL_REMOTE 15
#define ENDPOINT_STATE_REMOTE_CALLED 16
#define ENDPOINT_STATE_WAIT_T38_SWITCH_ACK 17
#define ENDPOINT_STATE_WAIT_T38_IP_PARAMETERS_ACK 18
#define ENDPOINT_STATE_WAIT_ENABLE_T38_CONNECTION_ACK 19
#define ENDPOINT_STATE_WAIT_FOR_DIALING 20
#define ENDPOINT_STATE_WAIT_FOR_DIALED_COMMAND 21
#define ENDPOINT_STATE_ANNOUNCEMENT 22
#define ENDPOINT_STATE_WAIT_START_RECORDING_ACK 23
#define ENDPOINT_STATE_WAIT_START_PLAYING_ACK 24
#define ENDPOINT_STATE_AUTO_ANSWER 25
#define ENDPOINT_STATE_VOICE_MAIL_CALLER 26
#define ENDPOINT_STATE_VOICE_MAIL_SERVER 27

#define ENDPOINT_EVENT_NONE 0
#define ENDPOINT_EVENT_OFF_HOOK 1
#define ENDPOINT_EVENT_ON_HOOK 2
#define ENDPOINT_EVENT_RINGING 3
#define ENDPOINT_EVENT_CREATE_VOIP_CHANNEL 4
#define ENDPOINT_EVENT_VOIP_CHANNEL_CREATED 5
#define ENDPOINT_EVENT_VOIP_CHANNEL_DESTROYED 6
#define ENDPOINT_EVENT_MAKE_OUTGOING_CALL 7
#define ENDPOINT_EVENT_IP_PARAMETERS_SET 8
#define ENDPOINT_EVENT_CONNECTION_ENABLED 9
#define ENDPOINT_EVENT_V21FLAG_DETECTED	10
#define ENDPOINT_EVENT_T38_SWITCH_ACK 11
#define ENDPOINT_EVENT_T38_IP_PARAMETERS_SET 12
#define ENDPOINT_EVENT_DIALED_CALL_REMOTE 13
#define ENDPOINT_EVENT_DIALED_RECORDING 14
#define ENDPOINT_EVENT_DIALED_PLAYING 15
#define ENDPOINT_EVENT_START_RECORDING 16
#define ENDPOINT_EVENT_START_PLAYING 17
#define ENDPOINT_EVENT_START_RECORDING_COMPLETED 18
#define ENDPOINT_EVENT_START_PLAYING_COMPLETED 19
#define ENDPOINT_EVENT_PLAY_GREETING_MESSAGE 20
#define ENDPOINT_EVENT_PLAY_PROMPT_MESSAGE 21
#define ENDPOINT_EVENT_BUSY 22
#define ENDPOINT_EVENT_START_TIMER 23
#define ENDPOINT_EVENT_TIME_UP 24
#define ENDPOINT_EVENT_REMOTE_TIME_UP 25
#define ENDPOINT_EVENT_START_AUTO_ANSWER 26
#define ENDPOINT_EVENT_START_VOICE_MAIL_SERVER 27
#define ENDPOINT_EVENT_CREATE_TERMINATE_VOIP_CHANNEL 28

struct _ENDPOINT_DESC {
	u_int8_t index;
	u_int8_t peer_index;
	u_int8_t timeslot;
	u_int8_t state;
	u_int8_t previous_state;
	u_int8_t event;
	u_int8_t previous_event;
	u_int16_t rtp_port;
	u_int16_t rtcp_port;
	STimer *this_timer;	
	u_int16_t side;
	u_int16_t peer_destroy;
	u_int16_t voice_mail_mode;
};

#endif
