/*! \vapi_app_utility.c */
/* Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

VSTATUS set_default_config(IN OUT SVAPIConfig * default_config);
void set_device_configuration(U16 device_id);
int tdm_parameters_initialisation(void);
int network_parameters_initialisation(void);

void set_endpoint_event(int event_type, int index);
void set_endpoint_state(int state, int index);
void set_endpoint_side(int side, int index);
void onhook_handler(int endpoint_id);
void set_endpoint_peer_destroy( int on_off, int index);
void set_endpoint_voice_mail_mode(int announc_mode, int index);
void timed_connection (void *timer_data);

void destroy_endpoint(int endpoint_id, int endpoint_state);
void create_endpoint(int endpoint_id, int endpoint_state);
void stop_tone_generation(int endpoint_id, int endpoint_state);
void dialtone_generation(int endpoint_id, int endpoint_state);
void busytone_generation(int endpoint_id, int endpoint_state);
void ringbacktone_generation(int endpoint_id, int endpoint_state);
void start_voip_connection(int endpoint_id, int endpoint_state);
int get_loopback_mode(void);
void set_ip_udp_parameters(int endpoint_id, int endpoint_state);
void switch_voip_connection_to_t38(int endpoint_id, int endpoint_state);
void start_recording(int index, int endpoint_state);
void stop_recording(int index);
void start_playing(int index, int endpoint_state);
void stop_playing(int index);

void comcerto_response_handler(U32 connection_id,
			U8 command_level,
			S32 result,
			void *response_data,
			U32 data_length,
			U32 request_id);

void comcerto_indication_handler(EEventCode eEventCode, void *pvData);


int write_file ( void );
int read_file (void);

