/*! \demo.h */
/* Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

#ifndef __DEMO_H
#define __DEMO_H

#include <stdlib.h>
#include <stdio.h>
#include "vxcompat.h"

#if	!defined(_VXWORKS_)

#define info(fmt, args...)              fprintf(stderr, __FILE__ ": " fmt "\n", ## args)
#define PDEBUG(type, fmt, args...)      do { if (type) info("%d: " fmt, __LINE__ , ## args); } while(0)

#else

#if	defined(_WRS_GNU_VAR_MACROS) || defined(VXWORKS_6_6)

/* we also try to keep diab compatibility under VxWorks */
#define info(fmt, args...)              UT_ErrorLog(TEST, __FILE__ ": " fmt "\n", ## args)
#define PDEBUG(type, fmt, args...)      do { if (type) info("%d: " fmt, __LINE__ , ## args); } while(0)

#else

#define info(fmt, args, ...)            UT_ErrorLog(TEST, __FILE__ ": " fmt "\n", __VA_ARGS__)
#define PDEBUG(type, fmt, args, ...)    do { if (type) info("%d: " fmt, __LINE__ , __VA_ARGS__); } while(0)

#endif	/* _WRS_GNU_VAR_MACROS */

#endif	/* !_VXWORKS_ */

#define DEBUG_INIT 0
#define DEBUG_FUNCTION 0
#define DEBUG_ERROR 1
#define DEBUG_SLIC_FUNC 1

#define DEFAULT_MESSAGE_ID 0x000B
#define DEFAULT_PARAM3 0x0000
#define DEFAULT_RESERVED 0x0000
#define PADDING 0x0000
#define MAX_FIFO_SIZE 252

#define MAX_PHONE_SIZE 2

#define STR_SIZE 50

#define MAX_ENDPOINTS 4

/* Modes  SYNC/ASYNC */
#define ASYNC 1
#define SYNC  0

/* side TDM/IP*/
#define TDM	1
#define IP 	2

/* announc_mode disable/sever/caller */
#define DISABLE	0
#define SERVER	1
#define CALLER	2

/*pots number*/
#define EC_CH1 		0x01
#define EC_CH2		0x02
#define EC_CH3		0x03
#define EC_CH4		0x04

#define VP880_WBAND_MODE_MASK 	0x20

/* ENABLE */
#define ENABLE	1

#define DEFAULT_UDP_PORT 30000

#define POTS_LINE (TEMPO_LINE_TYPE_SLIC << 8) /* This is defined in tempo.h*/
#define ACK 0x0000

#define ENDPOINT_STATE_SYNC -1	/*this is used to perform a SYNC call to VAPI_xxx api)*/
#define ENDPOINT_STATE_NONE 0xFFFF
#define ENDPOINT_STATE_IDLE 0
#define ENDPOINT_STATE_READY 1
#define ENDPOINT_STATE_RINGING 2
#define ENDPOINT_STATE_WAIT_FOR_DIALING 3
#define ENDPOINT_STATE_REMOTE_CALLED 4
#define ENDPOINT_STATE_WAIT_IP_PARAMETERS_ORIGINATE_ACK 5
#define ENDPOINT_STATE_WAIT_IP_PARAMETERS_TERMINATE_ACK 6
#define ENDPOINT_STATE_SWITCH_MODE 7
#define ENDPOINT_STATE_CALL_WAITING 8

#define ENDPOINT_EVENT_NONE 0
#define ENDPOINT_EVENT_OFF_HOOK 1
#define ENDPOINT_EVENT_ON_HOOK 2
#define ENDPOINT_EVENT_DIALED_CALL_REMOTE 3
#define ENDPOINT_EVENT_RINGING 4
#define ENDPOINT_EVENT_PEER_OFFHOOK 5
#define ENDPOINT_EVENT_V21FLAG_DETECTED	6
#define ENDPOINT_EVENT_BUSY 7
#define ENDPOINT_EVENT_NB_WB_SWITCH 8
#define ENDPOINT_EVENT_SWITCH_TO_NB 9
#define ENDPOINT_EVENT_SWITCH_TO_WB 10
#define ENDPOINT_EVENT_READY 11
#define ENDPOINT_EVENT_REINITIALIZE_ENDPS 12
#define ENDPOINT_EVENT_DTMF_SERVICE 13
#define ENDPOINT_EVENT_CALL_ACCEPTED 14

struct _ENDPOINT_DESC {
	U8 index;
	int peer_index;
	U16 timeslot[4];
	U32 phone_id;
	char phonenumber[MAX_PHONE_SIZE];
	U8 phonenumber_index;
	U16 state;
	U8 event;
	U8 ip_src_addr[4];
	U16 rtp_port;
	U16 rtcp_port;
	U16 dtmf_service;
	int call_waiting_index;
};

struct _ENDPOINT_CFG_DESC {
	unsigned short nb_codec;
	unsigned short wb_codec;
	unsigned short packet_size;
};

VSTATUS set_default_config(IN OUT SVAPIConfig * default_config);
void set_device_configuration(SCSMEUsrData *device_configuration);
int tdm_parameters_initialisation(const char *config_file);
int network_parameters_initialisation(const char *config_file);
int diagnostics_initialisation(const char *config_file);
int get_loopback_mode(const char *config_file);
int get_endpoint_cfg(const char *config_file, struct _ENDPOINT_CFG_DESC *cfg);
int get_ec_mode(const char *config_file);
int get_tdm_diag_mode(const char *config_file, char * string, int size);

void set_endpoint_error(VSTATUS status, int index);
void set_endpoint_event(int event_type, int index);
void set_endpoint_state(int state, int index);
void set_endpoint_side(int side, int index);
void onhook_handler(int endpoint_id, int endpoint_state);
void set_endpoint_peer_destroy( int on_off, int index);
void set_endpoint_voice_mail_mode(int announc_mode, int index);
void timed_connection (void *timer_data);

VSTATUS destroy_endpoint(int endpoint_id, int endpoint_state);
VSTATUS create_endpoint(const char *config_file, int endpoint_id, int endpoint_state);
VSTATUS stop_tone_generation(int endpoint_id, int endpoint_state);
VSTATUS dialtone_generation(int endpoint_id, int endpoint_state);
VSTATUS busytone_generation(int endpoint_id, int endpoint_state);
VSTATUS ringbacktone_generation(int endpoint_id, int endpoint_state);
VSTATUS specialtone_generation(int endpoint_id, int endpoint_state);
VSTATUS start_voip_connection(int endpoint_id, int endpoint_state);
VSTATUS set_ip_udp_parameters_sync(int endpoint_id, U8 *ip_src_addr, U8 *ip_dst_addr, unsigned short udp_src, unsigned short udp_dst);
VSTATUS switch_voip_connection_to_t38(int endpoint_id, int endpoint_state);
int set_ip_options(unsigned int device_id, unsigned short ip_option);
void handle_dtmf_service(int i);
int get_mr(unsigned int device_id);

void start_recording(int index, int endpoint_state);
void stop_recording(int index);
void start_playing(int index, int endpoint_state);
void stop_playing(int index);

void comcerto_response_handler(U32 connection_id,
			U8 command_level,
			S32 result,
			void *response_data,
			U32 data_length,
			U32 request_id);

void comcerto_indication_handler(EEventCode eEventCode, void *pvData);

int write_file ( void );
int read_file (void);
int slic_set_wide_band(int fd, int line1, int line2);
int slic_set_narrow_band(int fd, int line1, int line2);
unsigned short slic_get_version(int fd);

extern struct _ENDPOINT_DESC	endpoints[MAX_ENDPOINTS];
extern U8	device_ip_address[4];
extern U8	device_mac_addr[6];
extern U8	host_mac_addr[6];
extern U8	def_mac_addr[6];
extern U8	channel_mode;

#endif
