/*! \file vapi_app_type.h */
/* Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

#ifndef _VAPI_APP_TYPE_H
#define _VAPI_APP_TYPE_H

#include "vxcompat.h"

#include <stdlib.h>
#include <stdio.h>

#define  SCENARIO_DEVICE_ALREADY_RESET		1
#define  SCENARIO_VOIP_IS_ACTIVE		2
#define  SCENARIO_DEVICE_IS_CRASHED		3

/* under VxWorks we should use VAPI logging instead of raw printfs */
#if	!defined(_VXWORKS_)

#define info(fmt, args...)		fprintf(stderr, __FILE__ ": " fmt "\n", ## args)
#define PDEBUG(type, fmt, args...)	do { if (type) info("%d: " fmt, __LINE__ , ## args); } while(0)

#else

#if	defined(_WRS_GNU_VAR_MACROS)

/* we also try to keep diab compatibility under VxWorks */
#define info(fmt, args...)		UT_ErrorLog(TEST, __FILE__ ": " fmt "\n", ## args)
#define PDEBUG(type, fmt, args...)	do { if (type) info("%d: " fmt, __LINE__ , ## args); } while(0)

#else

#define info(fmt, args, ...)		UT_ErrorLog(TEST, __FILE__ ": " fmt "\n", __VA_ARGS__)
#define PDEBUG(type, fmt, args, ...)	do { if (type) info("%d: " fmt, __LINE__ , __VA_ARGS__); } while(0)

#endif	/* _WRS_GNU_VAR_MACROS */

#endif	/* !_VXWORKS_ */

#define DEBUG_INIT		1
#define DEBUG_FUNCTION		1
#define DEBUG_ERROR		1
#define DEBUG_STI_FUNC		1

#define MAX_FIFO_SIZE		252

/* structure with configuration parameters, structure type is defined in gtl.h */
extern SCSMEUsrData gtl_device_configuration;

#endif /* __VAPI_APP_TYPE_H */
