/*! \file vapi_app_func.h */

/* Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

#ifndef _VAPI_APP_FUNC_H
#define _VAPI_APP_FUNC_H

#include "vxcompat.h"

#ifdef __cplusplus
extern "C" {
#endif

int	boot_device (U16 device_id, const char *firmware);

void	set_device_configuration (U16 device_id);

int	tdm_parameters_initialisation (U16 device_id);

int	network_parameters_initialisation (U16 device_id);

void	display_firmware_version (U16 device_id);

void	comcerto_response_handler (U32 connection_id,
				  U8 command_level,
				  S32 result,
				  void *response_data,
				  U32 data_length,
				  U32 request_id);

void	print_mac_addr (const char *prefix, U8 *mac_addr);

int send_force_alert (U16 device_id);

int tcp_open (char *server_name, short server_port);
int tcp_close (int);
int cdoip_write_file(int socket_id, int cd_size, char *cd_buffer);
int cdoip_close_file(int socket_id, char *filename);
int cdoip_open_file(int socket_id, char *filename);


#ifdef __cplusplus
}
#endif

#endif
