/* Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

/* codedump over IP server application 
 * gcc -Wall cdoip_server.c -o cdoip_server
 */

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <errno.h>
#include <string.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <sys/wait.h>
#include <unistd.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/un.h>

#include "cdoip.h"

#define MAXCLIENTS	5

static int file_desc = -1;
static char connect_msg[] = "Connected on CDoIP server ! ";

static int handle_cdoip_command(int client, int numbytes, struct cdoip_header *this_cdoip_frame)
{
	int rc = SUCCESS;
	struct cdoip_header cdoip_resp; 
	cdoip_resp.type = RESP;
	cdoip_resp.size = 1;

	if (numbytes != (this_cdoip_frame->size + CDOIP_HDR_SIZE))
		fprintf(stderr, " ########## WARNING ########### %d bytes out of %d\n", numbytes, this_cdoip_frame->size);

	switch(this_cdoip_frame->type)
	{
		case OPEN:
			printf("Open file %s\n", this_cdoip_frame->buffer);

			file_desc = open (this_cdoip_frame->buffer, O_CREAT|O_TRUNC|O_WRONLY, 0644);
			if (file_desc < 0) {
				perror("open failed");
				rc = FAILURE;
			}
			break;

		case CLOSE:
			printf("Close file %s\n", this_cdoip_frame->buffer);
			close(file_desc);
			rc = SUCCESS;
			break;

		case WRITE:
			printf("Write %d bytes to file\n", this_cdoip_frame->size);

			if (write(file_desc, this_cdoip_frame->buffer, this_cdoip_frame->size) != this_cdoip_frame->size) {
				perror("write() failed");
				rc = FAILURE;
			}
			break;

		default:
			fprintf(stderr, "Unknown command type 0x%02x\n", this_cdoip_frame->type);
			rc = FAILURE;
	}

	/* send the response status to the client */
	cdoip_resp.buffer[0] = rc;
	send(client, &cdoip_resp, CDOIP_HDR_SIZE +1, MSG_NOSIGNAL);
	return rc;
}

int main(int argc, char *argv[])
{
	int sock, new_fd, highest;
	int numbytes, i;
	int clients[MAXCLIENTS];
	short port = TCP_PORT;
	struct cdoip_header cdoip_frame;
	int rc = SUCCESS;
	struct sockaddr_in my_addr,their_addr;
	socklen_t sin_size;
	struct timeval tv;
	fd_set readfds;

	if ((sock = socket(AF_INET, SOCK_STREAM, 0)) == -1) {
		perror("socket() failed");
		exit(-1);
	}

	if (argc > 2)
		port = atoi(argv[1]);

	memset(&my_addr, 0, sizeof(my_addr));
	my_addr.sin_family = AF_INET;
	my_addr.sin_port = htons(port);
	my_addr.sin_addr.s_addr = INADDR_ANY;

	if (bind(sock, (struct sockaddr *)&my_addr, sizeof(struct sockaddr)) == -1) {
		perror("bind() failed");
		exit(-1);
	}

	if (listen(sock, MAXCLIENTS) == -1) {
		perror("listen() failed");
		exit(-1);
	}

	for (i = 0; i < MAXCLIENTS; i++)
		clients[i] = -1;

	printf("Server is ready\n");

	while (1) {
		sin_size = sizeof(struct sockaddr_in);
		tv.tv_sec = 0;
		tv.tv_usec = 250000;

		FD_ZERO(&readfds);
		FD_SET(sock, &readfds);
		highest = sock;

		for (i = 0; i < MAXCLIENTS; i++) {
			if (clients[i] < 0)
				continue;

			FD_SET(clients[i], &readfds);
			if (highest < clients[i])
				highest = clients[i];
		}

		if (select(highest+1, &readfds, NULL, NULL, &tv) >= 0) {
			if (FD_ISSET(sock, &readfds)) {
				if ((new_fd = accept(sock, (struct sockaddr *)&their_addr, &sin_size)) == -1) {
					perror("accept");
					continue;
				}

				for (i = 0; i < MAXCLIENTS; i++) {
					if (clients[i] == -1) {
						clients[i] = new_fd;
						break;
					}
				}

				if (i < MAXCLIENTS) {
					printf("Connection received from %s (slot %i)\n", inet_ntoa(their_addr.sin_addr), i);
					send(new_fd, connect_msg, sizeof(connect_msg), MSG_NOSIGNAL);
				} else {
					send(new_fd, "No room for you ! ", 18, MSG_NOSIGNAL);
					close(new_fd);
				}
			}

			for (i = 0; i < MAXCLIENTS; i++) {
				if (clients[i] < 0)
					continue;

				if (FD_ISSET(clients[i], &readfds)) {
					memset(&cdoip_frame, 0, MAXDATASIZE + CDOIP_HDR_SIZE);

					if ((numbytes = recv(clients[i], &cdoip_frame, MAXDATASIZE + CDOIP_HDR_SIZE, 0)) <= 0) {
						printf("Connection lost from slot %i ", i);
						close(clients[i]);
						clients[i] = -1;
					} else {
						printf("Received cdoip_frame %d bytes on slot %i\n", numbytes, i);
						rc = handle_cdoip_command(clients[i], numbytes, &cdoip_frame);
					}
				}
			}
		}
		else {
			perror("select() failed");
			continue;
		}
	}

	return 0;
}
