/*! \file vapi_app_type.h */
/* Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

#ifndef _VAPI_APP_TYPE_H
#define _VAPI_APP_TYPE_H

#include "vxcompat.h"

#include <stdlib.h>
#include <stdio.h>

/* under VxWorks we should use VAPI logging instead of raw printfs */
#if	!defined(_VXWORKS_)

#define info(fmt, args...)		fprintf(stderr, __FILE__ ": " fmt "\n", ## args)
#define PDEBUG(type, fmt, args...)	do { if (type) info("%d: " fmt, __LINE__ , ## args); } while(0)

#else

#if	defined(_WRS_GNU_VAR_MACROS)

/* we also try to keep diab compatibility under VxWorks */
#define info(fmt, args...)		UT_ErrorLog(TEST, __FILE__ ": " fmt "\n", ## args)
#define PDEBUG(type, fmt, args...)	do { if (type) info("%d: " fmt, __LINE__ , ## args); } while(0)

#else

#define info(fmt, args, ...)		UT_ErrorLog(TEST, __FILE__ ": " fmt "\n", __VA_ARGS__)
#define PDEBUG(type, fmt, args, ...)	do { if (type) info("%d: " fmt, __LINE__ , __VA_ARGS__); } while(0)

#endif	/* _WRS_GNU_VAR_MACROS */

#endif	/* !_VXWORKS_ */

#define DEBUG_INIT		1
#define DEBUG_FUNCTION		0
#define DEBUG_ERROR		1
#define DEBUG_STI_FUNC		1

#define DEFAULT_RESERVED	0x0000
#define MAX_FIFO_SIZE		252

#define STR_SIZE		50

#define MAX_ENDPOINTS		32
/* Modes  SYNC/ASYNC */
#define ASYNC			1
#define SYNC			0

#define DEFAULT_UDP_PORT	30000

#define POTS_LINE		(STI_LINE_TYPE_SLIC << 8) /* This is defined in sti.h */
#define ACK			0x0000

#define ENDPOINT_STATE_IDLE	0
#define ENDPOINT_STATE_READY	1
#define ENDPOINT_STATE_OFF_HOOK	2
#define ENDPOINT_STATE_ON_HOOK	ENDPOINT_STATE_IDLE
#define ENDPOINT_STATE_RINGING	3

#define ENDPOINT_STATE_WAIT_CREATE_CONNECTION_ACK		4
#define ENDPOINT_STATE_WAIT_DESTROY_CONNECTION_ACK		5
#define ENDPOINT_STATE_GENERATE_DIAL_TONE			6
#define ENDPOINT_STATE_WAIT_CREATE_CONNECTION_ORIGINATE_ACK	7
#define ENDPOINT_STATE_WAIT_CREATE_CONNECTION_TERMINATE_ACK	8
#define ENDPOINT_STATE_WAIT_IP_PARAMETERS_ORIGINATE_ACK		9
#define ENDPOINT_STATE_WAIT_IP_PARAMETERS_TERMINATE_ACK		10
#define ENDPOINT_STATE_WAIT_ENABLE_CONNECTION_ORIGINATE_ACK	11
#define ENDPOINT_STATE_WAIT_ENABLE_CONNECTION_TERMINATE_ACK	12
#define ENDPOINT_STATE_WAIT_LOOPBACK_ACK			14
#define ENDPOINT_STATE_CALL_REMOTE				15
#define ENDPOINT_STATE_REMOTE_CALLED				16
#define ENDPOINT_STATE_WAIT_T38_SWITCH_ACK			17
#define ENDPOINT_STATE_WAIT_T38_IP_PARAMETERS_ACK		18
#define ENDPOINT_STATE_WAIT_ENABLE_T38_CONNECTION_ACK		19

#define ENDPOINT_EVENT_NONE			0
#define ENDPOINT_EVENT_OFF_HOOK			1
#define ENDPOINT_EVENT_ON_HOOK			2
#define ENDPOINT_EVENT_RINGING			3
#define ENDPOINT_EVENT_CREATE_VOIP_CHANNEL	4
#define ENDPOINT_EVENT_VOIP_CHANNEL_CREATED	5
#define ENDPOINT_EVENT_VOIP_CHANNEL_DESTROYED	6
#define ENDPOINT_EVENT_MAKE_OUTGOING_CALL	7
#define ENDPOINT_EVENT_IP_PARAMETERS_SET	8
#define ENDPOINT_EVENT_CONNECTION_ENABLED	9
#define ENDPOINT_EVENT_V21FLAG_DETECTED		10
#define ENDPOINT_EVENT_T38_SWITCH_ACK		11
#define ENDPOINT_EVENT_T38_IP_PARAMETERS_SET	12

struct _FIFO_HEADER_DESC {
	U8 fifo_length;
	U8 host_index;
	U8 command_type;
	U8 command_class;
	U16 function_code;
	U16 reserved;
};

struct _FIFO_DESC 
{
	union
	{
		U16 payload[MAX_FIFO_SIZE / 2];
		
		struct
		{
			struct _FIFO_HEADER_DESC fifo_header;
			U16 parameters[MAX_FIFO_SIZE - sizeof(struct _FIFO_HEADER_DESC) / 2];
		}__attribute__((packed)) fifo_desc;
	}fifo;
}__attribute__((packed)); 

#define COMMAND_TYPE	fifo.fifo_desc.fifo_header.command_type
#define COMMAND_CLASS	fifo.fifo_desc.fifo_header.command_class
#define FUNCTION_CODE	fifo.fifo_desc.fifo_header.function_code
#define FIFO_LENGTH	fifo.fifo_desc.fifo_header.fifo_length
#define HOST_INDEX	fifo.fifo_desc.fifo_header.host_index
#define RESERVED	fifo.fifo_desc.fifo_header.reserved
#define PARAMETERS	fifo.fifo_desc.parameters
#define FIFO		fifo.payload


struct _DEVICE_RESPONSE_DESC 
{
	union
	{
		U16 payload[MAX_FIFO_SIZE / 2];
		
		struct
		{
			struct _FIFO_HEADER_DESC fifo_header;
			U16 status;
			U16 parameters[MAX_FIFO_SIZE - sizeof(struct _FIFO_HEADER_DESC) / 2 - sizeof(U16)];
		}__attribute__((packed)) fifo_desc;
	}response;
}__attribute__((packed)); 

#define RESPONSE_COMMAND_TYPE	response.fifo_desc.fifo_header.command_type
#define RESPONSE_COMMAND_CLASS	response.fifo_desc.fifo_header.command_class
#define RESPONSE_FUNCTION_CODE	response.fifo_desc.fifo_header.function_code
#define RESPONSE_FIFO_LENGTH	response.fifo_desc.fifo_header.fifo_length
#define RESPONSE_HOST_INDEX	response.fifo_desc.fifo_header.host_index
#define RESPONSE_RESERVED	response.fifo_desc.fifo_header.reserved
#define RESPONSE_STATUS		response.fifo_desc.status
#define RESPONSE_PARAMETERS	response.fifo_desc.parameters
#define RESPONSE_FIFO		response.payload

struct _ENDPOINT_DESC {
	U8 index;
	U8 peer_index;
	U8 timeslot;
	U8 state;
	U8 previous_state;
	U8 event;
	U8 previous_event;
	U16 rtp_port;
	U16 rtcp_port;
};

/* global array of endpoints */
extern struct _ENDPOINT_DESC endpoints[];

/* structure with configuration parameters, structure type is defined in gtl.h */
extern SDeviceHeader gtl_device_configuration;

/* IP address used as the IP source for the RTP/UDPTL traffic */
extern U8 device_ip[];

#endif
