/*! \file vapi_app_func.h */
/* Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

#ifndef _VAPI_APP_FUNC_H
#define _VAPI_APP_FUNC_H

#include "vxcompat.h"

#ifdef __cplusplus
extern "C" {
#endif

int	boot_device(U16 device_id, const char *firmware);

void 	set_device_configuration(U16 device_id, int device_ctrl_itf);
int	tdm_parameters_initialisation(U16 device_id);
int	network_parameters_initialisation(U16 device_id);

void	display_firmware_version(U16 device_id);

int	destroy_endpoint(int endpoint_id,  int mode, int endpoint_state);

void	start_loopback(int endpoint_id, int endpoint_state);
int	create_voip_endpoint(U16 device_id,
			     int endpoint_id,
			     int mode,
			     int endpoint_state);
int	set_ip_udp_parameters(U8 *device_ip, int endpoint_id, int mode, int endpoint_state);
int	start_voip_endpoint(int endpoint_id, int mode, int endpoint_state);

void	comcerto_response_handler(U32 connection_id,
				  U8 command_level,
				  S32 result,
				  void *response_data,
				  U32 data_length,
				  U32 request_id);

void	comcerto_indication_handler(EEventCode eEventCode, void *pvData);
VSTATUS	set_default_config(IN OUT SVAPIConfig * default_config);

void	print_mac_addr(const char *prefix, U8 *mac_addr);

#ifdef __cplusplus
}
#endif

#endif
