/*!
*	\file slic.h
*
*	\attention
*	Copyright © 2004-2010 Mindspeed Technologies, Inc.\n
*	Mindspeed Confidential.\n
*	All rights reserved.\n
*	This file is a component of the Mindspeed® VAPI software ("VAPI") and is
*	distributed under the Mindspeed Software License Agreement (the "Agreement").\n
*	Before using this file, you must agree to be bound by the the terms and 
*	conditions of the Agreement.
*
*	@{
*/

#ifndef __SLIC_H
#define __SLIC_H


/* ==============================
	Constants
   ============================== */


#define VP880_WBAND_MODE_MASK   0x20


/* ==============================
	Types
   ============================== */


typedef struct slic
{
	int version;
	int mode;
	int dev_file;
	int is_wideband;
} slic_t;


/* ==============================
	Function Prototypes
   ============================== */


extern void * pots_event_handler(void * none);
extern int slic_set_wide_band(int fd, int line1, int line2);
extern int slic_set_narrow_band(int fd, int line1, int line2);
extern void ring_pots(int pots_line);
extern void stop_ring_pots(int pots_line_id);
extern unsigned short get_slic_version(int fd);
extern unsigned short is_slic_wideband(unsigned short slic_version);
extern int slic_init(slic_t *slic);


/* ==============================
	Variables
   ============================== */

slic_t slic;


#endif /* __SLIC_H */

/*! @} */
