/*!
*	\file netif.h
*
*	\attention
*	Copyright © 2004-2010 Mindspeed Technologies, Inc.\n
*	Mindspeed Confidential.\n
*	All rights reserved.\n
*	This file is a component of the Mindspeed® VAPI software ("VAPI") and is
*	distributed under the Mindspeed Software License Agreement (the "Agreement").\n
*	Before using this file, you must agree to be bound by the the terms and 
*	conditions of the Agreement.
*
*	@{
*/

#ifndef __NETIF_H
#define __NETIF_H


/* ==============================
	Constants
   ============================== */

#define	MAX_DIAG_FUNCTION_CODE 10

/* ==============================
	Types
   ============================== */

/*! netif configuration descriptor */
typedef struct netif_cfg
{
	U8 device_ip[4];
		/*! device IP address */
	U8 device_mac[6];
		/*! device MAC address */
	U8 host_mac[6];
		/*! host MAC address */
} netif_cfg_t;


/* ==============================
	Function Prototypes
   ============================== */

netif_cfg_t *get_netif_cfg(const char *cfg_file);
void display_netif_cfg(netif_cfg_t *netif_cfg);
int netif_init(netif_cfg_t *netif_cfg);
int netif_modify(int conn_id, unsigned char *src_ip, unsigned char *dst_ip, int src_rtp, int dst_rtp);


/* ==============================
	Variables
   ============================== */

netif_cfg_t *netif_cfg;

#endif /* __NETIF_H */

/*! @} */ /* mtalk */
