/*!
*	\file mtalk.h 
*
*	\attention
*	Copyright © 2004-2010 Mindspeed Technologies, Inc.\n
*	Mindspeed Confidential.\n
*	All rights reserved.\n
*	This file is a component of the Mindspeed® VAPI software ("VAPI") and is
*	distributed under the Mindspeed Software License Agreement (the "Agreement").\n
*	Before using this file, you must agree to be bound by the the terms and 
*	conditions of the Agreement.
*
*	@{
*/

#ifndef __MTALK_H
#define __MTALK_H


/* ==============================
	Macros
   ============================== */

#define info(fmt, args...)              fprintf(stderr, __FILE__ ": " fmt "\n", ## args)
#define PDEBUG(type, fmt, args...)      do { if (type) info("%d: " fmt, __LINE__ , ## args); } while(0)

#define exit_on_err(err_code, label, err_msg)	\
	if (err_code != 0)			\
	{					\
		PDEBUG(1, "!ERR! %s", err_msg);	\
		goto label;			\
	}


#define exit_if_null(ptr, label, err_msg)	\
	if (!ptr)				\
	{					\
		PDEBUG(1, "!ERR! %s", err_msg);	\
		goto label;			\
	}
		


/* ==============================
	Common Constants
   ============================== */


#define MTALK_VERSION "1.0"

#define MTALK_CFG_FILE "mtalk.cfg"

/*------ DEBUG ----- */

/* debug display */
#define DBG_ERR   1
#define DBG_L1   1 
#define DBG_L2   1
#define DBG_L3   0
#define DBG_L4   0
#define DBG_L5   0
/*
#define DEBUG_INIT   1
#define DEBUG_CFG   1
#define DEBUG_FUNCTION   1
#define DEBUG_ERROR   1
#define DEBUG_SLIC_FUNC   1
*/
/* diags */
#define	DIAG_REDIRECT_SRC_UDP   20000
#define	DIAG_REDIRECT_DST_UDP   21000


/*------ ENDPT ----- */


#define MAX_ENDPT_ID   20
#define MAX_POTS_ENDPT_ID   4




/* this is used to perform a SYNC call to VAPI_xxx api) */
#define VAPI_SYNC_MODE   -1




/*------ NETIF ----- */


/* device control MAC used at boot stage
 *
 * On Slave configuration this address is set by the MAAS_ASSIGN command (VAPi_AssignBootMAC)
 * On Master configuration this address must be the same as the on set by the bootloader (u-boot, ARMboot),
 * the default value is 00:11:22:33:44:55
 */
/*00:11:22:33:44:55*/
#define DEVICE_CTRL_MAC   {0x00,0x11,0x22,0x33,0x44,0x55}

/* host control MAC
 *
 * On slave device this MAC address is the MAC address on the network interface
 * used to control the device. For example if a PC is used to control the device,
 * it is the MAC address of the network card
 */
#define HOST_CTRL_INTERFACE   "eth1"
#define HOST_CTRL_MAC   {0x00,0x1A,0x1B,0x1C,0x1D,0x1E}

#define DEVICE_IP "192.168.1.2"
#define DEVICE_MAC "00:AA:BB:CC:DD:EE"
#define	HOST_MAC   "00:50:B6:06:0D:08"

#define DEFAULT_UDP_PORT   30000


/*------ SIPUA ----- */

/* default value of SIP user defined parameters */
#define	NB_SIP_TDM_ACC   2
#define	NB_SIP_IP_ACC   6
#define	FIRST_SIP_USER_ID   301
#define SIP_PASSWD   "root123"

#define	SIP_SERVER_IP   "192.168.32.176"
#define	SIP_SERVER_UDP   5060
#define	SIP_SERVER_DOMAIN  "3CXPhoneSystem"
#define	SIP_SERVER_REGISTRATION   1
#define	SIP_MAX_PHONE_URI   8


/* ==============================
	mtalk Components
   ============================== */

#include <endpt.h>
#include <media.h>
#include <sipua.h>
#include <slic.h>
#include <tdmif.h>
#include <netif.h>
#include <debug.h>
#include <readcfg.h>


/* ==============================
	Function Prototypes
   ============================== */


/* VAPI call back function prototpes */

extern void comcerto_indication_handler(EEventCode eEventCode, void *pvData);
extern void comcerto_response_handler(U32 connection_id, U8 command_level, S32 result, void *response_data, U32 data_length, U32 request_id);

extern void endpt_pool_display(void);

/* config.c function prototpes */

/* void set_device_configuration(SCSMEUsrData *device_configuration); */
int set_default_config(IN OUT SVAPIConfig * default_config);
/*
sip_cfg_t *get_sip_cfg(const char *config_file);
STdmSetupParams *get_tdm_cfg(const char *config_file);
netif_cfg_t *get_netif_cfg(const char *config_file);
media_cfg_t *get_media_cfg(const char *config_file);
diag_cfg_t *get_diag_cfg(const char *config_file);
*/
int get_mr(U32 device_id);

/* ==============================
	Common Variables
   ============================== */


/* config variables */

/* slic */
int is_wideband_slic;

int mr_version;

U8 channel_mode;

/* These are global variables intended to be modified from the vxworks shell */
/*_DDK_ is defined when vapi_demo is build together with the vxWorks kernel + VAPI + legerity */ 
#if defined (_DDK_) 
	int EC_MODE = 0;
	int LOOPBACK_MODE = 5;
	unsigned short NB_CODEC = 4;
	unsigned short WB_CODEC = 4;
	unsigned short PACKET_SIZE = 20;
	U8 DEV_IP_ADDR[4] = {192, 168, 32, 200};
	U8 DEV_MAC_ADDR[6] = {0x00, 0xaa, 0xbb, 0xcc, 0xdd, 0xee};
	U8 HOST_MAC_ADDR[6] = {0x00, 0x11, 0xd8,  0xe7, 0xa5, 0x2d};
	U8 SIP_CTRL_UDP_PORT = 5060;
	U8 SIP_PHONE_ID[4] = "300"
	U8 SIP_DST_PHONE_ID[4] = "600";
	U8 SIP_DST_IP_ADDR[4] = {192, 168, 32, 176};
	U8 SIP_DST_UDP_PORT = 31000;
	char DIAG_STRING[50] = "NONE";
#endif


#endif /* __MTALK_H */

/*! @} */
