/*!
*	\file media.h
*
*	\attention
*	Copyright © 2004-2010 Mindspeed Technologies, Inc.\n
*	Mindspeed Confidential.\n
*	All rights reserved.\n
*	This file is a component of the Mindspeed® VAPI software ("VAPI") and is
*	distributed under the Mindspeed Software License Agreement (the "Agreement").\n
*	Before using this file, you must agree to be bound by the the terms and 
*	conditions of the Agreement.
*
*	@{
*/

#ifndef __MEDIA_H
#define __MEDIA_H


/* ==============================
	Constants
   ============================== */

#define	MAX_DIAG_FUNCTION_CODE 10


/* ==============================
	Types
   ============================== */

/*! media configuration descriptor */
typedef struct media_cfg {
	unsigned short spu_ec_type;
		/*! type of SPU echo cancellor */
	unsigned short loopback_mode;
		/*! loopback mode, i.e. inter channel loopback, TDM loopback, etc */
	unsigned short codec;
		/*! default codec applied when creating a channel */
	unsigned short packet_size;
		/*! packet size in milliseconds */
} media_cfg_t;



/* ==============================
	Function Prototypes
   ============================== */

media_cfg_t *get_media_cfg(const char *cfg_file);
void display_media_cfg(media_cfg_t *media_cfg);
int endpt_create_voip(endpt_t *endpt, int vapi_mode);
int endpt_modify_voip(endpt_t *endpt);
int endpt_delete_voip(endpt_t *endpt, int vapi_mode);
int endpt_start_transcoding(endpt_t *endpt);
int endpt_start_voip(endpt_t *endpt, int vapi_mode);
int endpt_switch_to_t38(endpt_t *endpt, int vapi_mode);
int endpt_hangup(endpt_t *endpt, int vapi_mode);
int endpt_play_tone(endpt_t *endpt, EToneId tone_id, int vapi_mode);
int endpt_stop_tone(endpt_t *endpt, int endpt_state);
int endpt_start_loopback(endpt_t *endpt);
int endpt_stop_loopback(endpt_t *endpt);
int endpt_band_switch(endpt_t *endpt, int mode);
/*
int endpt_call_sip_phone(endpt_t *endpt);
int endpt_ack_sip_invite(endpt_t *endpt);
*/

/* ==============================
	Variables
   ============================== */

media_cfg_t *media_cfg;


#endif /* __MEDIA_H */

/*! @} */
