/*!
*	\file debug.h
*
*	\attention
*	Copyright © 2004-2010 Mindspeed Technologies, Inc.\n
*	Mindspeed Confidential.\n
*	All rights reserved.\n
*	This file is a component of the Mindspeed® VAPI software ("VAPI") and is
*	distributed under the Mindspeed Software License Agreement (the "Agreement").\n
*	Before using this file, you must agree to be bound by the the terms and 
*	conditions of the Agreement.
*
*	@{
*/

#ifndef __DEBUG_H
#define __DEBUG_H


/* ==============================
	Constants
   ============================== */

/*! Maximum number of MSP diagnostic function codes to be activated */
#define	MAX_DIAG_FUNCTION_CODE 10


/* ==============================
	Types
   ============================== */


/*! MSP diagnostics redirection structure */
typedef struct diag_redirect
{
	unsigned char mode;
		/*! Previously type */
	unsigned char src_mac[6];
		/*! Source MAC address */
	unsigned char dst_mac[6];
		/*! Destination MAC address */
	unsigned int src_ip;
		/*! Source IP address */
	unsigned int dst_ip;
		/*! Destination IP address */
	unsigned short src_udp;
		/*! Source UDP port */
	unsigned short dst_udp;
		/*! Destination UDP port */
} diag_redirect_t;


/*! Diagnostics */
typedef struct diag {
	int nb_fc;
		/*! Number of MSP API diags. function codes to be applied on the device */
	unsigned char fc[MAX_DIAG_FUNCTION_CODE];
		/*! Array storing the MSP API function codes to be applied on the MSP */
	diag_redirect_t redirect;
		/*! structure defining the diags mode and network info */
} diag_t;


/*! Debug module configuration file */
typedef struct debug_cfg {
	diag_t diag;
} debug_cfg_t;


/* ==============================
	Function Prototypes
   ============================== */

/*
int diag_redirect(diag_redirect_t *diag_redirect, int device_id);
int diag_redirect(unsigned int id, unsigned char command_class, unsigned char command_type, unsigned short function_code, unsigned char action);
int diag_init(diag_t *diag);
*/
debug_cfg_t *get_debug_cfg(const char *cfg_file);
void display_debug_cfg(debug_cfg_t *debug_cfg);
int debug_init(debug_cfg_t *debug_cfg);


/* ==============================
	Variables
   ============================== */


debug_cfg_t *debug_cfg;

#endif /* __DEBUG_H */

/*! @} */
