/*
 * Copyright (C) 2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed (R) libtsi and is distributed under
 * the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and
 * conditions of the Agreement.
 *
 */

#ifndef __LIBTSI
#define __LIBTSI

#ifdef __cplusplus
extern "C" {
#endif


#define	LIBTSI_MAJOR		0
#define LIBTSI_MINOR		1


#define TSI_CR(base)		(((volatile unsigned short*)(base))[0x0000])
#define TSI_LCDR(base, i)	(((volatile unsigned short*)(base))[0x0003 + (i)])
#define TSI_LIDR(base, i)	(((volatile unsigned short*)(base))[0x0023 + (i)])
#define TSI_BCDR(base, i)	(((volatile unsigned short*)(base))[0x0043 + (i)])
#define TSI_BIDR(base, i)	(((volatile unsigned short*)(base))[0x0063 + (i)])
#define TSI_LOAR(base, i)	(((volatile unsigned short*)(base))[0x0083 + (i)])
#define TSI_BOAR(base, i)	(((volatile unsigned short*)(base))[0x00A3 + (i)])
#define TSI_LIBRR(base, i)	(((volatile unsigned short*)(base))[0x00CD + (i)])
#define TSI_LOBRR(base, i)	(((volatile unsigned short*)(base))[0x00ED + (i)])
#define TSI_BIBRR(base, i)	(((volatile unsigned short*)(base))[0x010D + (i)])
#define TSI_BOBRR(base, i)	(((volatile unsigned short*)(base))[0x012D + (i)])
#define TSI_RCR(base)		(((volatile unsigned short*)(base))[0x3FFF])


#define TSI_PORT_LOCAL		0x00
#define TSI_PORT_BACKPLANE	0x40

/*
 * Connects given input stream channels to output stream channels.
 *
 * Arguments:
 *	base - TSI chip virtual base address
 *
 *	instream, outstream - input and output stream numbers, in order to
 *		specify backplane port for the stream - use TSI_PORT_BACKPLANE
 *		macro to 'or' with a stream number
 *
 *	inch, outch - base input and output channel numbers
 *
 *	instep, outstep - if number of channels > 1, step is used in cycle to update input
 *		and output channels numbers, zero input step allows to create 'broadcast'
 *		connections when one input channel connected to several output channels
 *
 *	count - number of channels to connect
 */
int tsi_connect(void *base,
		char instream, char outstream,
		unsigned char inch, unsigned char outch,
		char instep, char outstep, char count);

/*
 * Drives pattern on specific output stream channels. May be used to disconnect inputs
 * from given outputs.
 *
 * Arguments:
 *	base - TSI chip virtual base address
 *
 *	stream - input and output stream numbers, in order to
 *		specify backplane port for the stream - use TSI_PORT_BACKPLANE
 *		macro to 'or' with a stream number
 *
 *	ch - base input and output channel numbers
 *
 *	pattern - value to drive on given channels
 *
 *	step - if number of channels > 1, step is used in cycle to update input
 *		and output channels numbers
 *
 *	count - number of channels to connect
 */
int tsi_pattern(void *base,
		char stream, unsigned char ch,
		unsigned char pattern,
		char step, char count);

/*
 * Maps physical memory occupied by TSI device memory to virtual address space.
 * Always ok for VxWorks.
 *
 * Arguments:
 *	phys - physical address of TSI device
 *
 *	base - mapped virtual address
 */
int tsi_map(unsigned long phys, void **base);

/*
 * Unmaps virtual memory previously mapped by tsi_map().
 * Always ok for VxWorks.
 *
 * Arguments:
 *	base - virtual address of TSI device
 */
int tsi_unmap(void *base);


#ifdef __cplusplus
}
#endif

#endif
