/*! \file ut_types.h 
 * Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

#ifndef _UT_PORT_H
#define _UT_PORT_H

#include <msgQLib.h>
#include <semLib.h>
#include <signal.h>
#include <semLib.h>
#include <timers.h>
#include <sigLib.h>
#include <time.h>
#include <timers.h>
#include <stdarg.h>
#include <fcntl.h>
#include <pipeDrv.h>

typedef unsigned char		U8;
typedef unsigned short		U16;
typedef unsigned int		U32;
typedef signed char		S8;
typedef signed short		S16;
typedef signed int		S32;
typedef int			INT;

typedef enum { False, True }	Boolean;

typedef SEM_ID			SSem;
typedef SEM_ID			SMutex;

#define MAX_LOG_ENTRIES		100
#define BUFFER_SIZE		1024

/***********************
Thread related utility 
************************/

typedef void *(*PFNThreadEntry) (void *);
#define UT_taskPriorityGet(a, b)	taskPriorityGet(a, b)

#define UT_SET_DEF_PRIO(prio)		do { UT_taskPriorityGet(0, &prio); } while(0)
#define UT_DEF_STACK_SZ			(20 * 1024)
#define UT_DEF_TASK_OPT			(VX_FP_TASK)

/* priority relative of the VAPI root task */
#define PRIO_CSME_RX	(-1)
#define PRIO_GTL_RX		(0)
#define PRIO_GTL_TX		(0)
#define PRIO_GTL_TIMER	(0)
#define PRIO_UT_TIMER	(0)


/* VAPI/GTL task names */
#define NAME_CSME_RX		"tCsmeRx"
#define NAME_GTL_RX		"tGtlRx"
#define NAME_GTL_TX		"tGtlTx"
#define NAME_GTL_TIMER		"tGtlTimer"
#define NAME_UT_TIMER		"tUtTimer"

typedef struct _SThread {
	int iTaskId;
} SThread;

#define UT_ThreadPriorityAdjust(thread,  prio,  adjust) do { \
							{									 \
								taskPriorityGet(taskIdSelf(), &prio);       \
								taskPrioritySet(thread->iTaskId, prio + adjust);	 \
							} } while(0)
/**********************
Message Queue Utilities
***********************/
/**It creates a FIFO message queue*/
MSG_Q_ID UT_MsgQCreate_FIFO(int maxMess, int maxLen);

/**It deletes the message queue passed in*/
STATUS UT_MsgQDelete(MSG_Q_ID msgQId);

/**It sends a message on a message queue*/
STATUS UT_MsgQSend(MSG_Q_ID msgQId,	/* message queue on which to send */
		   char *buffer,	/* message to send */
		   UINT nBytes,	/* length of message */
		   int timeout,	/* ticks to wait */
		   int priority	/* MSG_PRI_NORMAL or MSG_PRI_URGENT */
	);

/**It gets a message from a message queue*/
int UT_MsgQReceive(MSG_Q_ID msgQId,	/* message queue from which to receive */
		   char *buffer,	/* buffer to receive message */
		   UINT maxNBytes,	/* length of buffer */
		   int timeout	/* ticks to wait */
	);

void CSME_PrintStat(void);

/**Commonly used functions*/
#define UT_malloc(a)				malloc(a)
#define UT_calloc(a, b)				calloc(a, b)
#define UT_free(a)				free(a)

#define UT_fopen(a, b)				fopen(a, b)
#define UT_fclose(a)				fclose(a)
#define UT_va_start(a, b)			va_start(a, b)
#define UT_va_end(a)				va_end(a)
#define UT_IsDigit(a)				isdigit(a)
#define UT_atoi(a)				atoi(a)

#define UT_StrCpy(dest_addr, src_addr)          strcpy(dest_addr, src_addr)
#define UT_StrnCpy(dest_addr, src_addr, s)	strncpy(dest_addr, src_addr, s)
#define UT_StrCat(dest_addr, src_addr)          strcat(dest_addr, src_addr)
#define UT_Sprintf                              sprintf
#define UT_StrLen(string)			strlen(string)
#define UT_StrCmp(string1, string2)		strcmp(string1, string2)
#define UT_MemSet(dest_addr, value, no_of_byte)	memset(dest_addr, value, no_of_byte)
#define UT_MemCmp(ptr1, ptr2, size)		memcmp(ptr1, ptr2, size)
#define UT_MemCopy(pvDest,pvSrc,uiSize)		memcpy(pvDest, pvSrc, uiSize)

int UT_Snprintf(char *str, int size, const char *format, ...);
int UT_Vsnprintf(char *str, int size, const char *format, va_list ap);

#define UT_Open(a, b, c)			open(a, b, c)
#define UT_Lseek(a, b, c)			lseek(a, b, c)
#define UT_Read(a, b, c)			read(a, b, c)
#define UT_Write(a, b, c)			write(a, b ,c)
#define UT_CloseFd(a)				close(a)

/**Specific vxworks used functions*/
#define UT_muxBind(a, b, c, d, e, f, g, h, i)	muxBind(a, b, c, d, e, f, g, h, i)
#define UT_muxUnbind(a,b, c)			muxUnbind(a, b, c)
#define UT_muxSend(a, b)			muxSend(a, b)

#ifdef VXWORKS_6_6
#define UT_netBufLibInit()			netBufLibInitialize(0)
#else
#define UT_netBufLibInit()			netBufLibInit()
#endif

#define UT_netPoolInit(a, b, c, d, e)		netPoolInit(a, b, c, d, e)
#define UT_netClPoolIdGet(a, b, c)		netClPoolIdGet(a, b, c)
#define UT_netMblkChainDup(a, b, c, e, f)	netMblkChainDup(a, b, c, e, f)
#define UT_netMblkClChainFree(a)		netMblkClChainFree(a)
#define UT_netMblkClFree(a)			netMblkClFree(a)
#define UT_netPoolDelete(a)			netPoolDelete(a)
#define UT_netTupleGet(a, b, c, d, e)		netTupleGet(a, b, c, d, e)
#define UT_ifunit(a)				ifunit(a)
#define UT_wdDelete(a)				wdDelete(a)
#define UT_wdCancel(a)				wdCancel(a) 
#define UT_wdCreate()				wdCreate()
#define UT_wdStart(a, b, c, d)			wdStart(a, b, c, d)

#define UT_semCCreate(a, b)			semCCreate(a, b)
#define UT_semMCreate(a)			semMCreate(a)
#define UT_semBCreate(a, b)			semBCreate(a, b)
#define UT_semTake(a, b)			semTake(a, b)
#define UT_semGive(a)				semGive(a)
#define UT_semDelete(a)				semDelete(a)

#define UT_PipeDevCreate(a, b ,c)		pipeDevCreate(a, b, c)

#define UT_lstAdd(a, b)				lstAdd(a, b)
#define UT_lstDelete(a, b)			lstDelete(a,b)
#define UT_lstFirst(a)				lstFirst(a)
#define UT_lstFree(a)				lstFree(a)
#define UT_lstInit(a)				lstInit(a)
#define UT_lstNext(a)				lstNext(a)

#define UT_msgQCreate(a, b, c)			msgQCreate(a, b, c)
#define UT_msgQReceive(a, b, c, d)		msgQReceive(a, b, c, d)
#define UT_msgQDelete(a)			msgQDelete(a)
#define UT_msgQSend(a, b, c, d, e)		msgQSend(a, b, c, d, e)
#define UT_msgQNumMsgs(a)			msgQNumMsgs(a)

#define UT_timer_cancel(a)			timer_cancel(a)
#define UT_timer_create(a, b, c)		timer_create(a, b, c)
#define UT_timer_connect(a, b, c)		timer_connect(a, b, c)
#define UT_timer_delete(a)			timer_delete(a)
#define UT_timer_settime(a, b, c, d)		timer_settime(a, b, c, d)

#define UT_sigemptyset(a)			sigemptyset(a) 
#define UT_signal(a, b)				signal(a, b) 
#define	UT_sigqueue(a, b, c)			sigqueue(a, b, c)
#define UT_sigsuspend(a)			sigsuspend(a)

#define UT_taskDelete(a)			taskDelete(a)
#define UT_taskSpawn(a, b, c, e, f, g, h, i, j, k, l, m, n, o, p)	\
						taskSpawn(a, b, c, e, f, g, h, i, j, k, l, m, n, o, p)

#define UT_logFdAdd(a)				logFdAdd(a)
#define UT_logFdDelete(a)			logFdDelete(a)
#define UT_logMsg(a, b, c, d, e, f, g)		logMsg(a, b, c, d, e, f, g)
#define UT_fioFormatV(a, b, c, d)		fioFormatV(a, b, c, d)

#define UT_sysClkRateGet()			sysClkRateGet()
#define UT_clock_gettime(a, b)			clock_gettime(a, b)

#define UT_nanosleep(a, b)			nanosleep(a, b)

#define UT_Htons(usWord)			htons(usWord)
#define UT_Ntohs(usWord)			ntohs(usWord)
#define UT_Htonl(ulWord)			htonl(ulWord)
#define UT_Ntohl(ulWord)			ntohl(ulWord)

#endif /* _UT_PORT_H */
