/*! \file teth.h 
 * Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

#ifndef _TETH_H
#define _TETH_H

#include "gtl.h"


/* Boot Loader Message Indication */
#define MAAS_ASSIGN_CMD_TYPE	0x1b
#define CMD_CLASS_BOOT_MSG	0x04

/** Desription: This function should be called by GTL Mapper at
                start up before issuing any other command. It
                initializes the internal data structures & sets the
                client callback function */
int TETH_Init (GTL_READ_CB, OUT STAdapterFns *pstAdapterFns, SGtlDeviceInfo *, U32);
int gtl_csme_print_device_stats(IN DEVID dev_id, int clear_stats);

/*
 * List of error codes
 */

#define GTL_TETH_ERR_BASE			69000
#define GTL_TETH_ERR_START			-(GTL_TETH_ERR_BASE)
#define GTL_TETH_ERR_INITIALIZATION		-(GTL_TETH_ERR_BASE + 1)
#define GTL_TETH_ERR_SHUTDOWN			-(GTL_TETH_ERR_BASE + 2)
#define GTL_TETH_ERR_ALREADY_INITIALIZED	-(GTL_TETH_ERR_BASE + 3)
#define GTL_TETH_ERR_NOT_INITIALIZED		-(GTL_TETH_ERR_BASE + 4)
#define GTL_TETH_ERR_NULL_POINTER_PASSED	-(GTL_TETH_ERR_BASE + 5)
#define GTL_TETH_ERR_MAX_DEV_OPEN		-(GTL_TETH_ERR_BASE + 6)
#define GTL_TETH_ERR_UNKNOWN			-(GTL_TETH_ERR_BASE + 7)
#define GTL_TETH_ERR_NOMEM			-(GTL_TETH_ERR_BASE + 8)
#define GTL_TETH_INVALID_DEV			-(GTL_TETH_ERR_BASE + 9)
#define GTL_TETH_DEV_ALREADY_ADDED		-(GTL_TETH_ERR_BASE + 10)
#define GTL_TETH_MSG_NOT_SUPPORTED		-(GTL_TETH_ERR_BASE + 11)
#define GTL_TETH_ERR_END			-(GTL_TETH_ERR_BASE + 12)

#endif /* _TETH_H */
