/* Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

#ifndef __IF_CSM_ENCAPS_H
#define __IF_CSM_ENCAPS_H

#define CSME_VERSION_MAJOR	0
#define CSME_VERSION_MINOR	3
#define CSME_VERSION_MICRO	0

#define CSME_VERSION(a,b,c) (((a) << 16) + ((b) << 8) + (c))
#define CSME_RELEASE CSME_VERSION(CSME_VERSION_MAJOR, CSME_VERSION_MINOR, CSME_VERSION_MICRO)

#define ETH_ALEN		6
#define ETH_P_CSME		0x889B
#define CSME_PROTO_NAME	"csmencaps"
#define CSME_IFNAME_MAX	12
#define SOL_CSME		269


/* values for get/set options */
#define CSME_ACK_ENABLE	1
#define CSME_TARGET_RESET	2
#define CSME_USER_SET		3


struct sockaddr_csme {
	unsigned char	scsme_devmac[ETH_ALEN];		/* device MAC address */
	unsigned short	scsme_opcode;			/* opcode */
	unsigned short	scsme_channelid;		/* Channel ID  */
	unsigned short	scsme_flags;
	char		scsme_ifname[CSME_IFNAME_MAX];	/* interface name, long enough to hold names like 'ethXX\0' */
	void		*scsme_user;			/* pointer, specific to caller code, driver doesn't touch it */
};

#define	CSME_OPCODE_NOOP		0x0000
#define	CSME_OPCODE_CONTROL		0x0001
#define	CSME_OPCODE_RESERVED		0x0002
#define CSME_OPCODE_UNIFIED_DIAGNOSTICS	0x0003
#define CSME_OPCODE_REMOTE_MEDIA	0x0004
#define CSME_OPCODES_NUMBER		5


struct csme_ackopt {
	unsigned char	scsme_devmac[ETH_ALEN];	/* Targer Device MAC */
	char		scsme_ifname[CSME_IFNAME_MAX];	/* interface name */
	unsigned char	ack_suppression;	/* 0 = ACK Packet is required(default)
   						 * 1 = ACK packet must be suppressed
						 */
};

struct csme_resetopt {
	unsigned char	scsme_devmac[6];	/* Target Device MAC */
	unsigned char	scsme_newmac[6];	/* Target Device new MAC */
};

struct csme_usersetopt {
	unsigned char	scsme_devmac[6];	/* Target Device MAC */
	void 		*csme_user;
};

int	csmencaps_sendmsg(void *buffer, unsigned int len, struct sockaddr_csme *saddr);
int	csmencaps_recvmsg(void *buffer, unsigned int *len, struct sockaddr_csme *saddr);
int	csmencaps_bind(const char *ifname);
int	csmencaps_unbind(const char *ifname);
int	csmencaps_setsockopt(int level, int optname, char *optval, int optlen);

void	csmencaps_exit(void);
int	csmencaps_init(void);

int	csmencaps_print_target_mac_stats(unsigned char *mac_addr, int clear_stats);
void	csmencaps_print_stats(int clear_stats);

#endif	/* __IF_CSM_ENCAPS_H */
