/* Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

#ifndef _CSM_ENCAPS_H
#define _CSM_ENCAPS_H

#include <lstLib.h>
#include <semLib.h>
#include <netBufLib.h>
#include <muxLib.h>
#include <etherLib.h>
#include <sysLib.h>
#include <wdLib.h>
#include "ut.h"
#include "gtl.h"


#define	CSME_CBF_ACK_BIT		0x80
#define	CSME_CBF_ACK_SUPR_BIT		0x40
#define CSME_CBF_LITTLE_END		0x01
#define CSME_CBF_BOOTLOAD_BIT		0x01

#define CMD_CLASS_ETH_BOOT_LDR		0x04
#define CMD_CLASS_CONFIGURATION_DEVICE	0x06

#define CMD_TYPE_MASS_ASSIGN		0x1B
#define CMD_TYPE_QUERY_READY		0x1E
#define CMD_TYPE_READY			0x20
#define CMD_TYPE_CONFIGURATION_RESPONSE 0x02

/* function code for Command class 0x06 */
#define FCODE_SUPV_CREATE_CHANNEL	0x0010
#define FCODE_SUPV_DESTROY_CHANNEL	0x0011
#define FCODE_CONF_CREATE_PARTICIPANT	0x9312

#define CSME_MAX_CHANNELS		640
#define CSME_MAX_DEVICES		1


struct csme_hdr
{
	U16 opcode;

	U8 seq_number;
#if !defined(VAPI_BIGENDIAN)
	U8 endianess:1;
	U8 reserved:5;
	U8 ack_sup:1;
	U8 cr:1;
#else
	U8 cr:1;
	U8 ack_sup:1;
	U8 reserved:5;
	U8 endianess:1;
#endif

	U16 channel_nb;
};

struct api_hdr
{
	U8 length;
	U8 index;

	U8 cmd_type;
	U8 cmd_class;

	U16 func_code;
	U16 reserved;
};

struct api_hdr_boot
{
	U8 index;
	U8 length;

	U8 cmd_class;
	U8 cmd_type;

	U16 func_code;
};

struct csme_channel {
	struct csme_target *target;	/* target under which this channel is created */
	unsigned short id;	/* channel ID/ number assigned to this channel */

	MSG_Q_ID tx_queue;
	U8 tx_seq_number[CSME_OPCODES_NUMBER];

	SEM_ID lock;

	WDOG_ID timer;

	struct itimerspec timeout;
	int retries;

	U8 last_rx_seq_number[CSME_OPCODES_NUMBER];
};

struct csme_stats {
	SEM_ID lock;
	
	U32 tx_msg;
	U32 tx_msg_total_retransmitted;
	U32 tx_msg_max_retransmissions;
	U32 tx_msg_retransmitted;
	U32 tx_msg_err;

	U32 rx_ack;
	U32 rx_ack_wrongseq;
	U32 rx_ack_err;

	U32 rx_msg;
	U32 rx_msg_repeated;
	U32 rx_msg_err;

	U32 tx_ack;
	U32 tx_ack_err;
};

struct csme_iface {
	NODE		*next;
	NODE		*prev;

	SEM_ID		lock;
	int		refcount;		/* holds how many times this interface was opened */
	char		down;			/* non-zero if interface can't accept packets */
	char		ifname[CSME_IFNAME_MAX];	/* full interface name, e.g. 'eth0' - where 'eth' is a base name and 0 is an interface index */
	char		ifbasename[CSME_IFNAME_MAX];	/* base name of the interface */
	int		ifindex;		/* interface index (unit #) */
	unsigned char	ifaddr[ETH_ALEN];	/* cached interface MAC address */
	void		*mux;			/* MUX binding cookie */
};

struct csme_target {
	NODE * next;
	NODE * prev;

	unsigned char macaddr[ETH_ALEN];	/* MAC address of the target */
	struct csme_iface *iface;		/* host interface information */

	/* New Channel Stuff */
	struct csme_channel boot_channel;	/* channel used while bootloading */
	struct csme_channel supvsr_channel;	/* supervisory channel */

	SEM_ID lock;

	struct csme_channel *channel[CSME_MAX_CHANNELS];	/* table of channels in this target */

	int scsme_ifindex;
	unsigned char ack_suppression;

	struct csme_stats stats;

	void *scsme_user;
};

#endif /* _CSM_ENCAPS_H */
