/*! \file ut_types.h 
 * Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

#ifndef _UT_PORT_H
#define _UT_PORT_H

#include <fcntl.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <pthread.h>
#include <semaphore.h>
#include <signal.h>
#include <sys/time.h>


typedef unsigned char		U8;
typedef unsigned short		U16;
typedef unsigned int		U32;
typedef signed char		S8;
typedef signed short		S16;
typedef signed int		S32;
typedef int			INT;
typedef unsigned int		UINT;

typedef enum { False, True }	Boolean;
typedef int			STATUS;

typedef pthread_t		SThread;
typedef sem_t			SSem;
typedef pthread_mutex_t		SMutex;

#define BUFFER_SIZE		1024

/***********************
Thread related utility 
************************/
typedef void *(*PFNThreadEntry) (void *);

/**********************
Message Queue Utilities
***********************/
typedef int			*MSG_Q_ID;
#define WAIT_FOREVER		(-1)
#define NO_WAIT			0
#define MSG_PRI_NORMAL		0
#define OK			0
#define ERROR			(-1)

/**It creates a FIFO message queue*/
MSG_Q_ID UT_MsgQCreate_FIFO(int maxMess, int maxLen);

/**It deletes the message queue passed in*/
STATUS UT_MsgQDelete(MSG_Q_ID msgQId);

/**It sends a message on a message queue*/
STATUS UT_MsgQSend(MSG_Q_ID msgQId,	/* message queue on which to send */
		   char *buffer,	/* message to send */
		   U32 nBytes,		/* length of message */
		   int timeout,		/* ticks to wait */
		   int priority		/* MSG_PRI_NORMAL or MSG_PRI_URGENT */
	);

/**It gets a message from a message queue*/
int UT_MsgQReceive(MSG_Q_ID msgQId,	/* message queue from which to receive */
		   char *buffer,	/* buffer to receive message */
		   U32 maxNBytes,	/* length of buffer */
		   int timeout		/* ticks to wait */
	);

/**Other commonly used functions*/
#define UT_malloc(a)				malloc(a)
#define UT_calloc(a, b)				calloc(a, b)
#define UT_free(a)				free(a)

#define UT_fopen(a, b)				fopen(a, b)
#define UT_fclose(a)				fclose(a)
#define UT_va_start(a, b)			va_start(a, b)
#define UT_va_end(a)				va_end(a)
#define UT_IsDigit(a)				isdigit(a)
#define UT_atoi(a)				atoi(a)

#define UT_StrCpy(dest_addr, src_addr)          strcpy(dest_addr, src_addr)
#define UT_StrnCpy(dest_addr, src_addr, s)	strncpy(dest_addr, src_addr, s)
#define UT_StrCat(dest_addr, src_addr)          strcat(dest_addr, src_addr)
#define UT_Sprintf                              sprintf
#define UT_StrLen(string)			strlen(string)
#define UT_StrCmp(string1, string2)		strcmp(string1, string2)
#define UT_MemSet(dest_addr, value, no_of_byte)	memset(dest_addr, value, no_of_byte)
#define UT_MemCmp(ptr1, ptr2, size)		memcmp(ptr1, ptr2, size)
#define UT_MemCopy(pvDest,pvSrc,uiSize)		memcpy(pvDest, pvSrc, uiSize)
#define UT_Snprintf				snprintf
#define UT_Vsnprintf				vsnprintf

#define UT_Open(a, b, c)			open(a, b, c)
#define UT_Lseek(a, b, c)			lseek(a, b, c)
#define UT_Read(a, b, c)			read(a, b, c)
#define UT_Write(a, b, c)			write(a, b ,c)
#define UT_CloseFd(a)				close(a)

#define UT_Htons(usWord)			htons(usWord)
#define UT_Ntohs(usWord)			ntohs(usWord)
#define UT_Htonl(ulWord)			htonl(ulWord)
#define UT_Ntohl(ulWord)			ntohl(ulWord)

#endif /* _UT_PORT_H */
