/*! \file tpci.h 
 * Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

#ifndef _TPCI_H
#define _TPCI_H

#include "gtl.h"

/*
 * List of error codes
 */

#define GTL_TPCI_ERR_BASE			79000
#define GTL_TPCI_ERR_START			-(GTL_TPCI_ERR_BASE)
#define GTL_TPCI_ERR_INITIALIZATION		-(GTL_TPCI_ERR_BASE + 1)
#define GTL_TPCI_ERR_SHUTDOWN			-(GTL_TPCI_ERR_BASE + 2)
#define GTL_TPCI_ERR_ALREADY_INITIALIZED	-(GTL_TPCI_ERR_BASE + 3)
#define GTL_TPCI_ERR_NOT_INITIALIZED		-(GTL_TPCI_ERR_BASE + 4)
#define GTL_TPCI_ERR_NULL_POINTER_PASSED	-(GTL_TPCI_ERR_BASE + 5)
#define GTL_TPCI_ERR_MAX_DEV_OPEN		-(GTL_TPCI_ERR_BASE + 6)
#define GTL_TPCI_ERR_UNKNOWN			-(GTL_TPCI_ERR_BASE + 7)
#define GTL_TPCI_ERR_NOMEM			-(GTL_TPCI_ERR_BASE + 8)
#define GTL_TPCI_ERR_INVALID_DEV		-(GTL_TPCI_ERR_BASE + 9)
#define GTL_TPCI_DEV_ALREADY_ADDED		-(GTL_TPCI_ERR_BASE + 10)
#define GTL_TPCI_ERR_DEVLVL			-(GTL_TPCI_ERR_BASE + 11)
#define GTL_TPCI_ERR_DEVSTATE			-(GTL_TPCI_ERR_BASE + 12)
#define GTL_TPCI_ERR_FATAL			-(GTL_TPCI_ERR_BASE + 13)
#define GTL_TPCI_ERR_END			-(GTL_TPCI_ERR_BASE + 14)


/************************ BRM Mesg defs ****************************/

#define PCI_BRM_ERRIND				0x00
#define PCI_BRM_BYTEREAD			0x02
#define PCI_BRM_BYTEWRITE			0x03
#define PCI_BRM_FIFOREAD			0x04
#define PCI_BRM_FIFOWRITE			0x05
#define PCI_BRM_PROGSTART			0x06
#define PCI_BRM_ZEROFILL			0x08
#define PCI_BRM_WORDREAD			0x0A
#define PCI_BRM_WORDWRITE			0x0B
#define PCI_BRM_SET_CLOCK			0x0C
#define PCI_BRM_SET_SDRAM_PARAMS_1 		0x0D
#define PCI_BRM_SET_SDRAM_PARAMS_2		0x0E
#define PCI_BRM_SET_CS_PARAMS			0x0F
#define PCI_BRM_RUN_CHECKSUM			0x10
#define PCI_BRM_GET_VERSION			0x11
#define PCI_BRM_READY				0x12
#define PCI_BRM_READY_ACK			0x13
#define PCI_BRM_CMD_ACK				0x14
#define PCI_BRM_SET_ARM_CLKMODE			0x15
#define PCI_BRM_DOUBLE_WORDREAD			0x16
#define PCI_BRM_DOUBLE_WORDWRITE_ADDR		0x17
#define PCI_BRM_DOUBLE_WORDWRITE_DATA		0x18
#define PCI_BRM_FIFOWRITE_BURST			0x19
#define PCI_BRM_SET_ICACHE			0x1A
#define PCI_BRM_SET_PLL_CLOCK			0x1F

#endif
