#include <vapi/vapi_build_option.h>

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <vapi/vapi.h>
#include <vapi/gtl.h>
#include <vapi/msp.h>



#define FC_GET_ARM_CODE_VERSION 	UT_CPU2LE16(0x0021)
#define FC_GET_SPU_CODE_VERSION 	UT_CPU2LE16(0x0022)
#define FC_GET_DEVICE_TYPE 		UT_CPU2LE16(0x0031)


SPCIUsrData	gtl_pci_config = {
	.pvNext = NULL,					/**< pointer to next device */
	.usControlInterface = ePCI_ITF,			/**< control interface to use */
	.uiDevId = 0,					/**< device ID */
	.uiVersion = 0,					/**< Version infor (not used) */
	.eDevMode = eSLAVE,				/**< Slave / Master mode */
	.ucDevType = DEV_TYPE_M823XX_2,			/**< Device type */
	.bUseDefaultMaxChnls = True,			/**< Default or custom max channels */
	.usMaxChannels = 0,				/**< Max Channels if above flag is custom */
	.pucPCIDevName = (char *)"/dev/comcerto0",	/**< host interface used to control the device */

};

SDeviceHeader	*gtl_device_configuration;

static void comcerto_indication_handler(EEventCode event, void *data)
{
	printf("indication: 0x%08x\n", event);
}

static void eth_service_config()
{
	void *message;
	VSTATUS result;
	U8 device_response[DEFAULT_FIFO_MAX_SIZE];
	U32 response_len = sizeof(device_response);

	message = VAPI_AllocateMessage(DEFAULT_FIFO_MAX_SIZE);
	if (message == NULL)
		return;

	result = VAPI_SetMessage(message, CMD_CLASS_CONF_DEVICE, CMD_TYPE_CONF_CHANGE, FC_ETH_SERVICE_CONFIG, 2, 0,0);
	if (result == SUCCESS) {
		result = VAPI_SendDeviceMessage(0, message, NULL, device_response, &response_len);
		if (result != SUCCESS) {
			printf("failed to configure Ethernet\n");
			exit(1);
		}
	}

	VAPI_FreeMessage(message);
}

static void phy_config()
{
	void *message;
	VSTATUS result;
	U8 device_response[DEFAULT_FIFO_MAX_SIZE];
	U32 response_len = sizeof(device_response);
	U16 *fifo;

	message = VAPI_AllocateMessage(DEFAULT_FIFO_MAX_SIZE);
	if (message == NULL)
		return;

	/* read reg. 20 */
	VAPI_InitMessage(message);
	result = VAPI_SetMessage(message,
		CMD_CLASS_CONF_DEVICE, CMD_TYPE_CONF_CHANGE,
		FC_MDIO_BUS_READ,
		4, 0,0, UT_CPU2LE16(20),0
	);
	if (result != SUCCESS)
		goto err;
	response_len = sizeof(device_response);
	result = VAPI_SendDeviceMessage(0, message, NULL, device_response, &response_len);
	if (result != SUCCESS)
		goto err;

	fifo = (U16*) &device_response[8];
	if (fifo[0] != 0)
		goto err;

printf("%04X %04X\n", UT_CPU2LE16(20), UT_CPU2LE16(UT_LE2CPU16(fifo[4])|0x0082));

	/* write reg. 20 back with bits 0x82 set (RGMII delay control) */
	VAPI_InitMessage(message);
	result = VAPI_SetMessage(message,
		CMD_CLASS_CONF_DEVICE, CMD_TYPE_CONF_CHANGE,
		FC_MDIO_BUS_WRITE,
		4, 0,0, UT_CPU2LE16(20),UT_CPU2LE16(UT_LE2CPU16(fifo[4])|0x0082)
	);
	if (result != SUCCESS)
		goto err;
	response_len = sizeof(device_response);
	result = VAPI_SendDeviceMessage(0, message, NULL, device_response, &response_len);
	if (result != SUCCESS)
		goto err;

	/* read reg. 0 */
	VAPI_InitMessage(message);
	result = VAPI_SetMessage(message,
		CMD_CLASS_CONF_DEVICE, CMD_TYPE_CONF_CHANGE,
		FC_MDIO_BUS_READ,
		4, 0,0, 0,0
	);
	if (result != SUCCESS)
		goto err;
	response_len = sizeof(device_response);
	result = VAPI_SendDeviceMessage(0, message, NULL, device_response, &response_len);
	if (result != SUCCESS)
		goto err;

	fifo = (U16*) &device_response[8];
	if (fifo[0] != 0)
		goto err;

	/* write reg. 0 back with bit 0x8000 set (reset PHY) */
	VAPI_InitMessage(message);
	result = VAPI_SetMessage(message,
		CMD_CLASS_CONF_DEVICE, CMD_TYPE_CONF_CHANGE,
		FC_MDIO_BUS_WRITE,
		4, 0,0, 0,UT_CPU2LE16(UT_LE2CPU16(fifo[4])|0x8000)
	);
	if (result != SUCCESS)
		goto err;
	response_len = sizeof(device_response);
	result = VAPI_SendDeviceMessage(0, message, NULL, device_response, &response_len);
	if (result != SUCCESS)
		goto err;

	VAPI_FreeMessage(message);

	sleep(2);

	printf("PHY configured\n");

	return;

err:
	printf("failed to configure PHY\n");
	exit(1);
}

int main(int argc, char *argv[])
{
	VSTATUS status;
	U8 device_mac[6] = { 0x00, 0x00, 0x02, 0x02, 0x00, 0x00 };
	U8 destination_mac[6] = { 0x00, 0x00, 0x01, 0x01, 0x00, 0x00 };

	if (argc != 2) {
		fprintf(stderr, "Usage: %s <FIRMWARE>\n", argv[0]);
		return 1;
	}

	status = VAPI_Init(&gtl_pci_config);
	if (status != SUCCESS) {
		fprintf(stderr, "VAPI_Init failed, status: %d\n", status);
		return 1;
	}

	status = VAPI_OpenDevice(0, comcerto_indication_handler);

	if (status != SUCCESS) {
		fprintf(stderr, "VAPI_OpenDevice failed, status: %d\n", status);
		return 1;
	}

	status = VAPI_BootDeviceFile(0, argv[1], NULL, NULL);
	if (status != SUCCESS) {
		fprintf(stderr, "VAPI_BootDeviceFile failed, status: %d\n", status);
		return 1;
	}

	usleep(1000);
	eth_service_config();
	usleep(1000);
	phy_config();
	usleep(1000);

	status = VAPI_SetEthMac(0, CMD_LEVEL_DEVICE, device_mac, destination_mac, NULL);
	if (status != SUCCESS) {
		fprintf(stderr, "VAPI_SetEthMac failed, status: %d\n", status);
		return 1;
	}

	VAPI_Close();

	return status;
}
