#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <vapi/vapi.h>
#include <vapi/gtl.h>
#include <vapi/msp.h>
#include <vapi/vapi_build_option.h>


#define FC_GET_ARM_CODE_VERSION 	UT_CPU2LE16(0x0021)
#define FC_GET_SPU_CODE_VERSION 	UT_CPU2LE16(0x0022)
#define FC_GET_DEVICE_TYPE 		UT_CPU2LE16(0x0031)


SPCIUsrData	gtl_pci_config = {
	.pvNext = NULL,					/**< pointer to next device */
	.usControlInterface = ePCI_ITF,			/**< control interface to use */
	.uiDevId = 0,					/**< device ID */
	.uiVersion = 0,					/**< Version infor (not used) */
	.eDevMode = eSLAVE,				/**< Slave / Master mode */
	.ucDevType = DEV_TYPE_M823XX_2,			/**< Device type */
	.bUseDefaultMaxChnls = True,			/**< Default or custom max channels */
	.usMaxChannels = 0,				/**< Max Channels if above flag is custom */
	.pucPCIDevName = (char *)"/dev/comcerto0",	/**< host interface used to control the device */

};

SDeviceHeader	*gtl_device_configuration;

static void comcerto_indication_handler(EEventCode event, void *data)
{
	printf("indication: 0x%08x\n", event);
}

static void display_firmware_version()
{
	void *message;
	VSTATUS result;
	U8 device_response[DEFAULT_FIFO_MAX_SIZE];
	U32 response_len = sizeof(device_response);

	message = VAPI_AllocateMessage(DEFAULT_FIFO_MAX_SIZE);
	if (message == NULL)
		return;

	result = VAPI_SetMessage(message, CMD_CLASS_CONF_DEVICE, CMD_TYPE_QUERY, FC_SUPVSR_GET_ARM_CODE_VERSION, 0);
	if (result == SUCCESS) {
		response_len = sizeof(device_response);
		result = VAPI_SendDeviceMessage(0, message, NULL, device_response, &response_len);
		if (result == SUCCESS)
			printf("FW  version: '%s'\n", &device_response[8]);
	}

	VAPI_InitMessage(message);
	result = VAPI_SetMessage(message, CMD_CLASS_CONF_DEVICE, CMD_TYPE_QUERY, FC_SUPVSR_GET_SPU_CODE_VERSION, 0);
	if (result == SUCCESS) {
		response_len = sizeof(device_response);
		result = VAPI_SendDeviceMessage(0, message, NULL, device_response, &response_len);
		if (result == SUCCESS)
			printf("SPU version: '%s'\n", &device_response[8]);
	}

	VAPI_InitMessage(message);
	result = VAPI_SetMessage(message, CMD_CLASS_CONF_DEVICE, CMD_TYPE_QUERY, FC_SUPVSR_GET_DEVICE_TYPE, 0);
	if (result == SUCCESS) {
		response_len = sizeof(device_response);
		result = VAPI_SendDeviceMessage(0, message, NULL, device_response, &response_len);
		if (result == SUCCESS)
			printf("Device type: 0x%02x\n", device_response[8]);
	}

	VAPI_FreeMessage(message);
}

int main(int argc, char *argv[])
{
	VSTATUS status;

	status = VAPI_Init(&gtl_pci_config);
	if (status != SUCCESS) {
		fprintf(stderr, "VAPI_Init failed, status: %d\n", status);
		return 1;
	}


	status = VAPI_OpenDevice(0, comcerto_indication_handler);
	if (status != SUCCESS) {
		fprintf(stderr, "VAPI_OpenDevice failed, status: %d\n", status);
		return 1;
	}

	status = VAPI_InitDevice(0, VAPI_DEV_OPMODE_RECOVER, VAPI_DEV_PROF_DEFAULT, NULL, NULL);
	if (status != SUCCESS) {
		fprintf(stderr, "VAPI_InitDevice failed, status: %d\n", status);
		return 1;
	}

while (1)
	display_firmware_version();

	VAPI_Close();

	return status;
}
