#!/usr/bin/perl -w

# This is a simple script for decoding a comcerto_pci trace buffer
# Since it has no idea where the current location of the circular
# buffer is, it tries to re-sync based on the magic numbers.

use strict;
use File::stat;

my $tracefile = shift;
open(TRACEFILE, '<:raw', $tracefile);

my $st = stat($tracefile);
my $tracesize = $st->size;

if ($tracesize < 4096) {
    printf "File is too small\n";
    die;
}

my $contents = '';
sysread(TRACEFILE, $contents, $tracesize) == $tracesize or die;

close(TRACEFILE);

my $i = 0;
for (; $i <= ($tracesize - 4); ++$i) {
    my $magic = unpack('V', substr($contents, $i, 4));
    if ($magic == 0xFEF1F0F6 || $magic == 0xFEF1F0F7) {
        last;
    }
}

$contents .= $contents;

&doit;

for (; $i <= ($tracesize - 4); ++$i) {
    my $magic = unpack('V', substr($contents, $i, 4));
    if ($magic == 0xFEF1F0F6 || $magic == 0xFEF1F0F7) {
        last;
    }
}

&doit;

sub doit {
    while($i < $tracesize) {
        my ($magic, $timestamp, $fifo_len, @m)
            = unpack('V V v v4', substr($contents, $i, 18));
        
        printf("[%03X] ", $i);
        last if ($magic != 0xFEF1F0F6 && $magic != 0xFEF1F0F7);
        
        printf("%06.2f %s %04x %04x %04x %04x fifo=%d\n",
               $timestamp / 100, ($magic == 0xFEF1F0F6 ? 'R' : 'W'),
               $m[3], $m[2], $m[1], $m[0], $fifo_len);
        
        $i += 20;
        
        if ($fifo_len > 256) {
            $fifo_len = 256;
        }

        my @fifo = unpack('v*', substr($contents, $i, $fifo_len));
        my $k = 0;
        foreach my $word (@fifo) {
            printf " %04x", $word;
            if (++$k == 8) {
                $k = 0;
                print "\n";
            }
        }
        print "\n";
        
        $i += $fifo_len;
    }
}
