/*
 * comcerto_pci.h
 * PCI control plane driver. Public header.
 *
 * Copyright (C) 2010 Mindspeed Technologies
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __COMCERTO_PCI_H
#define __COMCERTO_PCI_H

#ifdef __KERNEL__
#include <linux/ioctl.h>
#else
#include <sys/ioctl.h>
#endif

#define COMCERTO_PCI_MAJOR		2
#define COMCERTO_PCI_MINOR		3
#define COMCERTO_PCI_VERSION		__stringify(COMCERTO_PCI_MAJOR) "." __stringify(COMCERTO_PCI_MINOR)

#ifndef PCI_VENDOR_ID_CONEXANT
#define PCI_VENDOR_ID_CONEXANT		0x14F1
#endif

#ifndef PCI_VENDOR_ID_MINDSPEED
#define PCI_VENDOR_ID_MINDSPEED		0x18DC
#endif

#ifndef PCI_VENDOR_ID_PLX
#define PCI_VENDOR_ID_PLX		0x10B5
#endif

#ifndef PCI_DEVICE_ID_MINDSPEED_M825XX
#define PCI_DEVICE_ID_MINDSPEED_M825XX	0x0130
#endif

#ifndef PCI_DEVICE_ID_CONEXANT_M826XX
#define PCI_DEVICE_ID_CONEXANT_M826XX	0x0110
#endif

#ifndef PCI_DEVICE_ID_MINDSPEED_M827XX
#define PCI_DEVICE_ID_MINDSPEED_M827XX	0x0120
#endif

#ifndef PCI_DEVICE_ID_MINDSPEED_M829XX
#define PCI_DEVICE_ID_MINDSPEED_M829XX	0x0140
#endif

#ifndef PCI_DEVICE_ID_MINDSPEED_M823V1
#define PCI_DEVICE_ID_MINDSPEED_M823V1	0x0160
#endif

#ifndef PCI_DEVICE_ID_MINDSPEED_M823V2
#define PCI_DEVICE_ID_MINDSPEED_M823V2	0x0190
#endif

#ifndef PCI_DEVICE_ID_PLX_9030
#define PCI_DEVICE_ID_PLX_9030		0x9030
#endif

/* PLX 9030 Registers */
#define PLX_CNTRL_REG			0x50

/* Mailbox Registers */
#define TXMAIL0				0x30
#define TXMAIL1				0x34
#define TXMAIL2				0x38
#define TXMAIL3				0x3C

#define RXMAIL0				0x40
#define RXMAIL1				0x44
#define RXMAIL2				0x48
#define RXMAIL3				0x4C

/* FIFO Registers */
#define HOST_FIFO_CONTROL		0x0000
#define HOST_FIFO_STATUS		0x0004
#define HOST_FIFO_INTERRUPT_ACK		0x0004
#define HOST_TX_FIFO_SIZE		0x0010
#define HOST_TX_FIFO_HIGH_THRESHOLD	0x0014
#define HOST_TX_FIFO_LOW_THRESHOLD	0x0018
#define HOST_RX_FIFO_SIZE		0x0020
#define HOST_RX_FIFO_HIGH_THRESHOLD	0x0024
#define HOST_RX_FIFO_LOW_THRESHOLD	0x0028
#define HOST_RX_FIFO_DATA		0x0100
#define HOST_TX_FIFO_DATA		0x0100

/* Host FIFO Control Register bits */
#define	TGTABORTIE			(1 << 15)
#define	RXM3IE				(1 << 14)
#define	RXTHIE				(1 << 13)
#define	RXFIE				(1 << 12)
#define	RXCMPLTIE			(1 << 11)
#define	TXM3IE				(1 << 10)
#define	TXTHIE				(1 << 9)
#define	TXEIE				(1 << 8)
#define	TXCP_INH			(1 << 5)
#define	FIFO_EN				(TXFF_EN | TXRQ_EN | RXFF_EN | RXRQ_EN)
#define	RXRQ_EN				(1 << 4)
#define	RXFF_EN				(1 << 3)
#define	TXRQ_EN				(1 << 1)
#define	TXFF_EN				(1 << 0)

/* Host FIFO Status Register bits */
#define	TRGABORT			(1 << 15)
#define	RXM3I				(1 << 14)
#define	RXTH				(1 << 13)
#define	RXF				(1 << 12)
#define	RXCMPLT				(1 << 11)
#define	TXM3I				(1 << 10)
#define	TXTH				(1 << 9)
#define	TXE				(1 << 8)

/* Host FIFO Interrupt Acknowledge Register */
#define TRGABORTIAK			(1 << 9)
#define HSRESET				(1 << 8)
#define TXCMPLT				(1 << 7)
#define RXM3IAK				(1 << 6)
#define RXTHAK				(1 << 5)
#define RXFAK				(1 << 4)
#define RXCMPLTAK			(1 << 3)
#define TXM3IAK				(1 << 2)
#define TXTHIAK				(1 << 1)
#define TXEIAK				(1 << 0)

/* ioctl() interface */

/* the definitions below must match the one defined in tpci.h of the GTL user */

struct comcerto_info {
	unsigned short vendor;
	unsigned short device;
	unsigned short revision;
};

#define COMCERTO_IOCTL_BASE		0xCC

#define CIOC_RESET			_IO(COMCERTO_IOCTL_BASE, 0)
#define CIOC_GET_INFO			_IOR(COMCERTO_IOCTL_BASE, 1, struct comcerto_info*)

#ifdef __KERNEL__

enum {
	FC_SET_ETH_HDR			= 0x0100,
	FC_ETHPCI_SET_RX_BUF_PARAMS	= 0x0145,
	FC_ETHPCI_SET_RX_BUF_MAP	= 0x0146,
	FC_ETHPCI_RX_PACKET_IND		= 0x0147,
	FC_ETHPCI_XFER_TX_PACKET	= 0x0148,
	FC_ETHPCI_XFER_RX_PACKET	= 0x0149,
};

enum {
	CT_SUPVSR_READY			= 0x03D4,
	CT_DEVICE_CONFIG_CHANGE		= 0x0600,
	CT_DEVICE_CONFIG_RESPONSE	= 0x0602,
	CT_ALERT			= 0xC175,
};

int	comcerto_pci_sendmsg(struct pci_dev *pci_dev, u16 *mail, u16 *fifo, int fifo_len);

#endif

#endif
