/* Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <time.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <string.h>

#include "comcerto_pci.h"
#define IS_BRM_READY(m3, m2, m1, m0)	    \
	(((m3) & 0xFF00) == 0x1200	      \
	 && (m2) == 0x4321		      \
	 && (m1) == 0x8765		      \
	 && (m0) == 0xCBA9)

struct mailbox
{
	unsigned short reg3;
	unsigned short reg2;
	unsigned short reg1;
	unsigned short reg0;
};
struct mailbox my_mailbox;

int main ()
{
	int fd;
	int i, ret;
	unsigned short version[4]= {0x0, 0x0, 0x0, 0x1100};
	unsigned short PLL_WA_ADDR[4] = {0x0000, 0x100b,0x0000,0x1700};
	unsigned short PLL_WA_DATA[4] = {0x0000, 0x0004,0x0300,0x1800};
	unsigned short CLK[4] = {0x0000,0x0000,0x0014, 0x0c00};
	unsigned short ARM_CLK[4] = {0x0000,0x0000,0x0003, 0x1500};
	unsigned short SDRAM_PARAMS_1[4] = {0x0615,0x006a,0xd0db, 0x0d00};
	unsigned short SDRAM_PARAMS_2[4] = {0x0000,0x0000,0x0042, 0x0e00};
	unsigned short SET_CS_PARAMS[4] = {0x0000,0x0200,0x0000, 0x0f00};
	unsigned short FIFO_WRITE[264] = {0x0100,0x0080,0x0000, 0x0500};

	unsigned short readbuf[256];
	unsigned char fifo[256] = {
				0x01, 0x00 ,0x52, 0xE3, 0x0E, 0xF0, 0xA0, 0x31, 0xF0, 0x40, 0x2D, 0xE9, 0x00, 0x50, 0xA0, 0xE1,
				0x02, 0x01, 0x82, 0xE0, 0x00, 0x01, 0x81, 0xE0, 0x01, 0x40, 0xA0, 0xE1, 0x02, 0x60, 0xA0, 0xE1,
				0x14, 0x20, 0xA0, 0xE3, 0x00, 0x10, 0xA0, 0xE3, 0x14, 0x00, 0x40, 0xE2, 0x1B, 0x13, 0x00, 0xEB,
				0x05, 0x00, 0xA0, 0xE1, 0x14, 0x20, 0xA0, 0xE3, 0x00, 0x10, 0xA0, 0xE3, 0x17, 0x13, 0x00, 0xEB,
				0x01, 0x60, 0x56, 0xE2, 0x08, 0x00, 0x00, 0x0A, 0x06, 0x01, 0x86, 0xE0, 0x00, 0x71, 0x84, 0xE0,
				0x14, 0x00, 0x47, 0xE2, 0x14, 0x20, 0xA0, 0xE3, 0x00, 0x10, 0xA0, 0xE3, 0x0F, 0x13, 0x00, 0xEB,
				0x14, 0x70, 0x07, 0xE5, 0x01, 0x60, 0x56, 0xE2, 0xF6, 0xFF, 0xFF, 0x1A, 0x00, 0x40, 0x85, 0xE5,
				0xF0, 0x80, 0xBD, 0xE8, 0x00, 0xC0, 0x9D, 0xE5, 0x04, 0x00, 0x80, 0xE5, 0x00, 0x00, 0x80, 0xE5,
				0x0C, 0x20, 0x80, 0xE5, 0x00, 0x20, 0xA0, 0xE3, 0x10, 0x20, 0xC0, 0xE5, 0x08, 0x10, 0x80, 0xE5,
				0x11, 0x20, 0xC0, 0xE5, 0x13, 0xC0, 0xC0, 0xE5, 0x12, 0x30, 0xC0, 0xE5, 0x0E, 0xF0, 0xA0, 0xE1,
				0x10, 0x40, 0x2D, 0xE9, 0x00, 0xC0, 0xA0, 0xE1, 0x13, 0x30, 0xDC, 0xE5, 0x00, 0x20, 0xA0, 0xE1,
				0x0C, 0x20, 0xA0, 0xE1, 0x01, 0x10, 0x83, 0xE0, 0x01, 0x10, 0x41, 0xE2, 0x01, 0x30, 0x43, 0xE2,
				0x03, 0x30, 0xC1, 0xE1, 0x00, 0x00, 0xA0, 0xE3, 0x10, 0x10, 0xD2, 0xE5, 0x00, 0x00, 0x51, 0xE3,
				0x1D, 0x00, 0x00, 0x1A, 0x08, 0x10, 0x92, 0xE5, 0x03, 0x00, 0x51, 0xE1, 0x1A, 0x00, 0x00, 0x3A,
				0x08, 0x10, 0x92, 0xE5, 0x0C, 0x00, 0x92, 0xE5, 0x01, 0xE0, 0xA0, 0xE3, 0x03, 0x00, 0x51, 0xE1,
				0x10, 0xE0, 0xC2, 0x05, 0x10, 0x80, 0xBD, 0x08, 0x5C, 0xC0, 0x9F, 0xE5, 0x00, 0x10, 0x9C, 0xE5};

	unsigned short brmfiforead[4]= {0x100, 0x0080, 0x0000, 0x0400};

	if ((fd = open ("/dev/comcerto0", O_RDWR, 0)) < 0)
	{
		return fd;
	}

	ret = ioctl (fd, CIOC_RESET, 0);

	if (ret < 0)
	{
		perror ("CIOC_RESET");
	}

	ret = write(fd, PLL_WA_ADDR, 8);
	if (ret < 0)
	{
		printf ("comcerto_write\n");
	}

	ret = read(fd, (void*)readbuf, 256);

	ret = write(fd, PLL_WA_DATA, 8);
	if (ret < 0)
	{
		printf ("comcerto_write\n");
	}

	ret = read(fd, (void*)readbuf, 256);

	ret = write(fd, CLK, 8);
	if (ret < 0)
	{
		printf ("comcerto_write\n");
	}

	ret = read(fd, (void*)readbuf, 256);

	ret = write(fd, ARM_CLK, 8);
	if (ret < 0)
	{
		printf ("comcerto_write\n");
	}

	ret = read(fd, (void*)readbuf, 256);

	ret = write(fd, SDRAM_PARAMS_1, 8);
	if (ret < 0)
	{
		printf ("comcerto_write\n");
	}

	ret = read(fd, (void*)readbuf, 256);

	ret = write(fd, SDRAM_PARAMS_2, 8);
	if (ret < 0)
	{
		printf ("comcerto_write\n");
	}

	ret = read(fd, (void*)readbuf, 256);

	ret = write(fd, SET_CS_PARAMS, 8);
	if (ret < 0)
	{
		printf ("comcerto_write\n");
	}

	ret = read(fd, (void*)readbuf, 256);

	memcpy(&FIFO_WRITE[4], fifo, 256);
	ret = write(fd, FIFO_WRITE, 264);
	if (ret < 0)
	{
		printf ("comcerto_write\n");
	}

	ret = read(fd, (void*)readbuf, 256);
	return 0;
}
