/*! \file teth.h 
 * Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

#ifndef _TETH_H
#define _TETH_H

#include "gtl.h"


/* Boot Loader Message Indication */
#define MAAS_ASSIGN_CMD_TYPE	0x1b
#define CMD_CLASS_BOOT_MSG	0x04

/** Desription: This function should be called by GTL Mapper at
                start up before issuing any other command. It
                initializes the internal data structures & sets the
                client callback function */
int TETH_Init (GTL_READ_CB, OUT STAdapterFns *pstAdapterFns, SGtlDeviceInfo *, U32);

/*
 * List of error codes
 */

#define GTL_TETH_ERR_BASE			69000
#define GTL_TETH_ERR_START			-(GTL_TETH_ERR_BASE)
#define GTL_TETH_ERR_INITIALIZATION		-(GTL_TETH_ERR_BASE + 1)
#define GTL_TETH_ERR_SHUTDOWN			-(GTL_TETH_ERR_BASE + 2)
#define GTL_TETH_ERR_ALREADY_INITIALIZED	-(GTL_TETH_ERR_BASE + 3)
#define GTL_TETH_ERR_NOT_INITIALIZED		-(GTL_TETH_ERR_BASE + 4)
#define GTL_TETH_ERR_NULL_POINTER_PASSED	-(GTL_TETH_ERR_BASE + 5)
#define GTL_TETH_ERR_MAX_DEV_OPEN		-(GTL_TETH_ERR_BASE + 6)
#define GTL_TETH_ERR_UNKNOWN			-(GTL_TETH_ERR_BASE + 7)
#define GTL_TETH_ERR_NOMEM			-(GTL_TETH_ERR_BASE + 8)
#define GTL_TETH_INVALID_DEV			-(GTL_TETH_ERR_BASE + 9)
#define GTL_TETH_DEV_ALREADY_ADDED		-(GTL_TETH_ERR_BASE + 10)
#define GTL_TETH_MSG_NOT_SUPPORTED		-(GTL_TETH_ERR_BASE + 11)
#define GTL_TETH_ERR_END			-(GTL_TETH_ERR_BASE + 12)


/* these definitions must match the one in if_csmencaps.h of the kernel driver */
struct sockaddr_csme {
	sa_family_t	scsme_family;		/* AF_XXX family */
	int		scsme_ifindex;		/* interface index */
	unsigned char	scsme_devmac[6];	/* device MAC address */
	unsigned short	scsme_opcode;		/* opcode */
	unsigned short	scsme_channelid;	/* channel ID  */
	unsigned short	scsme_flags;		/* 1 == boot message */
	long long	scsme_user;		/* 64 bit field, specific to caller code, driver doesn't touch it */
};

struct csme_ackopt {
	unsigned char	scsme_devmac[6];	/* Target Device MAC */
	int		scsme_ifindex;		/* interface index */
	unsigned char	ack_suppression;	/* 0 = ACK Packet is required(default) */
						/* 1 = ACK packet must be suppressed */
};

struct csme_resetopt {
	unsigned char	scsme_devmac[6];	/* Target Device MAC */
	unsigned char	scsme_newmac[6];	/* Target Device new MAC */
};

struct csme_usersetopt {
	unsigned char	scsme_devmac[6];	/* Target Device MAC */
	long long	csme_user;
};

/* values for get/set options */
#define CSME_ACK_ENABLE		1
#define CSME_TARGET_RESET	2
#define CSME_USER_SET		3

#define SOL_CSME  	269

/* Packet types */
#define ETH_P_CSME	0x889B
#define AF_CSME		27
#define PF_CSME		AF_CSME

#define	CSME_OPCODE_NOOP		0x0000
#define	CSME_OPCODE_CONTROL		0x0001
#define	CSME_OPCODE_RESERVED		0x0002
#define CSME_OPCODE_UNIFIED_DIAGNOSTICS	0x0003
#define CSME_OPCODE_REMOTE_MEDIA	0x0004
#define CSME_OPCODES_NUMBER		5

#endif /* _TETH_H */
