/* Copyright © 2004-2010 Mindspeed Technologies, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __LINUX_IF_CSM_ENCAPS_H
#define __LINUX_IF_CSM_ENCAPS_H

#include <linux/if_ether.h>     /* for ETH_DATA_LEN */

#define CSME_VERSION_MAJOR	0
#define CSME_VERSION_MINOR	12
#define CSME_VERSION_MICRO	2

#define CSME_VERSION(a,b,c)	(((a) << 16) + ((b) << 8) + (c))
#define CSME_RELEASE 		CSME_VERSION(CSME_VERSION_MAJOR, CSME_VERSION_MINOR, CSME_VERSION_MICRO)

#define SOL_CSME		269

/* Packet types */
#define ETH_P_CSME		0x889B
#define AF_CSME			27
#define PF_CSME			AF_CSME



struct csme_cmd {
	int noofcommands;
};

/* the definitions below must match the one defined in teth.h of the GTL user */

/* values for get/set options */
#define CSME_ACK_ENABLE		1
#define CSME_TARGET_RESET	2
#define CSME_USER_SET		3

struct sockaddr_csme {
	sa_family_t	scsme_family;		/* AF_XXX family */
	int		scsme_ifindex;		/* interface index */
	unsigned char	scsme_devmac[6];	/* device MAC address */
	unsigned short	scsme_opcode;		/* opcode */
	unsigned short	scsme_channelid;	/* channel ID  */
	unsigned short	scsme_flags;		/* 1 == boot message */
	long long	scsme_user;		/* 64 bit field, specific to caller code, driver doesn't touch it */
};

#define	CSME_OPCODE_NOOP		0x0000
#define	CSME_OPCODE_CONTROL		0x0001
#define	CSME_OPCODE_RESERVED		0x0002
#define CSME_OPCODE_UNIFIED_DIAGNOSTICS	0x0003
#define CSME_OPCODE_REMOTE_MEDIA	0x0004
#define CSME_OPCODES_NUMBER		5


struct csme_ackopt {
	unsigned char	scsme_devmac[6];	/* target device MAC */
	int		scsme_ifindex;		/* interface index */
	unsigned char	ack_suppression;	/* 0 = ACK packet is required(default) */
						/* 1 = ACK packet must be suppressed */
};

struct csme_resetopt {
	unsigned char	scsme_devmac[6];	/* target device MAC */
	unsigned char	scsme_newmac[6];	/* target device new MAC */
};

struct csme_usersetopt {
	unsigned char	scsme_devmac[6];	/* target device MAC */
	long long	csme_user;
};

#endif	/* __LINUX_IF_CSM_ENCAPS_H */
