/*! \file voip_defaults.c 
 * Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */


#include "ut.h"
#include "vapi.h"
#include "vcore.h"
#include "vcore_voip.h"
#include "msp.h"

void DMGR_SetVoIPDefaults(SVoIPChnlParams * pstChnlParams)
{
	struct _VOIP_VOPENA *pstVopena = NULL;
	struct _VOIP_DTMFOPT *pstDtmfOpt = NULL;
	struct _VOIP_DGAIN *pstDgain = NULL;
	struct _VOIP_DFECAN *pstDfeCan = NULL;
	struct _VOIP_ECHOCAN *pstEchoCan = NULL;
	struct _VOIP_VCEOPT *pstVoiceOpt = NULL;
	struct _VOIP_TONECTRL *pstToneCtrl = NULL;
	struct _VOIP_TONES_RELAY_OPTION *pstToneRelay = NULL;
	struct _SET_IP_HDR_CHANNEL *pstIpHdrParams = NULL;
	struct _FAXOPT *pstFaxOpts = NULL;
	struct _FAXLVL *pstFaxLevel = NULL;

	if (pstChnlParams == NULL)
		return;

	pstVopena = &(pstChnlParams->stVopena);
	pstVopena->mode = VOIP_VOPENA_MODE_ENABLE_RTP;
	pstVopena->param_5.bits.rtp_m = 0;
	pstVopena->param_5.bits.rtp_pt = VOIP_VOPENA_RTP_PT_PCMU;
	pstVopena->param_5.bits.rtp_v = VOIP_VOPENA_RTP_V_DEFAULT;
	pstVopena->param_5.bits.rtp_p = VOIP_VOPENA_RTP_P_DEFAULT;
	pstVopena->param_5.bits.rtp_x = VOIP_VOPENA_RTP_X_DEFAULT;
	pstVopena->param_5.bits.rtp_cc = 0;
	pstVopena->rtp_seq = VOIP_VOPENA_RTP_SEQ_DEFAULT;
	pstVopena->rtp_timestamp  = 0;
	pstVopena->rtp_ssrc = 0x12345678;

	/* VCEOPT */
	pstVoiceOpt = &(pstChnlParams->stVoiceOpt);
	pstVoiceOpt->param_4.bits.packet_interval = 20;
	pstVoiceOpt->param_4.bits.vadtype = VOIP_VCEOPT_VADTYPE_DEFAULT;
	pstVoiceOpt->param_4.bits.adaptive_post_filter = VOIP_VCEOPT_ADAPTIVE_POST_FILTER_DEFAULT;
	pstVoiceOpt->param_4.bits.g_723_rate = VOIP_VCEOPT_G_723_RATE_DEFAULT;
	pstVoiceOpt->param_4.bits.packet_generation = VOIP_VCEOPT_PACKET_GENERATION_DISABLE;
	pstVoiceOpt->param_4.bits.g_723_dc_removal = VOIP_VCEOPT_G_723_DC_REMOVAL_DEFAULT;
	pstVoiceOpt->param_4.bits.cng = VOIP_VCEOPT_CNG_DEFAULT;
	pstVoiceOpt->param_4.bits.compander = VOIP_VCEOPT_COMPANDER_DEFAULT;

	pstVoiceOpt->param_5.bits.pkt_recept = VOIP_VCEOPT_PKT_RECEPT_DEFAULT;
	pstVoiceOpt->param_5.bits.udptl = VOIP_VCEOPT_UDPTL_ENABLE;
	pstVoiceOpt->param_5.bits.packing = VOIP_VCEOPT_PACKING_DEFAULT;
	pstVoiceOpt->param_5.bits.amr_mode = VOIP_VCEOPT_AMR_MODE_AMRMODE_122;
	pstVoiceOpt->param_5.bits.redundancy = VOIP_VCEOPT_REDUNDANCY_DEFAULT;

	pstVoiceOpt->vad_tune = VOIP_VCEOPT_VAD_TUNE_DEFAULT;

	pstVoiceOpt->param_7.bits.g711_model = VOIP_VCEOPT_G711_MODEL_DEFAULT;
	pstVoiceOpt->param_7.bits.cng_model = VOIP_VCEOPT_CNG_MODEL_DEFAULT;

	pstVoiceOpt->param_8.bits.amr_frame_format = VOIP_VCEOPT_AMR_FRAME_FORMAT_DEFAULT;
	pstVoiceOpt->param_8.bits.transcode_mode = VOIP_VCEOPT_TRANSCODE_MODE_DISABLE;
	pstVoiceOpt->param_8.bits.amr_wb_crc = VOIP_VCEOPT_AMR_WB_CRC_DISABLE;
	pstVoiceOpt->param_8.bits.amr_wb_rate = VOIP_VCEOPT_AMR_WB_RATE_DEFAULT;
	pstVoiceOpt->param_8.bits.cdma_rate = VOIP_VCEOPT_CDMA_RATE_DEFAULT;
	pstVoiceOpt->param_8.bits.g729eg_rate = VOIP_VCEOPT_G729EG_RATE_DEFAULT;
	pstVoiceOpt->param_8.bits.crc_for_amr = VOIP_VCEOPT_CRC_FOR_AMR_DEFAULT;
	pstVoiceOpt->param_8.bits.bits_per_sample = VOIP_VCEOPT_BITS_PER_SAMPLE_DEFAULT;
	pstVoiceOpt->param_8.bits.plc_cfg = VOIP_VCEOPT_PLC_CFG_DEFAULT;

	/* DGAIN */
	pstDgain = &(pstChnlParams->stDgain);
	pstDgain->packet_to_pcm_gain = VOIP_DGAIN_PACKET_TO_PCM_GAIN_DEFAULT;
	pstDgain->pcm_to_packet_gain = VOIP_DGAIN_PCM_TO_PACKET_GAIN_DEFAULT;

	/* DFECAN */
	pstDfeCan = &(pstChnlParams->stDfeCan);

	pstDfeCan->param_4.bits.ecenb = VOIP_DFECAN_ECENB_DEFAULT;
	pstDfeCan->param_4.bits.ecdcd = VOIP_DFECAN_ECDCD_DEFAULT;
	pstDfeCan->param_4.bits.ectts = VOIP_DFECAN_ECTTS_DEFAULT;
	pstDfeCan->param_4.bits.ecinit = VOIP_DFECAN_ECINIT_ENABLE;
	pstDfeCan->param_4.bits.ecfrz = VOIP_DFECAN_ECFRZ_DEFAULT;
	pstDfeCan->param_4.bits.ecnlp = VOIP_DFECAN_ECNLP_DEFAULT;
	pstDfeCan->param_4.bits.ecdyn = VOIP_DFECAN_ECDYN_DEFAULT;
	pstDfeCan->param_4.bits.ecbnr = VOIP_DFECAN_ECBNR_DEFAULT;
	pstDfeCan->param_4.bits.ecspf = VOIP_DFECAN_ECSPF_FULL;
	pstDfeCan->param_4.bits.eccng = VOIP_DFECAN_ECCNG_DEFAULT;
	pstDfeCan->param_4.bits.ecflt = VOIP_DFECAN_ECFLT_DEFAULT;
	pstDfeCan->param_4.bits.ecrdc = VOIP_DFECAN_ECRDC_DEFAULT;
	pstDfeCan->param_4.bits.eclen = 0x07;

	/* ECHOCAN */
	pstEchoCan = &(pstChnlParams->stEchoCan);

	pstEchoCan->param_4.bits.ecenb = VOIP_ECHOCAN_ECENB_DEFAULT;
	pstEchoCan->param_4.bits.ec_dc_removal = VOIP_ECHOCAN_EC_DC_REMOVAL_DEFAULT;
	pstEchoCan->param_4.bits.ec_h_reset = VOIP_ECHOCAN_EC_H_RESET_DEFAULT;
	pstEchoCan->param_4.bits.ecinit = VOIP_ECHOCAN_ECINIT_INIT;
	pstEchoCan->param_4.bits.hecfrz = VOIP_ECHOCAN_HECFRZ_DEFAULT;
	pstEchoCan->param_4.bits.nlp = VOIP_ECHOCAN_NLP_DEFAULT;
	pstEchoCan->param_4.bits.nlptune_hi = VOIP_ECHOCAN_NLPTUNE_HI_DEFAULT;
	pstEchoCan->param_4.bits.cng = VOIP_ECHOCAN_CNG_DEFAULT;
	pstEchoCan->param_4.bits.nlptune_lo = VOIP_ECHOCAN_NLPTUNE_LO_DEFAULT;
	pstEchoCan->param_4.bits.heclen = VOIP_ECHOCAN_HECLEN_DEFAULT;

	/* DTMFOPT */
	pstDtmfOpt = &(pstChnlParams->stDtmfOpt);

	pstDtmfOpt->param_4.bits.ssrc = VOIP_DTMFOPT_SSRC_DEFAULT;
	pstDtmfOpt->param_4.bits.silence_removal = VOIP_DTMFOPT_SILENCE_REMOVAL_DEFAULT;
	pstDtmfOpt->param_4.bits.rfc_packet_format = VOIP_DTMFOPT_RFC_PACKET_FORMAT_DEFAULT;
	pstDtmfOpt->param_4.bits.event_report = VOIP_DTMFOPT_EVENT_REPORT_ENABLE;
	pstDtmfOpt->param_4.bits.regeneration = VOIP_DTMFOPT_REGENERATION_DISABLE;
	pstDtmfOpt->param_4.bits.removal = VOIP_DTMFOPT_REMOVAL_DEFAULT;
	pstDtmfOpt->param_4.bits.redundancy = VOIP_DTMFOPT_REDUNDANCY_DEFAULT;
	pstDtmfOpt->param_4.bits.dtmf_rtp = VOIP_DTMFOPT_DTMF_RTP_ENABLE;
	pstDtmfOpt->param_4.bits.dtmf_voice = VOIP_DTMFOPT_DTMF_VOICE_DEFAULT;
	pstDtmfOpt->dtmf_pt = 0x6160;

	 /*TONECTRL*/
	pstToneCtrl = &(pstChnlParams->stToneCtrl);
	pstToneCtrl->param_4.bits.ansam_det = VOIP_TONECTRL_ANSAM_DET_DEFAULT;
	pstToneCtrl->param_4.bits.tdm_ptd = VOIP_TONECTRL_TDM_PTD_DEFAULT;
	pstToneCtrl->param_4.bits.fft_tone =VOIP_TONECTRL_FFT_TONE_DEFAULT;
	pstToneCtrl->param_4.bits.fft_event = VOIP_TONECTRL_FFT_EVENT_DEFAULT;
	pstToneCtrl->param_4.bits.call_progress_det = VOIP_TONECTRL_CALL_PROGRESS_DET_DEFAULT;
	pstToneCtrl->param_4.bits.bell_ans = VOIP_TONECTRL_BELL_ANS_DEFAULT;
	pstToneCtrl->param_4.bits.v32 = VOIP_TONECTRL_V32_DEFAULT;
	pstToneCtrl->param_4.bits.notch_filter = VOIP_TONECTRL_NOTCH_FILTER_DEFAULT;
	pstToneCtrl->param_4.bits.call_progress_ind = VOIP_TONECTRL_CALL_PROGRESS_IND_DEFAULT;
	pstToneCtrl->param_4.bits.answer_tone_ctrl = VOIP_TONECTRL_ANSWER_TONE_CTRL_DEFAULT;
	pstToneCtrl->param_4.bits.fax_call_ctrl = VOIP_TONECTRL_FAX_CALL_CTRL_ENABLE;
	pstToneCtrl->param_4.bits.v8bis_2002hz_ctrl = VOIP_TONECTRL_V8BIS_2002HZ_CTRL_DEFAULT;
	pstToneCtrl->param_4.bits.modem_passthrough_ind = VOIP_TONECTRL_MODEM_PASSTHROUGH_IND_ENABLE;
	pstToneCtrl->param_4.bits.t38_tone_ind = VOIP_TONECTRL_T38_TONE_IND_ENABLE;
	pstToneCtrl->param_4.bits.dtmf_ind = VOIP_TONECTRL_DTMF_IND_ENABLE;

	pstToneCtrl->param_5.bits.v18_notch_filter = VOIP_TONECTRL_V18_NOTCH_FILTER_DEFAULT;
	pstToneCtrl->param_5.bits.v18_baudot = VOIP_TONECTRL_V18_BAUDOT_DEFAULT;

	pstToneCtrl->param_6.bits.tdm_2000 = VOIP_TONECTRL_TDM_2000_DEFAULT;
	pstToneCtrl->param_6.bits.tdm_1650 = VOIP_TONECTRL_TDM_1650_DEFAULT;
	pstToneCtrl->param_6.bits.tdm_1330 = VOIP_TONECTRL_TDM_1330_DEFAULT;
	pstToneCtrl->param_6.bits.tdm_1270 = VOIP_TONECTRL_TDM_1270_DEFAULT;
	pstToneCtrl->param_6.bits.tdm_980 = VOIP_TONECTRL_TDM_980_DEFAULT;
	pstToneCtrl->param_6.bits.tdm_390 = VOIP_TONECTRL_TDM_390_DEFAULT;

	pstToneCtrl->param_7.bits.ip_2000 = VOIP_TONECTRL_IP_2000_DEFAULT;
	pstToneCtrl->param_7.bits.ip_1650 = VOIP_TONECTRL_IP_1650_DEFAULT;
	pstToneCtrl->param_7.bits.ip_1330 = VOIP_TONECTRL_IP_1330_DEFAULT;
	pstToneCtrl->param_7.bits.ip_1270 = VOIP_TONECTRL_IP_1270_DEFAULT;
	pstToneCtrl->param_7.bits.ip_980 = VOIP_TONECTRL_IP_980_DEFAULT;
	pstToneCtrl->param_7.bits.ip_390 = VOIP_TONECTRL_IP_390_DEFAULT;

	pstToneCtrl->param_8.bits.cas_tone_det = VOIP_TONECTRL_CAS_TONE_DET_DEFAULT;

	 /*TONERELAY*/
	pstToneRelay = &(pstChnlParams->stToneRelay);
	pstToneRelay->param_4.bits.send_2833_event = VOIP_TONES_RELAY_OPTION_SEND_2833_EVENT_ENABLE;
	pstToneRelay->param_4.bits.redundancy_2833_scheme = VOIP_TONES_RELAY_OPTION_REDUNDANCY_2833_SCHEME_DEFAULT;
	pstToneRelay->param_4.bits.control_m_fax_tones = VOIP_TONES_RELAY_OPTION_CONTROL_M_FAX_TONES_ENABLE;
	pstToneRelay->param_4.bits.ccisoip_tone_volume = VOIP_TONES_RELAY_OPTION_CCISOIP_TONE_VOLUME_5DB;
	pstToneRelay->param_4.bits.ccisoip_packet_format = VOIP_TONES_RELAY_OPTION_CCISOIP_PKT_FORMAT_DEFAULT;
	pstToneRelay->param_4.bits.ccisoip_tone_duration = VOIP_TONES_RELAY_OPTION_CCISOIP_TONE_DURATION_50MS;
	pstToneRelay->param_5.bits.cng_relay_over_ip = VOIP_TONES_RELAY_CNG_OIP_DEFAULT;

	 /*IPHEADER*/
	pstIpHdrParams = &(pstChnlParams->stIpHdrParams);
	pstIpHdrParams->param_4.bits.checksum = SET_IP_HDR_CHANNEL_CHECKSUM_ENABLE;
	pstIpHdrParams->param_4.bits.serviceid = SET_IP_HDR_CHANNEL_SERVICEID_DEFAULTPKT;
	pstIpHdrParams->param_4.bits.checksum_inc_data = SET_IP_HDR_CHANNEL_CHECKSUM_INC_DATA_DEFAULT;

	pstIpHdrParams->param_5.bits.ip_tos = SET_IP_HDR_CHANNEL_IP_TOS_DEFAULT;
	pstIpHdrParams->param_5.bits.ip_v = SET_IP_HDR_CHANNEL_IP_V_DEFAULT;
	pstIpHdrParams->param_5.bits.ip_hl= SET_IP_HDR_CHANNEL_IP_HL_DEFAULT;

	pstIpHdrParams->ip_len = SET_IP_HDR_CHANNEL_IP_LEN_DEFAULT;
	pstIpHdrParams->ip_id = SET_IP_HDR_CHANNEL_IP_ID_DEFAULT;
	pstIpHdrParams->ip_off = 0x0040;

	pstIpHdrParams->param_9.bits.ip_p = 0x11;
	pstIpHdrParams->param_9.bits.ip_ttl = 0x80;

	pstIpHdrParams->ip_sum = 0x0000;
	pstIpHdrParams->uh_ulen = 0x0000;;
	pstIpHdrParams->uh_sum = 0x0000;;

	/*Jitter buffer*/
	pstChnlParams->stJbopt.delay_min = VOIP_JBOPT_DELAY_MIN_DEFAULT;
	pstChnlParams->stJbopt.delay_max = VOIP_JBOPT_DELAY_MAX_DEFAULT;
	pstChnlParams->stJbopt.delay_init = VOIP_JBOPT_DELAY_INIT_DEFAULT;
	pstChnlParams->stJbopt.ap = VOIP_JBOPT_AP_DEFAULT;
	pstChnlParams->stJbopt.param_8.bits.deletion_mode = VOIP_JBOPT_DELETION_MODE_DEFAULT;
	pstChnlParams->stJbopt.param_8.bits.immediatly_adjust = VOIP_JBOPT_IMMEDIATLY_ADJUST_DEFAULT;
	pstChnlParams->stJbopt.deletion_threshold = VOIP_JBOPT_DELETION_THRESHOLD_DEFAULT;

	pstChnlParams->eCodecVal = eG711_ULAW_PCM;

	/*Set all payload type to 0xff (not initialized)*/
	UT_MemSet(pstChnlParams->ucAudioPt, 0xFF, sizeof(U8) * NUM_CODECS);

	/* now set the paylaod types which have a specific default value */
	pstChnlParams->ucAudioPt[eGeneric_Comfort_Noise] = VOIP_PTMNG_GENERIC_COMFORT_NOISE_DEFAULT;
	pstChnlParams->ucAudioPt[eG711_ULAW_PCM] = VOIP_PTMNG_G_711_MULAW_DEFAULT;
	pstChnlParams->ucAudioPt[eG711_ALAW_PCM] = VOIP_PTMNG_G_711_ALAW_DEFAULT;
	pstChnlParams->ucAudioPt[eG723_1] = VOIP_PTMNG_G_723_1_DEFAULT;
	pstChnlParams->ucAudioPt[eG728_Audio] = VOIP_PTMNG_G_728_DEFAULT;
	pstChnlParams->ucAudioPt[eG726_32] = VOIP_PTMNG_G_726_32_DEFAULT;
	pstChnlParams->ucAudioPt[eG729_A] = VOIP_PTMNG_G_729A_DEFAULT;
	pstChnlParams->ucAudioPt[eGSM_FR_Audio] = VOIP_PTMNG_GSM_FR_DEFAULT;
	pstChnlParams->ucAudioPt[eCNF_SEC] = VOIP_PTMNG_CNF_SEC_DEFAULT;
	pstChnlParams->ucAudioPt[eFEC] = VOIP_PTMNG_FEC_DEFAULT;

	/*default video payload type*/
	pstChnlParams->ucVideoPt[eH263_ID] = 0x70;
	pstChnlParams->ucVideoPt[eRFC2190_ID] = 0x22;
	pstChnlParams->ucVideoPt[eH264_ID] = 0x71;
	pstChnlParams->ucVideoPt[eMPEG4_ID] = 0x72;

	/*Default Fax options*/
	 /*FAXOPT*/
	pstFaxOpts = &(pstChnlParams->stFaxOpts);
	pstFaxOpts->param_4.bits.t38_packet_loss_concealment = FAXOPT_T38_PACKET_LOSS_CONCEALMENT_DISABLE;
	pstFaxOpts->param_4.bits.ecm_disable = FAXOPT_ECM_DISABLE_DEFAULT;
	pstFaxOpts->param_4.bits.udptl_redundancy_fax_page = FAXOPT_UDPTL_REDUNDANCY_FAX_PAGE_DEFAULT;
	pstFaxOpts->param_4.bits.udptl_redundancy_t30 = FAXOPT_UDPTL_REDUNDANCY_T30_DEFAULT;
	pstFaxOpts->param_4.bits.speed_limit = FAXOPT_SPEED_LIMIT_DEFAULT;
	pstFaxOpts->param_4.bits.error_recovery_method = FAXOPT_ERROR_RECOVERY_METHOD_DEFAULT;
	pstFaxOpts->param_4.bits.tcf_procedure = FAXOPT_TCF_PROCEDURE_DEFAULT;
	pstFaxOpts->param_5.bits.transmit_small = FAXOPT_TRANSMIT_SMALL_DEFAULT;
	pstFaxOpts->param_5.bits.reserved5_bits_7_0 = 0xFF;
	pstFaxOpts->param_7.bits.v34_speed_limit = FAXOPT_V34_SPEED_LIMIT_DEFAULT;
	pstFaxOpts->param_7.bits.enable_v34_fax = FAXOPT_ENABLE_V34_FAX_DEFAULT;

	 /*FAXLVL*/
	pstFaxLevel = &(pstChnlParams->stFaxTxLevel);
	pstFaxLevel->faxlvl = FAXLVL_FAXLVL_DEFAULT;
	return;
}

/****************************************************************************
 * DMGR_SetVoIPDevDefaults : The function does the following things -
 ***************************************************************************/
/*! 
* This function sets the internal VAPI variables with the default values when a VoIP or FoIP channel is created on the device.
*/
void DMGR_SetVoIPDevDefaults(SVoIPChnlParams * pstChnlParams)
{
	struct _VOIP_VOPENA *pstVopena = NULL;
	struct _VOIP_DTMFOPT *pstDtmfOpt = NULL;
	struct _VOIP_DGAIN *pstDgain = NULL;
	struct _VOIP_DFECAN *pstDfeCan = NULL;
	struct _VOIP_ECHOCAN *pstEchoCan = NULL;
	struct _VOIP_VCEOPT *pstVoiceOpt = NULL;
	struct _VOIP_TONECTRL *pstToneCtrl = NULL;
	struct _VOIP_TONES_RELAY_OPTION *pstToneRelay = NULL;
	struct _SET_IP_HDR_CHANNEL *pstIpHdrParams = NULL;
	struct _FAXOPT *pstFaxOpts = NULL;
	struct _FAXLVL *pstFaxLevel = NULL;

	if (pstChnlParams == NULL)
		return;

	pstVopena = &(pstChnlParams->stVopena);
	pstVopena->mode = VOIP_VOPENA_MODE_DISABLE;
	pstVopena->param_5.bits.rtp_m = 0;
	pstVopena->param_5.bits.rtp_pt = VOIP_VOPENA_RTP_PT_PCMU;
	pstVopena->param_5.bits.rtp_v = VOIP_VOPENA_RTP_V_DEFAULT;
	pstVopena->param_5.bits.rtp_p = VOIP_VOPENA_RTP_P_DEFAULT;
	pstVopena->param_5.bits.rtp_x = VOIP_VOPENA_RTP_X_DEFAULT;
	pstVopena->param_5.bits.rtp_cc = 0;
	pstVopena->rtp_seq = VOIP_VOPENA_RTP_SEQ_DEFAULT;
	pstVopena->rtp_timestamp  = 0;
	pstVopena->rtp_ssrc = 0;

	/* VCEOPT */
	pstVoiceOpt = &(pstChnlParams->stVoiceOpt);
	pstVoiceOpt->param_4.bits.packet_interval = 20;
	pstVoiceOpt->param_4.bits.vadtype = VOIP_VCEOPT_VADTYPE_DEFAULT;
	pstVoiceOpt->param_4.bits.adaptive_post_filter = VOIP_VCEOPT_ADAPTIVE_POST_FILTER_DEFAULT;
	pstVoiceOpt->param_4.bits.g_723_rate = VOIP_VCEOPT_G_723_RATE_DEFAULT;
	pstVoiceOpt->param_4.bits.packet_generation = VOIP_VCEOPT_PACKET_GENERATION_DISABLE;
	pstVoiceOpt->param_4.bits.g_723_dc_removal = VOIP_VCEOPT_G_723_DC_REMOVAL_DEFAULT;
	pstVoiceOpt->param_4.bits.cng = VOIP_VCEOPT_CNG_DEFAULT;
	pstVoiceOpt->param_4.bits.compander = VOIP_VCEOPT_COMPANDER_DEFAULT;

	pstVoiceOpt->param_5.bits.pkt_recept = VOIP_VCEOPT_PKT_RECEPT_DEFAULT;
	pstVoiceOpt->param_5.bits.udptl = VOIP_VCEOPT_UDPTL_ENABLE;
	pstVoiceOpt->param_5.bits.packing = VOIP_VCEOPT_PACKING_DEFAULT;
	pstVoiceOpt->param_5.bits.amr_mode = VOIP_VCEOPT_AMR_MODE_AMRMODE_122;
	pstVoiceOpt->param_5.bits.redundancy = VOIP_VCEOPT_REDUNDANCY_DEFAULT;

	pstVoiceOpt->vad_tune = VOIP_VCEOPT_VAD_TUNE_DEFAULT;

	pstVoiceOpt->param_7.bits.g711_model = VOIP_VCEOPT_G711_MODEL_DEFAULT;
	pstVoiceOpt->param_7.bits.cng_model = VOIP_VCEOPT_CNG_MODEL_DEFAULT;

	pstVoiceOpt->param_8.bits.amr_frame_format = VOIP_VCEOPT_AMR_FRAME_FORMAT_DEFAULT;
	pstVoiceOpt->param_8.bits.transcode_mode = VOIP_VCEOPT_TRANSCODE_MODE_DISABLE;
	pstVoiceOpt->param_8.bits.amr_wb_crc = VOIP_VCEOPT_AMR_WB_CRC_DISABLE;
	pstVoiceOpt->param_8.bits.amr_wb_rate = VOIP_VCEOPT_AMR_WB_RATE_DEFAULT;
	pstVoiceOpt->param_8.bits.cdma_rate = VOIP_VCEOPT_CDMA_RATE_DEFAULT;
	pstVoiceOpt->param_8.bits.g729eg_rate = VOIP_VCEOPT_G729EG_RATE_DEFAULT;
	pstVoiceOpt->param_8.bits.crc_for_amr = VOIP_VCEOPT_CRC_FOR_AMR_DEFAULT;
	pstVoiceOpt->param_8.bits.bits_per_sample = VOIP_VCEOPT_BITS_PER_SAMPLE_DEFAULT;
	pstVoiceOpt->param_8.bits.plc_cfg = VOIP_VCEOPT_PLC_CFG_DEFAULT;

	/* DGAIN */
	pstDgain = &(pstChnlParams->stDgain);
	pstDgain->packet_to_pcm_gain = VOIP_DGAIN_PACKET_TO_PCM_GAIN_DEFAULT;
	pstDgain->pcm_to_packet_gain = VOIP_DGAIN_PCM_TO_PACKET_GAIN_DEFAULT;

	/* DFECAN */
	pstDfeCan = &(pstChnlParams->stDfeCan);

	pstDfeCan->param_4.bits.ecenb = VOIP_DFECAN_ECENB_DEFAULT;
	pstDfeCan->param_4.bits.ecdcd = VOIP_DFECAN_ECDCD_DEFAULT;
	pstDfeCan->param_4.bits.ectts = VOIP_DFECAN_ECTTS_DEFAULT;
	pstDfeCan->param_4.bits.ecinit = VOIP_DFECAN_ECINIT_ENABLE;
	pstDfeCan->param_4.bits.ecfrz = VOIP_DFECAN_ECFRZ_DEFAULT;
	pstDfeCan->param_4.bits.ecnlp = VOIP_DFECAN_ECNLP_DEFAULT;
	pstDfeCan->param_4.bits.ecdyn = VOIP_DFECAN_ECDYN_DEFAULT;
	pstDfeCan->param_4.bits.ecbnr = VOIP_DFECAN_ECBNR_DEFAULT;
	pstDfeCan->param_4.bits.ecspf = VOIP_DFECAN_ECSPF_FULL;
	pstDfeCan->param_4.bits.eccng = VOIP_DFECAN_ECCNG_DEFAULT;
	pstDfeCan->param_4.bits.ecflt = VOIP_DFECAN_ECFLT_DEFAULT;
	pstDfeCan->param_4.bits.ecrdc = VOIP_DFECAN_ECRDC_DEFAULT;
	pstDfeCan->param_4.bits.eclen = 0x07;

	/* ECHOCAN */
	pstEchoCan = &(pstChnlParams->stEchoCan);

	pstEchoCan->param_4.bits.ecenb = VOIP_ECHOCAN_ECENB_DEFAULT;
	pstEchoCan->param_4.bits.ec_dc_removal = VOIP_ECHOCAN_EC_DC_REMOVAL_DEFAULT;
	pstEchoCan->param_4.bits.ec_h_reset = VOIP_ECHOCAN_EC_H_RESET_DEFAULT;
	pstEchoCan->param_4.bits.ecinit = VOIP_ECHOCAN_ECINIT_INIT;
	pstEchoCan->param_4.bits.hecfrz = VOIP_ECHOCAN_HECFRZ_DEFAULT;
	pstEchoCan->param_4.bits.nlp = VOIP_ECHOCAN_NLP_DEFAULT;
	pstEchoCan->param_4.bits.nlptune_hi = VOIP_ECHOCAN_NLPTUNE_HI_DEFAULT;
	pstEchoCan->param_4.bits.cng = VOIP_ECHOCAN_CNG_DEFAULT;
	pstEchoCan->param_4.bits.heclen = VOIP_ECHOCAN_HECLEN_DEFAULT;

	/* DTMFOPT */
	pstDtmfOpt = &(pstChnlParams->stDtmfOpt);

	pstDtmfOpt->param_4.bits.ssrc = VOIP_DTMFOPT_SSRC_DEFAULT;
	pstDtmfOpt->param_4.bits.silence_removal = VOIP_DTMFOPT_SILENCE_REMOVAL_DEFAULT;
	pstDtmfOpt->param_4.bits.rfc_packet_format = VOIP_DTMFOPT_RFC_PACKET_FORMAT_DEFAULT;
	pstDtmfOpt->param_4.bits.event_report = VOIP_DTMFOPT_EVENT_REPORT_ENABLE;
	pstDtmfOpt->param_4.bits.regeneration = VOIP_DTMFOPT_REGENERATION_DISABLE;
	pstDtmfOpt->param_4.bits.removal = VOIP_DTMFOPT_REMOVAL_DEFAULT;
	pstDtmfOpt->param_4.bits.redundancy = VOIP_DTMFOPT_REDUNDANCY_DEFAULT;
	pstDtmfOpt->param_4.bits.dtmf_rtp = VOIP_DTMFOPT_DTMF_RTP_ENABLE;
	pstDtmfOpt->param_4.bits.dtmf_voice = VOIP_DTMFOPT_DTMF_VOICE_DEFAULT;
	pstDtmfOpt->dtmf_pt = 0xffff;

	 /*TONECTRL*/
	pstToneCtrl = &(pstChnlParams->stToneCtrl);
	pstToneCtrl->param_4.bits.ansam_det = VOIP_TONECTRL_ANSAM_DET_DEFAULT;
	pstToneCtrl->param_4.bits.tdm_ptd = VOIP_TONECTRL_TDM_PTD_DEFAULT;
	pstToneCtrl->param_4.bits.fft_tone =VOIP_TONECTRL_FFT_TONE_DEFAULT;
	pstToneCtrl->param_4.bits.fft_event = VOIP_TONECTRL_FFT_EVENT_DEFAULT;
	pstToneCtrl->param_4.bits.call_progress_det = VOIP_TONECTRL_CALL_PROGRESS_DET_DEFAULT;
	pstToneCtrl->param_4.bits.bell_ans = VOIP_TONECTRL_BELL_ANS_DEFAULT;
	pstToneCtrl->param_4.bits.v32 = VOIP_TONECTRL_V32_DEFAULT;
	pstToneCtrl->param_4.bits.notch_filter = VOIP_TONECTRL_NOTCH_FILTER_DEFAULT;
	pstToneCtrl->param_4.bits.call_progress_ind = VOIP_TONECTRL_CALL_PROGRESS_IND_DEFAULT;
	pstToneCtrl->param_4.bits.answer_tone_ctrl = VOIP_TONECTRL_ANSWER_TONE_CTRL_DEFAULT;
	pstToneCtrl->param_4.bits.fax_call_ctrl = VOIP_TONECTRL_FAX_CALL_CTRL_DEFAULT;
	pstToneCtrl->param_4.bits.v8bis_2002hz_ctrl = VOIP_TONECTRL_V8BIS_2002HZ_CTRL_DEFAULT;
	pstToneCtrl->param_4.bits.modem_passthrough_ind = VOIP_TONECTRL_MODEM_PASSTHROUGH_IND_DEFAULT;
	pstToneCtrl->param_4.bits.t38_tone_ind = VOIP_TONECTRL_T38_TONE_IND_DEFAULT;
	pstToneCtrl->param_4.bits.dtmf_ind = VOIP_TONECTRL_DTMF_IND_DEFAULT;

	pstToneCtrl->param_5.bits.v18_notch_filter = VOIP_TONECTRL_V18_NOTCH_FILTER_DEFAULT;
	pstToneCtrl->param_5.bits.v18_baudot = VOIP_TONECTRL_V18_BAUDOT_DEFAULT;

	pstToneCtrl->param_6.bits.tdm_2000 = VOIP_TONECTRL_TDM_2000_DEFAULT;
	pstToneCtrl->param_6.bits.tdm_1650 = VOIP_TONECTRL_TDM_1650_DEFAULT;
	pstToneCtrl->param_6.bits.tdm_1330 = VOIP_TONECTRL_TDM_1330_DEFAULT;
	pstToneCtrl->param_6.bits.tdm_1270 = VOIP_TONECTRL_TDM_1270_DEFAULT;
	pstToneCtrl->param_6.bits.tdm_980 = VOIP_TONECTRL_TDM_980_DEFAULT;
	pstToneCtrl->param_6.bits.tdm_390 = VOIP_TONECTRL_TDM_390_DEFAULT;

	pstToneCtrl->param_7.bits.ip_2000 = VOIP_TONECTRL_IP_2000_DEFAULT;
	pstToneCtrl->param_7.bits.ip_1650 = VOIP_TONECTRL_IP_1650_DEFAULT;
	pstToneCtrl->param_7.bits.ip_1330 = VOIP_TONECTRL_IP_1330_DEFAULT;
	pstToneCtrl->param_7.bits.ip_1270 = VOIP_TONECTRL_IP_1270_DEFAULT;
	pstToneCtrl->param_7.bits.ip_980 = VOIP_TONECTRL_IP_980_DEFAULT;
	pstToneCtrl->param_7.bits.ip_390 = VOIP_TONECTRL_IP_390_DEFAULT;

	pstToneCtrl->param_8.bits.cas_tone_det = VOIP_TONECTRL_CAS_TONE_DET_DEFAULT;

	 /*TONERELAY*/
	pstToneRelay = &(pstChnlParams->stToneRelay);
	pstToneRelay->param_4.bits.send_2833_event = VOIP_TONES_RELAY_OPTION_SEND_2833_EVENT_DEFAULT;
	pstToneRelay->param_4.bits.redundancy_2833_scheme = VOIP_TONES_RELAY_OPTION_REDUNDANCY_2833_SCHEME_DEFAULT;
	pstToneRelay->param_4.bits.control_m_fax_tones = VOIP_TONES_RELAY_OPTION_CONTROL_M_FAX_TONES_DEFAULT;
	pstToneRelay->param_4.bits.ccisoip_tone_volume = VOIP_TONES_RELAY_OPTION_CCISOIP_TONE_VOLUME_5DB;
	pstToneRelay->param_4.bits.ccisoip_packet_format = VOIP_TONES_RELAY_OPTION_CCISOIP_PKT_FORMAT_DEFAULT;
	pstToneRelay->param_4.bits.ccisoip_tone_duration = VOIP_TONES_RELAY_OPTION_CCISOIP_TONE_DURATION_50MS;
	pstToneRelay->param_5.bits.cng_relay_over_ip = VOIP_TONES_RELAY_CNG_OIP_DEFAULT;

	 /*IPHEADER*/
	pstIpHdrParams = &(pstChnlParams->stIpHdrParams);
	pstIpHdrParams->param_4.bits.checksum = SET_IP_HDR_CHANNEL_CHECKSUM_ENABLE;
	pstIpHdrParams->param_4.bits.serviceid = SET_IP_HDR_CHANNEL_SERVICEID_DEFAULTPKT;

	pstIpHdrParams->param_5.bits.ip_tos = SET_IP_HDR_CHANNEL_IP_TOS_DEFAULT;
	pstIpHdrParams->param_5.bits.ip_v = SET_IP_HDR_CHANNEL_IP_V_DEFAULT;
	pstIpHdrParams->param_5.bits.ip_hl= SET_IP_HDR_CHANNEL_IP_HL_DEFAULT;

	pstIpHdrParams->ip_len = SET_IP_HDR_CHANNEL_IP_LEN_DEFAULT;
	pstIpHdrParams->ip_id = SET_IP_HDR_CHANNEL_IP_ID_DEFAULT;
	pstIpHdrParams->ip_off = 0x0040;

	pstIpHdrParams->param_9.bits.ip_p = 0x11;
	pstIpHdrParams->param_9.bits.ip_ttl = 0x80;

	pstIpHdrParams->ip_sum = 0x0000;
	pstIpHdrParams->uh_ulen = 0x0000;;
	pstIpHdrParams->uh_sum = 0x0000;;

	/*Jitter buffer*/
	pstChnlParams->stJbopt.delay_min = VOIP_JBOPT_DELAY_MIN_DEFAULT;
	pstChnlParams->stJbopt.delay_max = VOIP_JBOPT_DELAY_MAX_DEFAULT;
	pstChnlParams->stJbopt.delay_init = VOIP_JBOPT_DELAY_INIT_DEFAULT;
	pstChnlParams->stJbopt.ap = VOIP_JBOPT_AP_DEFAULT;
	pstChnlParams->stJbopt.param_8.bits.deletion_mode = VOIP_JBOPT_DELETION_MODE_DEFAULT;
	pstChnlParams->stJbopt.param_8.bits.immediatly_adjust = VOIP_JBOPT_IMMEDIATLY_ADJUST_DEFAULT;
	pstChnlParams->stJbopt.deletion_threshold = VOIP_JBOPT_DELETION_THRESHOLD_DEFAULT;

	pstChnlParams->eCodecVal = eG711_ULAW_PCM;

	/*Set all payload type to 0xff (not initialized)*/
	UT_MemSet(pstChnlParams->ucAudioPt, 0xFF, sizeof(U8) *NUM_CODECS);

	/* now set the paylaod types which have a specific default value */
	pstChnlParams->ucAudioPt[eGeneric_Comfort_Noise] = VOIP_PTMNG_GENERIC_COMFORT_NOISE_DEFAULT;
	pstChnlParams->ucAudioPt[eG711_ULAW_PCM] = VOIP_PTMNG_G_711_MULAW_DEFAULT;
	pstChnlParams->ucAudioPt[eG711_ALAW_PCM] = VOIP_PTMNG_G_711_ALAW_DEFAULT;
	pstChnlParams->ucAudioPt[eG723_1] = VOIP_PTMNG_G_723_1_DEFAULT;
	pstChnlParams->ucAudioPt[eG728_Audio] = VOIP_PTMNG_G_728_DEFAULT;
	pstChnlParams->ucAudioPt[eG726_32] = VOIP_PTMNG_G_726_32_DEFAULT;
	pstChnlParams->ucAudioPt[eG729_A] = VOIP_PTMNG_G_729A_DEFAULT;
	pstChnlParams->ucAudioPt[eGSM_FR_Audio] = VOIP_PTMNG_GSM_FR_DEFAULT;
	pstChnlParams->ucAudioPt[eCNF_SEC] = VOIP_PTMNG_CNF_SEC_DEFAULT;
	pstChnlParams->ucAudioPt[eFEC] = VOIP_PTMNG_FEC_DEFAULT;

	/*default video payload type*/
	pstChnlParams->ucVideoPt[eH263_ID] = 0x70;
	pstChnlParams->ucVideoPt[eRFC2190_ID] = 0x22;
	pstChnlParams->ucVideoPt[eH264_ID] = 0x71;
	pstChnlParams->ucVideoPt[eMPEG4_ID] = 0x72;

	/*Default Fax options*/
	 /*FAXOPT*/
	pstFaxOpts = &(pstChnlParams->stFaxOpts);
	pstFaxOpts->param_4.bits.t38_packet_loss_concealment = FAXOPT_T38_PACKET_LOSS_CONCEALMENT_DISABLE;
	pstFaxOpts->param_4.bits.ecm_disable = FAXOPT_ECM_DISABLE_DEFAULT;
	pstFaxOpts->param_4.bits.udptl_redundancy_fax_page = FAXOPT_UDPTL_REDUNDANCY_FAX_PAGE_DEFAULT;
	pstFaxOpts->param_4.bits.udptl_redundancy_t30 = FAXOPT_UDPTL_REDUNDANCY_T30_DEFAULT;
	pstFaxOpts->param_4.bits.speed_limit = FAXOPT_SPEED_LIMIT_DEFAULT;
	pstFaxOpts->param_4.bits.error_recovery_method = FAXOPT_ERROR_RECOVERY_METHOD_DEFAULT;
	pstFaxOpts->param_4.bits.tcf_procedure = FAXOPT_TCF_PROCEDURE_DEFAULT;
	pstFaxOpts->param_5.bits.transmit_small = FAXOPT_TRANSMIT_SMALL_DEFAULT;
	pstFaxOpts->param_5.bits.reserved5_bits_7_0 = 0xFF;
	pstFaxOpts->param_7.bits.v34_speed_limit = FAXOPT_V34_SPEED_LIMIT_DEFAULT;
	pstFaxOpts->param_7.bits.enable_v34_fax = FAXOPT_ENABLE_V34_FAX_DEFAULT;

	 /*FAXLVL*/
	pstFaxLevel = &(pstChnlParams->stFaxTxLevel);
	pstFaxLevel->faxlvl = FAXLVL_FAXLVL_DEFAULT;

	return;
}


void DMGR_SetConfDefaults(SConferenceParams *pstConfParams)
{
	SConfDTSParams *pstDTSParams;
	struct _VOIP_AGCSET *pstAGCParams;

	if (pstConfParams == NULL)
		return;

	pstConfParams->ucParticipantGain = 1;

	/*Dominant talkers*/
	pstDTSParams = &(pstConfParams->stDTSParams);
	pstDTSParams->bDTSOnOff = CONF_SPECIFY_DOMINANT_TALKERS_DTS_DEFAULT;
	pstDTSParams->usAttackConst = CONF_SPECIFY_DOMINANT_TALKERS_ATTACK_DEFAULT;
	pstDTSParams->usNTH1 = CONF_SPECIFY_DOMINANT_TALKERS_NTH1_DEFAULT ;
	pstDTSParams->usNTH2 = CONF_SPECIFY_DOMINANT_TALKERS_NTH2_DEFAULT;
	pstDTSParams->usHoldConst = CONF_SPECIFY_DOMINANT_TALKERS_HOLD_DEFAULT;
	pstDTSParams->usN1 = CONF_SPECIFY_DOMINANT_TALKERS_N1_DEFAULT;
	pstDTSParams->usG1 = CONF_SPECIFY_DOMINANT_TALKERS_G1_DEFAULT;
	pstDTSParams->usN2 = CONF_SPECIFY_DOMINANT_TALKERS_N2_DEFAULT;
	pstDTSParams->usG2 = CONF_SPECIFY_DOMINANT_TALKERS_G2_DEFAULT;
	pstDTSParams->usN3 = CONF_SPECIFY_DOMINANT_TALKERS_N3_DEFAULT;
	pstDTSParams->usG3 = CONF_SPECIFY_DOMINANT_TALKERS_G3_DEFAULT;

	/*DTS params*/
	pstAGCParams = &(pstConfParams->stAGCParams);

	pstAGCParams->param_4.bits.pkt2pcm_enb = VOIP_AGCSET_PKT2PCM_ENB_DEFAULT;
	pstAGCParams->param_4.bits.pcm2pkt_enb = VOIP_AGCSET_PCM2PKT_ENB_DEFAULT;
	pstAGCParams->param_4.bits.pkt2pcm_slew_rate = VOIP_AGCSET_PKT2PCM_SLEW_RATE_DEFAULT;
	pstAGCParams->param_4.bits.pcm2pkt_slew_rate = VOIP_AGCSET_PCM2PKT_SLEW_RATE_DEFAULT;
	pstAGCParams->param_4.bits.rxlim = VOIP_AGCSET_RXINIT_DEFAULT;
	pstAGCParams->param_4.bits.txlim = VOIP_AGCSET_TXLIM_DEFAULT;
	pstAGCParams->param_4.bits.rxinit = VOIP_AGCSET_RXINIT_DEFAULT;
	pstAGCParams->param_4.bits.txinit = VOIP_AGCSET_TXINIT_DEFAULT;
	pstAGCParams->param_4.bits.g169enb = VOIP_AGCSET_G169ENB_DEFAULT;
	pstAGCParams->pkt2pcm_target_level = VOIP_AGCSET_PKT2PCM_TARGET_LEVEL_DEFAULT;
	pstAGCParams->pcm2pkt_target_level = VOIP_AGCSET_PCM2PKT_TARGET_LEVEL_DEFAULT;
	pstAGCParams->pkt2pcm_max_gain = VOIP_AGCSET_PKT2PCM_MAX_GAIN_DEFAULT;
	pstAGCParams->pkt2pcm_min_gain = VOIP_AGCSET_PKT2PCM_MIN_GAIN_DEFAULT;
	pstAGCParams->pcm2pkt_max_gain = VOIP_AGCSET_PCM2PKT_MAX_GAIN_DEFAULT;
	pstAGCParams->pcm2pkt_min_gain = VOIP_AGCSET_PCM2PKT_MIN_GAIN_DEFAULT;

	return;
}

