/*! \file video_fsm.c 
 * Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

#include"ut.h"
#include"vapi.h"
#include"dmgr.h"
#include"vcore.h"
#include"msp.h"
#include "vcore_voip.h"
#include "appitf.h"

/****************************************************************************
 * VFSM_SendH245Msg : The function does the following things -
 ***************************************************************************/
VSTATUS VFSM_SendH245Msg(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg)
{
	VSTATUS Status = SUCCESS;
	SH245Packet *pstH245Packet;
	SH245Data *pstH245Data;
	CONNID ConnId = pstChnl->ConnId;

	UT_Log(VCORE, DEBUG, "VFSM_SendH245Msg: Entering conn(%u) state(%u)\n", ConnId, pstVapiReq->usReqState);

	pstH245Packet = (SH245Packet *) pstVapiReq->pvExecData;	
	pstH245Data = (SH245Data *) pstVapiReq->pvUserData;

	switch (pstVapiReq->usReqState)
	{
	case SEND_H245_INIT:
		pstVapiReq->pvExecData = UT_Calloc(1, sizeof(SH245Packet));

		if (pstVapiReq->pvExecData == NULL)
		{
			Status = VAPI_ERR_NOMEM;
			goto finish;
		}

		pstH245Packet = (SH245Packet *) pstVapiReq->pvExecData;		
		pstH245Packet->ptrH245Packet = pstH245Data->ptrH245Msg;		
		pstH245Packet->uiH245SizeLeft = pstH245Data->uiH245MsgLength;		

		if (pstH245Packet->uiH245SizeLeft > H245_MAX_LEN)
		{
			pstH245Packet->uiH245PacketLen = H245_MAX_LEN;
			pstH245Packet->uiEndOfMsg = False;
			pstVapiReq->usReqState = SEND_H245_PROCEED;

			Status = VDEV_SendH254(pstChnl, pstH245Packet);
		
			pstH245Packet->ptrH245Packet = pstH245Packet->ptrH245Packet + H245_MAX_LEN;
			pstH245Packet->uiH245SizeLeft = pstH245Packet->uiH245SizeLeft - pstH245Packet->uiH245PacketLen;
		}
		else
		{
			pstH245Packet->uiH245PacketLen = pstH245Packet->uiH245SizeLeft;
			pstH245Packet->uiEndOfMsg = True;
			pstVapiReq->usReqState = SEND_H245_FINISH;

			Status = VDEV_SendH254(pstChnl, pstH245Packet);
		
			pstH245Packet->ptrH245Packet = NULL;
			pstH245Packet->uiH245SizeLeft = 0;
		}

		if (Status != SUCCESS)
			goto finish;		
		
		break;

	case SEND_H245_PROCEED:
		Status = VCORE_CheckStatus(Event, pstMsg, pstChnl->usMSPChnlId,
						CMD_CLASS_CONF_CHANNEL, CMD_TYPE_CONF_RESP, FC_IMSOTDM_TXH245);

		if (Status != SUCCESS)
			goto finish;

		if (pstH245Packet->uiH245SizeLeft > H245_MAX_LEN)
		{
			pstH245Packet->uiH245PacketLen = H245_MAX_LEN;
			pstH245Packet->uiEndOfMsg = False;
			pstVapiReq->usReqState = SEND_H245_PROCEED;

			Status = VDEV_SendH254(pstChnl, pstH245Packet);
		
			pstH245Packet->ptrH245Packet = pstH245Packet->ptrH245Packet + H245_MAX_LEN;
			pstH245Packet->uiH245SizeLeft = pstH245Packet->uiH245SizeLeft - pstH245Packet->uiH245PacketLen;
		}
		else
		{
			pstH245Packet->uiH245PacketLen = pstH245Packet->uiH245SizeLeft;
			pstH245Packet->uiEndOfMsg = True;
			pstVapiReq->usReqState = SEND_H245_FINISH;

			Status = VDEV_SendH254(pstChnl, pstH245Packet);
		
			pstH245Packet->ptrH245Packet = NULL;
			pstH245Packet->uiH245SizeLeft = 0;
		}

		if (Status != SUCCESS)
			goto finish;

	case SEND_H245_FINISH:
		Status = VCORE_CheckStatus(Event, pstMsg, pstChnl->usMSPChnlId,
						CMD_CLASS_CONF_CHANNEL, CMD_TYPE_CONF_RESP, FC_IMSOTDM_TXH245);

		goto finish;		
		break;

	default:
		Status = VAPI_ERR_UNDEFINED;
		UT_ErrorLog(VCORE, "VFSM_SendH245Msg: wrong state %u\n", pstVapiReq->usReqState);
		goto finish;		
	}	

	return SUCCESS;

finish:
	if (Status != SUCCESS)
		UT_ErrorLog(VCORE, "VFSM_SendH245Msg: Error dev(%u) devchnl(%u) conn(%u) req(0x%x) reqid(%u) pstChnl(0x%x)\n",
			pstChnl->pstDev->DevId, pstChnl->usMSPChnlId, ConnId, pstVapiReq, pstVapiReq->usReqState, pstChnl);

	UT_Log(VCORE, DEBUG, "VFSM_SendH245Msg: Completing req state(%u) status(%d) conn(%u)\n",
			pstVapiReq->usReqState, Status, ConnId);

	VCORE_DoReqCompletion(pstChnl, pstVapiReq, Status);

	UT_Log(VCORE, INFO, "VFSM_SendH245Msg: Exiting status(%d) conn(%u)\n", Status, ConnId);

	return Status;
}

