/*! \file vcore_types.h
 * Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

#ifndef _VCORETYPES_H_
#define _VCORETYPES_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "msp.h"

#define MAX_CADENCE_BLOCK 4

/** Mutex to access the tone generic array*/
extern SMutex stMutexToneGenArr_g;

typedef struct _SCdnBlkParams {
	U16 usPrmToneFreq;  /**< The primary tone frequency */
	U16 usPrmToneAmp;   /**< The primary tone amplitude */
	U16 usSecToneFreq;  /**< The secondary tone frequency */
	U16 usSecToneAmp;   /**< The secondary tone amplitude */
	U16 usOnTime;	    /**< The on time for the specified dual tone pair. */
	U16 usOffTime;	    /**< The off time for the specified dual tone pair. */
} SCdnBlkParams;

typedef struct _SToneGenParams {

	U8 ucToneDir;
		 /**< 0: Tone will be rendered to the PCM interface */
		 /**< 1: Tone will be rendered to the packet interface,  */
		 /**< using the currently selected voice coding scheme. */
		 /**< Protected Generation control bit will be ignored. */
	U32 uiStartTimeStamp;
	U32 uiLimitTimeStamp;
	U8 ucTimeStampCntrl;
		 /**< These bits, in conjunction with the start and limit */
		 /**< timestamps, control the timing of the generated tone */
		 /**< 0: Ignore timestamp: tone started immediately */
		 /**< 1: Synchronized start: tone delayed until given start */
		 /**< timestamp, or played immediately if timestamp has passed */
		 /**< 2: End limit: tone only played if limit timestamp has not */
		 /**< already passed */
		 /**< 3: Range limit: tone only played if current timestamp  */
		 /**< is between the start and limit timestamps */

	U8 ucProtectedGen;
		 /**< to PCM generation only */
		 /**< 0: Tone can be immediately  */
		 /**< 1: Tone is guaranteed to be generated with cadence  */
		 /**< of at least 50ms on, 50ms off. Only first cadence  */
		 /**< period played, cadence repeat parameter ignored, */
		 /**< and synchronized start can delay tone for 5 second max. */

	U8 ucCdnRpt;
		   /**< The number of times the cadence pattern (defined by the */
		   /**< cadence blocks that follow) is repeated. */
		   /**< 0: Send a single cadence cycle */
		   /**< 1: Repeat the cycle once (2 cycles rendered) */
	/*: */
		   /**< 255: Causes the cycle to repeat indefinitely */
	U8 ucNoOfCdnBlk;	/* Range: 0 - MAX_CADENCE_BLOCK */

	SCdnBlkParams astCdnParam[MAX_CADENCE_BLOCK];

} SToneGenParams;

typedef struct _SToneGeneric{
	EToneType eToneType;
	U8 ucParamBlockNum;
	union {
		struct _VOIP_QUADTONEGEN stQuadTone;
		struct _VOIP_TONEGEN stDualTone;
	} TonePayload;	
} SToneGeneric;

typedef struct _SPlayToneFlags
{
	EToneId eToneId;
	EToneDir eToneDir;
	U16 usTimestampCtrl:2;
	U16 usProtGen:1;
	U16 usMixModeOn:1;
	U16 usMixModeOff:1;
	U32 uiStartTimeStamp;
	U32 uiLimitTimeStamp;
} SPlayToneFlags;


typedef struct _SOnHookParams {

	U8 ucFSKTone;
		    /**< FSK tone amplitude in mVrms */
	U8 ucDataTxPhase;
		    /**< 0: During ringing */
		    /**< 1: Prior to ringing. */
	U8 ucAlertInfoByte;
		    /**< 0: not required (Default)*/
		    /**< 1: DT-AS */
	U16 usChnlSeizureBits;
		    /**< 0: default */
	U8 ucChnlSeizureFirstBit;
		    /**< 1 or 0 */
	U16 usMarkBits;

} SOnHookParams;

typedef struct _SOffHookParams {
	U8 ucFSKTone;
			/**< FSK tone amplitude in mVrms */
			/**< 0: default */
	U8 ucModFreqByte;
			/**< 0: Bell 202 (Bellcore) */
			/**< 1: ITU-T V.23 FSK (BT and ETSI)(default) */

	U8 ucAlertInfoByte;
			/**< 0: not required */
			/**< 1: DT-AS (default) */
	U16 usMarkBits;
			/**< 0x50: default */

/* CPE_ALERT_TONE_INFO_PARAMS */

	U16 usLowNominalFreq;
			/**< 2130 Hz: default  */
	U16 usHighNominalFreq;
			/**< 2750 Hz: default  */
	U8 ucDuration;
			/**< 80 msec: default  */
	U16 ucLevelLowFreq;
	U16 ucLevelHighFreq;

/* CPE_ACK_INFO_PARAMS */
	U8 ucDtmfDigit1;    /**< `A`: default */
	U8 ucDtmfDigit2;    /**< `D`: default */
	U8 ucMinDurationACK;
		    /**< Range: 0-30 */
		    /**< 30: default */
	U16 usTimeOutForACK;
		    /**< Range: 0-4000 */
		    /**< 160: default */

	U8 ucTimeToDataTx;
		    /**< Range: 0-255 */
		    /**< 160: default */

	U8 ucTxDataIfNoACK;
		    /**< (0 for No, 1 for Yes) */
		    /**< 0: default */
	U16 usAckToneMinLevel;
		    /**< in dBoV */
		    /**< Range: 0-360 */
		    /**< 300: default */

/* SAS_TONE_INFO_PARAMS */
	Boolean bSASToneGen;
		    /**< 0: No SAS Tone Generation using  */
		    /**<    OFF HOOK Caller_ID */
		    /**< 1: Chooses OFF HOOK Caller_ID to  */
		    /**<    generate SAS Tone */
	U8 ucTxTimeToCas;
		    /**< valid only if SAS_tone_generate is */
		    /**< _TRUE; */
/* If chooses OFF HOOK Caller_ID to generate SAS Tone,  */
/* fill the parameter in the following structure   */

	SToneGenParams *pstToneGenParam;

} SOffHookParams;

#define MAX_CALLER_ID_DATA  DEFAULT_FIFO_MAX_SIZE - FIFO_MIN_SIZE - 2
typedef struct _SCallerIdParams {

	U8 ucOnhookOffhookSelect;
		    /**< 0: Off-Hook (default) */
		    /**< 1: On-Hook */
	U8 ucModType;		/*don't care for offhook */
			/**< 0: Bell 202 (Bellcore) */
			/**< 1: ITU-T V.23 FSK (BT and ETSI)(default) */
	U8 ucCIDMsgLen;
	U8 ucCIDMsg[MAX_CALLER_ID_DATA];

	SOnHookParams stOnhookParam;
	SOffHookParams stOffhookParam;
} SCallerIdParams;

/**Caller Id structure vor VFSM_PlayCid()*/
typedef struct _SVcoreCidInfo {
	U16 MsgLen;				/**<Caller ID Messsage length*/
	U8 MsgStr[MAX_CALLER_ID_DATA];		/**<Caller ID Messsage String in SDMF and MDMF format*/
	IN Boolean bIsOnHook;	/**<OnHook / OffHook status of the channel.\n
				If it is TRUE, then ONHOOK caller Id will be generated,\n
				otherwise OFFHOOK caller Id will be generated */
	U8 ucModulType;		/**< 0x00 = BFSK Bel202 standard, 0x01 = CCITT V.23 standard.*/
} SVcoreCidInfo; 


/* Parameters For Caller ID Detection */

typedef struct _SDataFormatType {
	U8 ucDataParitySelection;
			/**<    Data bits and Parity Selection   */
			/**<    0x00 : 8 bits,no parity (default)    */
			/**<    0x01 : 7 bits,even parity */

	U8 ucCRCChecksumSelection;
			/**<    CRC/Checksum Selection   */
			/**<    0x00 : Checksum used for message integrity (default)    */
			/**<    0x01 : CRC used for message integrity */
} SDataFormatType;

typedef struct _SFSKDetectionType {
	U8 ucFSKDetectorType;
			/**<    FSK Detector Type   */
			/**<    0 : B202            */
			/**<    1 : V.23            */
			/**<    2 : Both B202 and V.23 (default) */

	U16 usFSKPullThreshold;
			/**<    FSK Pull in threshold   */
			/**<    0 : default             */
			/**<    Range : 0 to 65535      */

	U16 usFSKDropThreshpld;
			/**<    FSK Drop off threshold   */
			/**<    0 : default              */
			/**<    Range : 0 to 65535       */
/*
 U8     ucReserved;   
*/
} SFSKDetectionType;

typedef struct _SOnHookDetType {
	U16 usChnlSeizThreshold;
			/**<    Channel Seizure Threshold */
			/**<    0x00C0 : (default)        */
			/**<    Range:  0xA0 to 0x12C     */

	U16 usMarkbitThreshold;
			/**<    Mark Bits Threshold   */
			/**<    0x0060 : (default)    */
			/**<    Range : 0x0080 to 0x0EFF */
} SOnHookDetType;

typedef struct _SOffHookDetType {
	U16 usMarkbitThreshold;
			/**<    Mark Bits Threshold   */
			/**<    0x0018 : (default)    */
			/**<    Range : 0x0014 to 0x0EFF */

} SOffHookDetType;

typedef struct _SAckGenzType {
	U8 ucDTMFdigits;
			/**<    DTMF Digit to generate  */
			/**<    0xD :  default          */
			/**<    Range : 0xA to 0xD      */

	U8 ucDelayCPEAlert;
			/**<    Delay time from CPE Alert Detected   */
			/**<    0x14 :  default           */
			/**<    Range : 0x14 to 0xA0      */

	U8 ucAckToneduration;
			/**<    Ack Tone Duration   */
			/**<    sub-field of AckGenType */
			/**<    0x3C :  default           */
			/**<    Range : 0x3C to 0x78      */

	U16 usAcktoneTxlevel;
			/**<    Ack Tone Tx level   */
			/**<    0x0070 :  default (-11.2 dBoV)  */
			/**<    Range : 0x070 to 0x106          */

/*
 U8     ucReserved;
*/
} SAckGenType;

typedef struct _SNTTDetType {
	U8 ucNTTDetector;
			/**<    NTT Detector Enable/Disable   */
			/**<    Disabled : 0  default */
			/**<    Enabled  : 1          */
			/**<    If enabled then DataFormatType option shold be :*/
			/**<    Byte 1 DataBitandParitySelection = 1( 7 bits,even parity) */
			/**<    Byte 2 CRC/Checksum Selection = 1 (CRC) */
/*
 U8     ucReserved;
*/
} SNTTDetType;

typedef struct _SCIDDetectionParams {

	SDataFormatType stDataFormatType;	/* Hex Code 0x01; Info Count 0x02 */
	SFSKDetectionType stFSKDetectionType;	/* Hex Code 0x02; Info Count 0x06 */
	SOnHookDetType stOnHookDetType;	/* Hex Code 0x03; Info Count 0x04 */
	SOffHookDetType stOffHookDetType;	/* Hex Code 0x04; Info Count 0x02 */
	SAckGenType stAckGenType;	/* Hex Code 0x05; Info Count 0x06 */
	SNTTDetType stNTTDetType;	/* Hex Code 0x06; Info Count 0x02 */
	U8 ucCIDDEnableType;
			/**< 0 = On hook CID Detection Enable */
			/**< 1 = Off hook CID Detection Enable */
			/**< 2 = Both On hook and Off hook CID Detection Enable (default)*/

} SCIDDetectionParams;

typedef struct _SCountryInfo {
	SToneGenParams stToneGenParams[CFG_MAX_TONES];
	SCallerIdParams stCallerIdParams;
	SCIDDetectionParams stCIDDetectionParams;	/* added for Caller ID Detection Feature */
} SCountryInfo;

typedef struct _SConferenceParams {
	U8 ucParticipantGain;
	SConfDTSParams stDTSParams;
	struct _VOIP_AGCSET stAGCParams;
} SConferenceParams;

/* each cid info block has 1 word for info type bye + info block count , then parameters*/ 
typedef struct _SOnHookXmitInfoType  {
		Boolean bIsConfigured;
		U16 usOnHookXmitInfoType [ON_HOOK_XMIT_INFO_TYPE_CNT/2 + 1];
} SOnHookXmitInfoType;


typedef struct _SOffHookXmitInfoType {
		Boolean bIsConfigured;
		U16 usOffHookXmitInfoType [OFF_HOOK_XMIT_INFO_TYPE_CNT/2 + 1];
} SOffHookXmitInfoType;

typedef struct _SCPEAlertToneInfoType {
		Boolean bIsConfigured;
		U16 usCPEAlertToneInfoType [CPE_ALERT_TONE_INFO_TYPE_CNT/2 + 1];
} SCPEAlertToneInfoType;

typedef struct _SCPEAckInfoType {
		Boolean bIsConfigured;
		U16 usCPEAckInfoType [CPE_ACK_INFO_TYPE_CNT/2 + 1];
} SCPEAckInfoType;

typedef struct _SSASToneInfoType {
		Boolean bIsConfigured;
		U8 ucBlockSize;
		U16 usSASToneInfoType [SAS_TONE_INFO_TYPE_CNT/2 + 1];
} SSASToneInfoType;

typedef struct _SNTTInfoType {
		Boolean bIsConfigured;
		U16 usNTTInfoType [NTT_INFO_TYPE_CNT/2 + 1];
} SNTTInfoType;

typedef struct _SStopBitsInfoType {
		Boolean bIsConfigured;
		U16 usStopBitsInfoType [STOP_BITS_INFO_TYPE_CNT/2 + 1];
} SStopBitsInfoType;

typedef struct _SPacketProcessingInfoType {
		Boolean bIsConfigured;
		U16 usPacketProcessingInfoType [PACKET_PROCESS_INFO_TYPE_CNT/2 + 1];
} SPacketProcessingInfoType;

typedef struct _SCidGen {
	SOnHookXmitInfoType SOnHookXmitInfoBlock;
	SOffHookXmitInfoType SOffHookXmitInfoBlock;
	SCPEAlertToneInfoType SCPEAlertToneInfoBlock;
	SCPEAckInfoType SCPEAckInfoBlock; 
	SSASToneInfoType SSASToneInfoBlock;
	SNTTInfoType SNTTInfoBlock;
	SStopBitsInfoType SStopBitsInfoBlock;
	SPacketProcessingInfoType SPacketProcessingInfoBlock;
} SCidGen;

typedef struct _SDataFormatInfoType {
		Boolean bIsConfigured;
		U16 usDataFormatInfoType [DATA_FORMAT_INFO_TYPE_CNT/2 + 1];
} SDataFormatInfoType;

typedef struct _SFSKDetectionInfoType {
		Boolean bIsConfigured;
		U16 usFSKDetectionInfoType [FSK_DETECTION_INFO_TYPE_CNT/2 + 1];
} SFSKDetectionInfoType;

typedef struct _SOnHookDetInfoType {
		Boolean bIsConfigured;
		U16 usOnHookDetInfoType [ON_HOOK_DET_INFO_TYPE_CNT/2 + 1];
} SOnHookDetInfoType;

typedef struct _SOffHookDetInfoType {
		Boolean bIsConfigured;
		U16 usOffHookDetInfoType [OFF_HOOK_DET_INFO_TYPE_CNT/2 + 1];
} SOffHookDetInfoType;

typedef struct _SAckGenInfoType {
		Boolean bIsConfigured;
		U16 usAckGenInfoType [ACK_GEN_INFO_TYPE_CNT/2 + 1];
} SAckGenInfoType;

typedef struct _SNTTDetInfoType {
		Boolean bIsConfigured;
		U16 usNTTDetInfoType [NTT_DET_INFO_TYPE_CNT/2 + 1];
} SNTTDetInfoType;

typedef struct _SCidDet {
	SDataFormatInfoType SDataFormatInfoBlock;
	SFSKDetectionInfoType SFSKDetectionInfoBlock; 
	SOnHookDetInfoType SOnHookDetInfoBlock;
	SOffHookDetInfoType SOffHookDetInfoBlock;
	SAckGenInfoType SAckGenInfoBlock;
	SNTTDetInfoType SNTTDetInfoBlock;
} SCidDet;


#ifdef __cplusplus
};
#endif

#endif /* _VCORETYPES_H_ */
