/*! \file vcore.h 
 * Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

#ifndef _VCORE_H
#define _VCORE_H

#include "cfg.h"
#include "dmgr.h"
#include "gtl.h"
#include "vcore_voip.h"

/*Constants*/

#define PT_G711_U_LAW   0
#define PT_G711_A_LAW   8

#define LSP 0x0000
#define RSP 0x0001
#define TRANS 0x0011

#define MAX_WB_TS	4

#define TONE_MAX_FREQ	4000
#define TONE_MAX_AMP	692

#define CIDD_ENABLE_ONHK  0
#define CIDD_ENABLE_OFFHK 1
#define CIDD_ENABLE_BOTH  2

#define VAPI_IND_STOP_REC_PLAY 0xEEEE
#define REC_PLAY_TERMINATOR 0xFFEE

#define FIFO_NOT_EMPTY -2

#define SYNCEOF_PACKET			1
#define SYNCDAT_PACKET			2
#define MALFORMED_PACKET        	3
#define MIN_FRAME_SIZE 			16
#define MAX_FRAME_SIZE			1500
#define OFFSET_FOR_TIMESTAMP		0
#define OFFSET_FOR_FRAME_TYPE		2
#define OFFSET_FOR_BUF_LEN		3
#define COMMAND_HEADER_LEN		sizeof(struct comcerto_api_hdr)
#define PACKET_HEADER_LEN		4
#define FRAME_HEADER_LEN		8
#define MAX_FRAME_LEN_SYNCEOF		sizeof(struct _SYNCEOF) - sizeof(struct comcerto_api_hdr)
#define MAX_FRAME_LEN_EXT_SYNCEOF	1500 - sizeof(struct comcerto_api_hdr)

#define H245_MAX_LEN	248
#define H245_MSG_HDR_LEN	4

/* ELF format support */
/* copied from usr/include/elf.h */
#ifndef _ELF_H
#define EI_NIDENT (16)
typedef U16 Elf32_Half;
typedef U32 Elf32_Word;
typedef U32 Elf32_Addr;
typedef U32 Elf32_Off;

#define EI_MAG0		0	/* File identification byte 0 index */
#define ELFMAG0		0x7f	/* Magic number byte 0 */

#define EI_MAG1		1	/* File identification byte 1 index */
#define ELFMAG1		'E'	/* Magic number byte 1 */

#define EI_MAG2		2	/* File identification byte 2 index */
#define ELFMAG2		'L'	/* Magic number byte 2 */

#define EI_MAG3		3	/* File identification byte 3 index */
#define ELFMAG3		'F'	/* Magic number byte 3 */

#define EI_CLASS	4	/* File class byte index */
#define EI_DATA		5	/* Data encoding byte index */
#define ELFCLASS32	1	/* 32-bit objects */
#define ELFDATA2LSB	1	/* 2's complement, little endian */

typedef struct {
	unsigned char e_ident[EI_NIDENT];	/* Magic number and other info */
	Elf32_Half e_type;	/* Object file type */
	Elf32_Half e_machine;	/* Architecture */
	Elf32_Word e_version;	/* Object file version */
	Elf32_Addr e_entry;	/* Entry point virtual address */
	Elf32_Off e_phoff;	/* Program header table file offset */
	Elf32_Off e_shoff;	/* Section header table file offset */
	Elf32_Word e_flags;	/* Processor-specific flags */
	Elf32_Half e_ehsize;	/* ELF header size in bytes */
	Elf32_Half e_phentsize;	/* Program header table entry size */
	Elf32_Half e_phnum;	/* Program header table entry count */
	Elf32_Half e_shentsize;	/* Section header table entry size */
	Elf32_Half e_shnum;	/* Section header table entry count */
	Elf32_Half e_shstrndx;	/* Section header string table index */
} Elf32_Ehdr;

typedef struct {
	Elf32_Word sh_name;	/* Section name (string tbl index) */
	Elf32_Word sh_type;	/* Section type */
	Elf32_Word sh_flags;	/* Section flags */
	Elf32_Addr sh_addr;	/* Section virtual addr at execution */
	Elf32_Off sh_offset;	/* Section file offset */
	Elf32_Word sh_size;	/* Section size in bytes */
	Elf32_Word sh_link;	/* Link to another section */
	Elf32_Word sh_info;	/* Additional section information */
	Elf32_Word sh_addralign;	/* Section alignment */
	Elf32_Word sh_entsize;	/* Entry size if section holds table */
} Elf32_Shdr;

/** Perfoms 32 bit message payload length alignment*/
#define ALIGN_MESSAGE_LENGTH(size) (((size) + 3) & ~0x3)

#define	_ELF_H 1
#define EM_ARM		40	/* ARM */

#define SHF_MIPS_ADDR 0x40000000
#define SHT_PROGBITS 1
#endif

#define USER_CONTEXT 0
#define VAPI_CONTEXT 1

#define ETH_P_IP	0x0800		/* Internet Protocol V4 packet */
#define ETH_P_8021Q	0x8100		/* 802.1Q VLAN Extended Header */
#define ETH_BRCM	0x8874		/*BRCM type */

/* FSM events */
#define FSM_EVENT_START			0
#define FSM_EVENT_DEV_MSG		1
#define FSM_EVENT_TIMEOUT		2
#define FSM_EVENT_REC_PLAY_TERMINATOR	3
#define FSM_EVENT_LOCKED		4
#define FSM_EVENT_UNLOCK		5
#define FSM_EVENT_PLAY_REC_STOP	6

#define BOOT_MAAS			0
#define BOOT_PROMISCUOUS_MODE		1
#define BOOT_QUERY_READY		2
#define BOOT_WAIT_QUERY_READY_ACK	3
#define BOOT_WAIT_READY			4
#define BOOT_INIT_FINISHED		5

/* BootDevice fsm handler states */
#define FSM_STATE_BOOT_INIT 				0
#define FSM_STATE_BOOT_DO_ELF_SECTION_DOWNLOAD		1
#define FSM_STATE_BOOT_DO_AXF_SECTION_DOWNLOAD		2
#define FSM_STATE_BOOT_DO_DATA_DOWNLOAD			3
#define FSM_STATE_BOOT_DO_FAT_DOWNLOAD			4
#define FSM_STATE_BOOT_POS_FILLMEM_WAIT			5
#define FSM_STATE_BOOT_DO_CHECKSUM			6
#define FSM_STATE_BOOT_DO_RUN_CHECKSUM			7
#define FSM_STATE_BOOT_DO_PROGSTART			8
#define FSM_STATE_BOOT_DO_START_TIMER			9
#define FSM_STATE_BOOT_DO_WAIT_SUPERVISOR_READY	10

/* Child handlers of Dowloads */
#define FSM_STATE_BUF_DOWNLOAD			0
#define FSM_STATE_BUF_FINISH_DOWNLOAD		1
#define FSM_STATE_CODE_DOWNLOAD			0
#define FSM_STATE_CODE_FINISH_DOWNLOAD		1
#define FSM_STATE_DATA_DOWNLOAD			0
#define FSM_STATE_DATA_FINISH_DOWNLOAD		1
#define FSM_STATE_FAT_DOWNLOAD			0
#define FSM_STATE_FAT_DOWNLOAD_FINISH		1

/* AxfDownload fsm handler states */
#define FSM_STATE_AXF_CODE_DOWNLOAD		0
#define FSM_STATE_AXF_DATA_DOWNLOAD		1
#define FSM_STATE_AXF_FAT_DOWNLOAD		2
#define FSM_STATE_AXF_FINISH_DOWNLOAD		3

/* ElfDownload fsm handler states */
#define FSM_STATE_ELF_CODE_DOWNLOAD		0
#define FSM_STATE_ELF_FINISH_DOWNLOAD		1

/* InitDevice fsm handler states */
#define DEV_INIT_GET_MR				0
#define DEV_INIT_GET_MODEL			1
#define DEV_INIT_SPU_INIT			2
#define DEV_INIT_ENABLE_MULTI_CMDS		3
#define DEV_INIT_FINISHED			4

#define RECOV_GET_MR			1
#define RECOV_GET_ETH			2
#define RECOV_GET_IP			3
#define RECOV_GET_CSME_MULTI		4
#define RECOV_GET_SPU			5
#define RECOV_FINISH			6

#define DEV_ETH_MAC_INIT		0
#define DEV_ETH_MAC_FINISHED		1

#define CONN_ETH_MAC_INIT		0
#define CONN_ETH_MAC_STOP		1
#define CONN_ETH_MAC_CHECK		2
#define CONN_ETH_MAC_FINISHED		3

/* SetDevIpaddr fsm handler states */
#define SET_IP_ADDR_INIT		0

/* Destroy Channel fsm handler states */
#define DESTROY_CHANNEL_INIT            0
#define DESTROY_CHANNEL_FINISHED            1

/* Destroy participant fsm handler states */
#define DESTROY_PARTICIPANT_INIT	0
#define DESTROY_PARTICIPANT_FINISHED	1

/* Create Channel fsm handler states */
#define CREATE_CHANNEL_INIT		0
#define CREATE_CHANNEL_FINISHED		1

/* Recover Channel fsm handler states */
#define RECOVER_CHANNEL_INIT		0
#define RECOVER_CHANNEL_FINISHED	1

#define CHANGE_TYPE_INIT			0
#define CHANGE_TYPE_STOP_CONN_WAIT_CHILD	1
#define CHANGE_TYPE_DESTROY_WAIT_CHILD		2
#define CHANGE_TYPE_CREATE_FINISHED		3

/* Modify connection fsm handler states */
#define MOD_CONN_INIT			0
#define MOD_CONN_SEND_COMM		1
#define MOD_CONN_FINISHED		2

/* Create connection fsm handler states */
#define CREATE_CONNECTION_INIT		0
#define CREATE_CONNECTION_CONFIG	1
#define CREATE_CONNECTION_FINISHED	2

/* Allcoate connection fsm handler states */
#define ALLOCATE_CONNECTION_INIT	0
#define ALLOCATE_CONNECTION_FINISHED	1

/* Destroy connection fsm handler states */
#define DESTROY_CONN_INIT			0
#define DESTROY_CONN_DESTROY_CHANNEL		1
#define DESTROY_CONN_DESTROY_PART		2
#define DESTROY_CONN_FINISHED			3

#define STOP_CONN_INIT		0
#define STOP_CONN_FINISHED	1

#define START_CONN_INIT			0
#define START_CONN_WAIT_VCEOPT_ACK	1
#define START_CONN_FINISHED		2

#define INIT_FAX_CHANNEL_INIT		0
#define INIT_FAX_CHANNEL_FAXLVL_SEND	1
#define INIT_FAX_CHANNEL_PT_SET_SEND	2
#define INIT_FAX_CHANNEL_FINISHED	3

#define INIT_CHANNEL_INIT		0
#define INIT_CHANNEL_FINISHED		1

#define INIT_CHANNEL_TRANSPORT_INIT		0
#define INIT_CHANNEL_TRANSPORT_IP_PARAMS_SEND	1
#define INIT_CHANNEL_TRANSPORT_FINISHED		2

#define CHANGE_CONN_TYPE_INIT			0
#define CHANGE_CONN_TYPE_CREATE_CHANNEL	1
#define CHANGE_CONN_TYPE_CREATE_PART		2
#define CHANGE_CONN_TYPE_SET_OP_MODE		3
#define CHANGE_CONN_TYPE_FINISHED		4

#define INIT_CHANGED_CONN_INIT		0
#define INIT_CHANGED_CONN_FINISHED	1

 /*tCodecType fsm handler states */
#define SET_CODEC_INIT		0
#define SET_CODEC_WAIT_VOPDIS	1
#define SET_CODEC_WAIT_VOPENA	2
#define SET_CODEC_BACK		3
#define SET_CODEC_FINISHED	4

#define SET_PAYLOAD_INIT	0
#define SET_PAYLOAD_BOTH_DIR	1
#define SET_PAYLOAD_FINISHED	2
#define SET_PAYLOAD_VIDEO_FINISHED 3

#define PACKET_INTERVAL_INIT		0
#define PACKET_INTERVAL_VCEOPT		1
#define PACKET_INTERVAL_RENABLE		2
#define PACKET_INTERVAL_FINISHED	3

#define START_CID_INIT		0
#define START_CID_GEN		1
#define START_CID_FINISHED	2

#define STOP_CID_INIT		0
#define STOP_CID_FINISHED	1

#define START_TONE_INIT		0
#define START_TONE_FINISHED	1

#define PLAY_TONE_INIT		0
#define PLAY_TONE_FINISHED	1

#define STOP_TONE_INIT		0
#define STOP_TONE_FINISHED	1

#define SET_TDM_INIT		0
#define SET_TDM_ENABLE		1
#define SET_TDM_PARAM_0		2
#define SET_TDM_PARAM_1		3
#define SET_TDM_PARAM_2		4
#define SET_TDM_PARAM_3		5
#define SET_TDM_FINISHED	6

#define CID_DET_ENABLE_INIT	0
#define CID_DET_ENABLE_CTRL	1
#define CID_DET_ENABLE_BOTH	2
#define CID_DET_ENABLE_FINISHED	3

#define MUTE_PART_INIT		0
#define MUTE_PART_FINISHED	1

#define HOLD_PART_INIT		0
#define HOLD_PART_FINISHED	1

#define SET_PART_DGAIN_INIT		0
#define SET_PART_DGAIN_FINISHED	1

#define SET_PART_OPT_INIT	0
#define SET_PART_OPT_FINISHED	1

#define RTP_SSRC_INIT		0
#define RTP_SSRC_FINISHED	1

#define SEND_NTE_INIT		0
#define SEND_NTE_FINISHED	1

#define ECHOCAN_RESET_INIT	0
#define ECHOCAN_RESET_FINISHED	1

#define T38_OPTIONS_INIT		0
#define T38_OPTIONS_FAX_LEVEL		1
#define T38_OPTIONS_FAX_FINISHED	2
#define T38_OPTIONS_FAX_SKIP		3

#define T38_INIT                        0
#define T38_VOPENA_DIS_SENT             1
#define T38_SUPV_CHNL_READY_FOR_DESTROY 2
#define T38_SUPV_DESTROY_CHNL_SENT      3
#define T38_SUPV_CHNL_CREATE_SENT       4
#define T38_CHNL_FAX_OPT_SENT           5
#define T38_CHNL_FAX_LVL_SENT           6
#define T38_SWITCH_FINISHED             7

#define CREATE_CONFERENCE_INIT		0
#define CREATE_CONFERENCE_CHECK		1
#define CREATE_CONFERENCE_FINISHED	2

#define CREATE_CONF_PARTICIPANT_INIT		0
#define CREATE_CONF_PARTICIPANT_SET_AGC		1
#define CREATE_CONF_PARTICIPANT_VCEOPT		2
#define CREATE_CONF_PARTICIPANT_VOPENA		3
#define CREATE_CONF_PARTICIPANT_FINISHED	4

#define ALLOCATE_CONF_PARTICIPANT_INIT		0
#define ALLOCATE_CONF_PARTICIPANT_FINISHED	1

#define CREATE_PARTICIPANT_INIT		0
#define CREATE_PARTICIPANT_FINISHED	1

#define PURGE_CONFERENCE_INIT		0
#define PURGE_CONFERENCE_FINISHED	1

#define DESTROY_CONFERENCE_INIT		0
#define DESTROY_CONFERENCE_DESTROY_PART	1
#define DESTROY_CONFERENCE_DESTROY_CONF	2
#define DESTROY_CONFERENCE_FINISHED	3

#define PASSTHRU_INIT		0
#define PASSTHRU_FINISHED	1

#define SET_TRANSCONNECT_INIT		0
#define SET_TRANSCONNECT_FINISHED	1

#define TRANSCODING_INIT		0
#define TRANSCODING_STOP_CHANNEL_1	1
#define TRANSCODING_STOP_CHANNEL_2	2
#define TRANSCODING_START		3
#define TRANSCODING_START_CHANNEL2	4
#define TRANSCODING_START_CHANNEL1	5
#define TRANSCODING_FINISHED		6

#define COREDUMP_INIT		0
#define COREDUMP_SET_HARDWARE	1
#define COREDUMP_SET_EMAC_DMA	2
#define COREDUMP_READ		3
#define COREDUMP_FINISHED	4

#define SET_EMAC_DMA_INIT	0
#define SET_EMAC_DMA_WRITE	1
#define SET_EMAC_DMA_FINISHED	2

#define DEVICE_HARDWARE_INIT			0
#define DEVICE_HARDWARE_SET_PLL_WA_PCI		1
#define DEVICE_HARDWARE_SET_CLOCK		2
#define DEVICE_HARDWARE_SET_ARM_CLOCK		3
#define DEVICE_HARDWARE_SET_SDRAM		4
#define DEVICE_HARDWARE_SET_SDRAM_PARAM2	5
#define DEVICE_HARDWARE_SET_CS_BASEADDR	6
#define DEVICE_HARDWARE_SET_CS_SDRAM		7
#define DEVICE_HARDWARE_POS_SET_PLL		8
#define DEVICE_HARDWARE_POS_SET_SDRAM		9
#define DEVICE_HARDWARE_FINISHED		10

#define DEVICE_HARDWARE_900_INIT		0
#define DEVICE_HARDWARE_900_SET_PLL_WA_PCI	1
#define DEVICE_HARDWARE_900_SET_SDRAM		2
#define DEVICE_HARDWARE_900_SET_SDRAM_PARAM2	3
#define DEVICE_HARDWARE_900_SET_CS_BASEADDR	4
#define DEVICE_HARDWARE_900_SET_CS_SDRAM	5
#define DEVICE_HARDWARE_900_POS_SET_PLL	6
#define DEVICE_HARDWARE_900_POS_SET_SDRAM	7
#define DEVICE_HARDWARE_900_FINISHED		8

#define DEVICE_HARDWARE_300_INIT		0
#define DEVICE_HARDWARE_300_SET_BUS_ARM	1
#define DEVICE_HARDWARE_300_SET_SDRAM		2
#define DEVICE_HARDWARE_300_SET_CS_BASEADDR	3
#define DEVICE_HARDWARE_300_SET_CS_SDRAM	4
#define DEVICE_HARDWARE_300_FINISHED		5

#define SET_SDRAM_300_1_INIT			0
#define SET_SDRAM_300_1_PARAM2			1
#define SET_SDRAM_300_1_FINISHED		2

#define SET_SDRAM_300_2_INIT			0
#define SET_SDRAM_300_2_SET_BUFFER_TYPE		1
#define SET_SDRAM_300_2_SET_BUFFER_TYPE_PCI	2
#define SET_SDRAM_300_2_INIT_SDC		3
#define SET_SDRAM_300_2_WRITE_DATA		4
#define SET_SDRAM_300_2_FINISHED		5

#define MODIFY_T38_INIT			0
#define MODIFY_T38_CHANGE_TYPE_DONE	1
#define MODIFY_T38_INIT_TRANSPORT	2
#define MODIFY_T38_ENABLED		3
#define MODIFY_T38_FINISHED		4

#define IP_PARAMS_INIT		0
#define IP_PARAMS_FINISHED	1

#define DEV_IP_ADDR_INIT	0
#define DEV_IP_ADDR_SET_ARP	1
#define DEV_IP_ADDR_SET_ICMP	2
#define DEV_IP_ADDR_SET_IP	3
#define DEV_IP_ADDR_SET_SINGLE	4
#define DEV_IP_ADDR_SET_MULTI	5

#define LOCK_CONN_INIT		0
#define LOCK_CONN_WAIT		1
#define LOCK_CONN_FINISHED	2

#define SINGLE_LOOPBACK_INIT		0
#define SINGLE_LOOPBACK_FINISHED	1

#define LOOPBACK_INTER_INIT	0
#define LOOPBACK_INTER_CHNL1	1
#define LOOPBACK_INTER_CHNL2	2
#define LOOPBACK_INTER_FINISHED	3

#define INTERCHANNEL_INIT	0
#define INTERCHANNEL_FINISHED	1

#define ENABLE_THC_INIT		0
#define ENABLE_THC_FINISHED	1

#define THC_ENABLE_LOOPBACK_INIT		0
#define THC_ENABLE_LOOPBACK_ENABLE_1		1
#define THC_ENABLE_LOOPBACK_ENABLE_2		2
#define THC_ENABLE_LOOPBACK_ENABLE_REDIRECT	3
#define THC_ENABLE_LOOPBACK_FINISHED		4
#define THC_DISABLE_LOOPBACK_INIT		5
#define THC_DISABLE_LOOPBACK_1			6
#define THC_DISABLE_LOOPBACK_2			7
#define THC_DISABLE_LOOPBACK_FINISHED		8

#define SET_CSE_MAP_CHANNEL_INIT	0
#define SET_CSE_MAP_CHANNEL_FINISHED	1
#define MAX_CSEOPSN_CHANNEL		30

#define SET_CONF_LATENCY_INIT		0
#define SET_CONF_LATENCY_FINISHED	1

#define SET_CONF_DGAIN_INIT		0
#define SET_CONF_DGAIN_FINISHED	1

#define START_RECORDING_FLOW_CONTROL		0
#define START_RECORDING_SWITH_REC_MODE		1
#define START_RECORDING_INIT			2
#define START_RECORDING_SWITCH_VOP_MODE	3
#define START_RECORDING_FINISH			4

#define START_PLAYING_SWITCH_PLAY_MODE		0
#define START_PLAYING_INIT			1
#define START_PLAYING_SWITCH_VOP_MODE		2
#define START_PLAYING_FINISH			3

#define PLAY_DATA_TRANSFER_INIT		0
#define PLAY_DATA_TRANSFER_PROCEED		1
#define PLAY_DATA_TRANSFER_NEXT_PACKET		2
#define PLAY_DATA_TRANSFER_COMPLETE_REMAIN	3
#define PLAY_DATA_TRANSFER_WAIT_IND		4
#define PLAY_DATA_TRANSFER_FINISH		5

#define REC_DATA_TRANSFER_INIT			0
#define REC_DATA_TRANSFER_PROCEED		1
#define REC_DATA_TRANSFER_COMPLETE_REMAIN	2
#define REC_DATA_TRANSFER_FINISH		3

#define PLAY_SET_RATE_INIT			0
#define PLAY_SET_RATE_FINISH			1

#define CONVERT_SPEECH_SET_FLOW_CTR		0
#define CONVERT_SPEECH_SWITCH_PLAY_MODE	1
#define CONVERT_SPEECH_INIT			2
#define CONVERT_SPEECH_SWITCH_VOIP_MODE	3
#define CONVERT_SPEECH_FINISH			4

#define CONVERT_SPEECH_TRANSFER_INIT		0
#define CONVERT_SPEECH_TRANSFER_NEXT		1

#define SEND_H245_INIT			0
#define SEND_H245_PROCEED		1
#define SEND_H245_FINISH		2

#define C2C_CONNECT_UP_INIT		0
#define C2C_CONNECT_UP_LOCK_CHANNEL2	1
#define C2C_CONNECT_UP_START		2
#define C2C_CONNECT_UP_FINISHED		3

#define SET_CONNECT_UP_INIT 0
#define SET_CONNECT_UP_FINISHED 1

#define PURGE_MSP_RES_INIT		0
#define PURGE_MSP_RES_WAIT_IND		1
#define PURGE_MSP_RES_FINISHED		2

/* Data Structures*/

struct _SVapiReq;

/** Vapi Request-FSM handler's Signature */
typedef VSTATUS(*PFNReqFsmHdlr) (SChnl * pstChnl, struct _SVapiReq * pstVapiReq, U16 Event, gtl_msg_t * pstMsg);

/** Stores all the information and state for a VAPI Request.*/
typedef struct _SVapiReq {
	struct _SVapiReq *pstParentReq;
	struct _SChnl *pstChnl;
	U32 uiID;		/**< Device or connection Id on which request is will be completed.*/
	U16 usReqState;		/**< Keeps track of currrent state of request*/

	SLstNode stNode;

	void *pvExecData;  /**< Data that needs to be stored between multiple 
                           calls of ReqFSM Handler  */
	void *pvUserData;  /**< Required as an input to VAPI request*/
	void *pvCallbackData;/**< In case if VAPI library needs to
                                return some data to the caller,
                                this pointer is used to point
                                to the memory for holding the data.
                                In other cases it should be NULL.
                                The information from MSP
                                responses will be stored in this
                                area by the response handler.
                                The callback will deliver the data
                                to the application.
                              */
	U32 uiCallbkDataLen;		/** Length of the callback data*/
	VSTATUS Status;			/**< Status of the callback*/
	SSem *pstSemReqComp;		/**< Request completion semaphore used for blocking calls*/
	PFNIoCompCallback pfnCallback;	/**< Called on completion of request*/
	U32 uiReqId;			/** Request Id provided by application*/
	PFNReqFsmHdlr pfnReqFSMHdlr;	/**< Handles the FSM of a specific request*/
	U8 ucInProgress;
	U8 ucCmdLevel;
	U8 ucThreadContext;		/**<  USER_THREAD or VAPI_THREAD to know if the request process
					is current inititated by from the user or from VAPI itself(i.e GTLread)*/
	Boolean bIsSync       ;		/**< User call without callback function */ 

} SVapiReq;

struct _AIF_HEADER {
	U32 BL_DecompressCode;	/* 00 */
	U32 BL_SelfRelocCode;	/* 04 */
	U32 BL_DbgInitZeroInit;	/* 08 */
	U32 EntryPointOffset;	/* 0C */
	U32 ProgramExitInstr;	/* 10 */
	U32 ImageReadOnlySize;	/* 14    in bytes */
	U32 ImageReadWriteSize;	/* 18    in bytes */
	U32 ImageDebugSize;	/* 1C */
	U32 ImageZeroInitSize;	/* 20 */
	U32 ImageDebugType;	/* 24 */
	U32 ImageBase;		/* 28    32 bit address */
	U32 WorkSpace;		/* 2C */
	U32 AddressMode;	/* 30 */
	U32 DataBase;		/* 34    32 bit address */
	U32 FirstFatOffset;	/* 38    byte offset in file */
	U32 Reserved2;		/* 3C */
	U32 DebugInitInstr;	/* 40 */
	U32 ZeroInitCode[15];	/* 44...80 */
};

struct _FAT_AIF_HEADER {
	U32 NextFatOffset;	/* byte offset in file */
	U32 LoadAddress;	/* 32 bit address */
	U32 Size;		/* in bytes */
	U8 region_name[32];
};

/** BootDevice Execution data */
typedef struct _SBootDevExecData {
	S32 iCodeBytesToLoad;
	U32 uiCodeLoadAddr;
	U32 uiCodeImageOffset;
	S32 iDataBytesToLoad;
	U32 uiDataLoadAddr;
	U32 uiDataImageOffset;
	S32 iFatBytesToLoad;
	U32 uiFatLoadAddr;
	U32 uiFatImageOffset;
	U32 uiImageEnd;
	U32 uiFatOffset;
	U32 uiCheckSumAddr;
	U32 uiStartAddr;
	U8 SectionNumber;
	U8 PreviousSectionNumber;
	Elf32_Shdr *this_section_headers;
	Elf32_Half number_of_section;
	Elf32_Off string_section_offset;
	Boolean bIsElfFormat;
} SBootDevExecData;

/** User data for VCORE_BootDeviceFile */
typedef struct _SBootDevFileData {
	U8 strFileName[256];
	struct _AIF_HEADER AifHdr;
	struct _FAT_AIF_HEADER FatHdr;
	Elf32_Ehdr ElfHeader;
	S32 iFd;
	S32 iFileLen;
	SHwCfg *pstSHwCfg; /**< pointer on structure with modified HW params */
} SBootDevFileData;

/** Coredump data */
typedef struct {
	U8 *puchBuff;	/**< Pointer to user supplied buffer 
                        to hold the memory data */
	U32 ulBuffSize;	/**< Size of the supplied buffer (num bytes) */
	U32 *pulDataSize;
			/**< To inform the user number of bytes actually read */

	U32 ulMemBase;	/**< Base of the memory to read  */
	U32 ulMemSize;	/**< Size of the memory */
	U32 ulOffset;	/**< Offset in the memory to start reading from */

	Boolean *pbLastRead; /**< Flag to indicate last read for the specified memory */
	SHwCfg *pstSHwCfg; /**< pointer on structure with modified HW params */
} SCoreDumpData;

typedef struct _SFrameInfo {
	U32 uiFrameLen;
	U32 uiFrameTimeStamp;	
	U32 uiBufferSizeLeft;
	U8 ucIsHdrPresent;
	U8 *pucFrameBuffer;
	U8 *pucFrameBufferStart;
} SFrameInfo;

typedef struct _SConvertFrameInfo {
	SFrameInfo stInFrame;
	SFrameInfo stOutFrame;
} SConvertFrameInfo;

typedef struct _SHostSpeechData {
	U8 ucMediaHost;
	U8 ucSrcCoding;
	U8 ucDestinationType;
	U8 ucSourceType;
	STimer *pstSTimer;
	U32 uiTimeOut;
	U8 ucDestCoding;
	EPlaybackMode ePlaybackMode;
	U8 *pucBuffer;
	U32 uiBufferLength;
	U8 *pucOutBuffer;
	U32 uiOutBufferLength;
	char strAnnFileName[256];
	U8 uiHostSpeechDataFormat;
	int iFileDisc;
	U8 uiProceedToStop;
	EStopAnnType eStopAnnType;
	U8 uiDrainStopType;
	U8 uiDrainToAsStop;
	U16 uiReceivedIndType;
	U8 uiNumOfPacketsToBeConverted;
	PFNIoCompCallback pfnFrameHndlr;
	SMutex stHostSpeechDataMutex;
} SHostSpeechData;

typedef struct _SH245Data {
	U16 uiH245MsgLength;
	U8 *ptrH245Msg;
} SH245Data;

typedef struct _SH245Packet {
	U16 uiH245MsgLength;
	U16 uiH245SizeLeft;
	U16 uiH245PacketLen;
	U8 *ptrH245Packet;
	U16 uiEndOfMsg;
} SH245Packet;

/** Set Codec data */
typedef struct _SCodecData {
	Boolean bIsCodecChanged;	/**< Is VOPENA disabled is called from SetCodecType*/
	U32 uiCurrRTPHeaderPT;		/**< Current value of RTP header payload type*/
	VSTATUS Status;
} SCodecData;

typedef struct _STranscodingParams
{
	Boolean TranscodingEnable; 	/**< Enable / disable transcoding session */
	U8 ucDSPMode;			/**< DSP bypass mode */
	U8 ucVirtualTranscoding;	/**< Virtual transcoding latency */
	CONNID Connection2Id;		/**< Id of the second connection involved in transcoding session */
} STranscodingParams;

typedef struct _STransConnectParams
{
	Boolean bTranscodingEnable; 	/**< Enable / disable transcoding session */
	U8 ucDSPMode;			/**< DSP bypass mode */
	U8 ucVirtualTranscoding;	/**< Virtual transcoding latency */
	U16 Channel1Id;			/**< Id of the Comcerto channel 1 involved in transcoding session */
	U16 Channel1PT;			/**< Payload Type of the Comcerto channel 1 */
	U16 Channel2Id;			/**< Id of the Comcerto channel 2 involved in transcoding session*/
	U16 Channel2PT;			/**< Payload Type of the Comcerto channel 2 */
} STransConnectParams;

typedef struct _SFsmParticipantInfo
{
	U16 DevPartId;		/**< Device Participant ID */
	U16 DevConfId;		/**< Device Conference ID */
} SFsmParticipantInfo;

typedef struct _SFsmCreateChannelInfo
{
	U16 DevChannelType;	/**< Device Channel type */
	U16 DevChannelTS;	/**< Device CHannel TimeSlot */
	OUT U16 *DevChannelId;	/**< Device Channel ID */
} SFsmCreateChannelInfo;

typedef struct _SFsmModifyChannelInfo
{
	U16 DevChannelType;	/**< Device Channel Type */
	U32 OpMode;		/**< operation mode */
	U32 ProfileId;		/**< Profile ID */
} SFsmModifyChannelInfo;

typedef struct _SFsmFaxOptions
{
	struct _FAXOPT stFaxOpts;	/**< Fax Options*/
	struct _FAXLVL stFaxLevel;	/**< Fax level */
	Boolean bUseIt;			/**< Use provided options. \n
					If False, Will not modify FAXOPT & FAXLVL settings
					That is, stFaxOpts and ucFaxTxLvl
					of this struct will not be used and previous
					settings will be used */
} SFsmFaxOptions;

typedef struct _SInitChannel
{
	SFsmModifyChannelInfo stFsmModifyChannelInfo;	/**< Modify Channel Info */
	SFsmFaxOptions stFsmFaxOptions;			/**< FAX options */
} SInitChannel;

typedef struct _SFsmCesoPsnMapChannelInfo
{
	U16 MasterChannel;		/**< Master channel */
	U16 Action;			/**< Link/Unlink */
	U16 NumOfChannels;		/**< Number of channels to link */
	U16 pusLinkedChannels[MAX_CSEOPSN_CHANNEL];	/**< Linked Channel array. Assuming 30 channels linked max */
	U8 MapType;			/**< map channels or timeslots*/
} SFsmCesoPsnMapChannelInfo;

/** Set Codec data */
typedef struct _SStopToneData
{
	U16 usDuration;
	U16 usSide;
} SStopToneData;

/** All info for Change Connection */
typedef struct _SFullChangeConnInfo
{
	SChangeConnInfo stChangeConnInfo;
	U16 NumParam;
	U16 *pusParams;
} SFullChangeConnInfo;

/** All info for Modify Connection */
typedef struct _SFullModConnInfo
{
	SModifyConnectionInfo *pstModConnInfo;
	U16 usModifyNum;
} SFullModConnInfo;

/*SPECIFIC MSP COMMAND FUNCTIONS*/
/** Set up a MSP Command message with the supplied parameters*/
void VCORE_SetupCmdMsg(OUT gtl_msg_t * pstMsg,
		       IN U16 usChnlId, IN U8 ucCmdClass, IN U8 ucCmdType, IN U16 usFcode, IN U8 ucFifoLen);
/** Fill the msg fifo with the list of supplied parameters value*/
VSTATUS VCORE_SetPayloadMsg(IN OUT gtl_msg_t * pstMsg, U16 ParamsNum, ...);
/** Fill the msg fifo with the parameters supplied in the buffer*/
VSTATUS VCORE_SetPayloadMsgFromBuffer(IN OUT gtl_msg_t * pstMsg, U16 ParamsNum, U16 *Parameters);
/** Fill the msg fifo with the parameters supplied in the buffer without adjusting the padding*/
VSTATUS VCORE_AddPayloadMsgFromBuffer(IN OUT gtl_msg_t * pstMsg, U16 usParamsNum, U16 *Parameters);
/** Fill the msg fifo with the list of supplied parameters value*/
VSTATUS VCORE_SetPayloadMsgFromList(IN OUT gtl_msg_t * pstMsg, U16 ParamsNum, va_list ParamList);
/** add a single parameter to a message*/
void VCORE_PutParamPayloadMsg(IN OUT gtl_msg_t * pstMsg, U16 usParameter);
/** adjust the fifo_size with pading*/
VSTATUS VCORE_SetPaddingMsg(IN OUT gtl_msg_t * pstMsg);
/** Sends SUPV_CREATE_CHNL*/
VSTATUS VDEV_CreateChannel(IN SChnl * pstChnl, IN SChnl * pstChannelInfo);
/** Sends SUPV_CREATE_CHNL query*/
VSTATUS VDEV_RecoverChannel(IN SChnl * pstChnl, IN U16 usTDMTimeSlot);

/** Sends SUPV_DESTROY_CHNL*/
VSTATUS VDEV_DestroyChannel(IN SChnl * pstChnl, CHNLID ChnlId);

/** Sends VOIP_VCEOPT*/
VSTATUS VDEV_SetVceopt(gtl_msg_t *stMsg, IN struct _VOIP_VCEOPT *pstVceParams);
VSTATUS VDEV_SendVceopt(IN SChnl * pstChnl, IN struct _VOIP_VCEOPT *pstVceParams);

/** Sends VOIP_VOPENA*/
VSTATUS VDEV_SetVoipVopena(gtl_msg_t *pstMsg, IN struct _VOIP_VOPENA *pstVopenaParams);
VSTATUS VDEV_SendVoipVopena(IN SChnl * pstChnl, IN struct _VOIP_VOPENA *pstVopenaParams);
/** Sends VOIP_VOPDIS*/
VSTATUS VDEV_VopDisable(IN SChnl * pstChnl);

/** Sends VOIP_ECHO_CANCEL*/
VSTATUS VDEV_SetVoipEchoCancel(gtl_msg_t *pstMsg, IN struct _VOIP_ECHOCAN *pstECanParams);
VSTATUS VDEV_SendVoipEchoCancel(IN SChnl * pstChnl, IN struct _VOIP_ECHOCAN *pstECanParams);

/** Sends VOIP_DFECAN*/
VSTATUS VDEV_SetVoipDfeCancel(gtl_msg_t *pstMsg, IN struct _VOIP_DFECAN *pstDCanParams);
VSTATUS VDEV_SendVoipDfeCancel(IN SChnl * pstChnl, IN struct _VOIP_DFECAN *pstDCanParams);

/** Sends VOIP_JBOPT*/
VSTATUS VDEV_SetVoipJbopt(gtl_msg_t *pstMsg, IN struct _VOIP_JBOPT *pstJbopt);
VSTATUS VDEV_SendVoipJbopt(IN SChnl * pstChnl, IN struct _VOIP_JBOPT *pstJbopt);

/** Sends VOIP_DGAIN*/
VSTATUS VDEV_SetVoipDgain(gtl_msg_t *pstMsg, IN struct _VOIP_DGAIN *pstDgainParams);
VSTATUS VDEV_SendVoipDgain(IN SChnl * pstChnl, IN struct _VOIP_DGAIN *pstDgainParams);

/** Sends VOIP_DTMF_OPT*/
VSTATUS VDEV_SetVoipDtmfOpt(gtl_msg_t *pstMsg, IN struct _VOIP_DTMFOPT *pstDtmpOpt);
VSTATUS VDEV_SendVoipDtmfOpt(IN SChnl * pstChnl, IN struct _VOIP_DTMFOPT *pstDtmpOpt);

/** Sends FAXLVL command to MSP */
VSTATUS VDEV_SetFaxLevel(gtl_msg_t *pstMsg, IN struct _FAXLVL *pstFaxTxLvl);
VSTATUS VDEV_SendFaxLevel(IN SChnl *pstChnl, IN struct _FAXLVL *pstFaxTxLvl);

/** Sends FAXOPT command to MSP */
VSTATUS VDEV_SetFaxOpt(gtl_msg_t *pstMsg, IN struct _FAXOPT *pstFaxOpts);
VSTATUS VDEV_SendFaxOpt(IN SChnl *pstChnl, IN struct _FAXOPT *pstFaxOpts);

/** Sends TONECTRL cmd to MSP*/
VSTATUS VDEV_SetToneCtrlOpt(gtl_msg_t *pstMsg, IN struct _VOIP_TONECTRL *pstToneCtrl);
VSTATUS VDEV_SendToneCtrlOpt(IN SChnl *pstChnl, IN struct _VOIP_TONECTRL *pstToneCtrl);

/** Sends TONERELAY cmd to MSP*/
VSTATUS VDEV_SetToneRelayOpt(gtl_msg_t *pstMsg, IN struct _VOIP_TONES_RELAY_OPTION *pstToneRelay);
VSTATUS VDEV_SendToneRelayOpt(IN SChnl *pstChnl, IN struct _VOIP_TONES_RELAY_OPTION *pstToneRelay);

/** Sends MAAS_ASSIGN*/
VSTATUS VDEV_MaasAssign(IN SChnl * pstChnl);

/** Sends QUERY_READY */
VSTATUS VDEV_QueryReady(IN SChnl * pstChnl);

/** Sends BRM_SET_CLOCK*/
VSTATUS VDEV_BRMSetClock(IN SChnl * pstChnl);

/** Sends BRM_SETPLL */
VSTATUS VDEV_BRMSetPll(SChnl * pstChnl, SHwCfg* pstHwCfg, IN U8 ucBusNumber);
	
/** Sends BRM_SET_ARM_CLOCKMODE*/
VSTATUS VDEV_BRMArmSetClkMode(IN SChnl * pstChnl);

/** Set Chip select Param*/
VSTATUS VDEV_BRMSetCSParam(IN SChnl * pstChnl, IN SHwCfg * pstHwCfg);

/** Set SDRAM Params*/
VSTATUS VDEV_BRMSetSdramParam(IN SChnl * pstChnl, IN SHwCfg * pstHwCfg);

/** Set SDRAM Params*/
VSTATUS VDEV_BRMSetSdramParam2(IN SChnl *pstChnl, IN SHwCfg *pstHwCfg);

/** Sends FIFO_WRITE*/
VSTATUS VDEV_CsmDownload(IN SChnl * pstChnl, IN void *pvBuffer, IN U16 usSize, IN U32 uiLoadAddr);

/** Sends FIFOREAD*/
VSTATUS VDEV_BRMFifoRead(IN SChnl * pstChnl, IN U32 ulReadAddr, IN U16 usSize);
VSTATUS VDEV_BRMDwordRead(IN SChnl * pstChnl, IN U32 uAddr);
VSTATUS VDEV_DwordWrite(IN SChnl * pstChnl, IN U32 uAddr, IN U32 uData);
VSTATUS VDEV_BRMDwordWriteAddr(IN SChnl * pstChnl, IN U32 uAddr);
VSTATUS VDEV_BRMDwordWriteData(IN SChnl * pstChnl, IN U32 uData);

/** Sends PROGSTART*/
VSTATUS VDEV_RunMsp(IN SChnl * pstChnl, IN U32 uiStartAddr);

/** Sends VOIP_LOOPBACK*/
VSTATUS VDEV_VoIPLoopback(IN SChnl * pstChnl, IN U16 usDestChnlId, IN ELoopbackType eLoobackType);

/** Sends THC_MOE_ENABLE*/
VSTATUS VDEV_ThcModeEnable(IN SChnl * pstChnl);

/** Sends THC_REDIRECT_RX*/
VSTATUS VDEV_ThcRedirectRx(IN SChnl * pstChnl, IN U16 usTDMTimeSlot);


/** Sends CND_SET_PARAMS  */
VSTATUS VDEV_CNDSetup(IN SChnl * pstChnl, IN SCallerIdParams * pstParam);
VSTATUS VDEV_SetCidParams(IN SChnl * pstChnl);
/** Sends FC_VOIP_CNDONGEN  */
VSTATUS VDEV_CNDOnGen(IN SChnl * pstChnl, IN SCallerIdParams * pstParam);
/** Sends FC_VOIP_CNDOFFGEN  */
VSTATUS VDEV_CNDOffGen(IN SChnl * pstChnl, IN SCallerIdParams * pstParam);
/** Sends FC_VOIP_CNDOFFGEN  or FC_VOIP_CNDONGEN with CID string*/
VSTATUS VDEV_CidGen(IN SChnl * pstChnl, IN SVcoreCidInfo * pstParam);
/** Sends FC_VOIP_CNDSTOP */
VSTATUS VDEV_CNDStop(IN SChnl * pstChnl);
/** Sends FC_VOIP_TONEGEN */
VSTATUS VDEV_StartTonGen(IN SChnl * pstChnl, IN SToneGenParams * pstParam);
/** Sends FC_VOIP_TONEGEN */
VSTATUS VDEV_PlayDualTone(IN SChnl * pstChnl, IN SPlayToneFlags *pstToneFlags);
/** Sends FC_VOIP_QUADTONEGEN */
VSTATUS VDEV_PlayQuadTone(IN SChnl * pstChnl, IN SPlayToneFlags *pstToneFlags);
/** Sends FC_VOIP_TONEOFF */
VSTATUS VDEV_ToneOff(IN SChnl * pstChnl, SStopToneData *pstToneOffData);
/** Sends FC_SUPV_TDM_SELECT_BUS_MODE */
VSTATUS VDEV_SelectTdm(IN SChnl * pstChnl, IN STdmSetupParams * pstParam);
/** Sends FC_SUPV_SETUP_TDM_PARAM */
VSTATUS VDEV_SetupTdmParam(IN SChnl * pstChnl, IN STdmBusParams * pstParam);
/** Sends FC_CONF_CREATE_CONFERENCE */
VSTATUS VDEV_CreateConf(IN SChnl * pstChnl, IN SConfParams * pstConf);
/** Sends FC_CONF_CREATE_PARTICIPANT */
VSTATUS VDEV_CreatePart(IN SChnl * pstChnl, IN SChnl *pstChannelInfo);
/** Sends FC_CONF_SPECIFY_DOMINANT_TALKERS */
VSTATUS VDEV_ConfSetDTS(IN SChnl * pstChnl, IN U16 usConfNo, IN SConfDTSParams * pstParam);
/** Sends FC_VOIP_AGCSET */
VSTATUS VDEV_PartAGCSET(IN SChnl * pstChnl, IN struct _VOIP_AGCSET * pstParam);
/** Sends FC_CONF_DESTROY_PARTICIPANT */
VSTATUS VDEV_DestroyPart(IN SChnl * pstChnl, IN CHNLID ChnlId, U16 usConfId);
/** Sends FC_CONF_DESTROY_CONFERENCE */
VSTATUS VDEV_DestroyConf(IN SChnl * pstChnl, IN U16 usConfId);

VSTATUS VDEV_MuteParticipant(IN SChnl * pstChnl, IN U16 usMute, IN U16 usMSPConfId, IN U16 usMSPPartId);
/** Sends FC_CONF_SET_PARTICIPANT_DGAIN */
VSTATUS VDEV_SetPartDgain(IN SChnl* pstChnl, IN U16 usGain, IN U16 usMSPConfId,  IN U16 usMSPPartId);
/** Sends CONF_SET_PARTICIPANT_OPT */
VSTATUS VDEV_SetPartOpt(IN SChnl* pstChnl, IN U16 usRfc2833OnOff, IN U16 usMSPConfId,  IN U16 usMSPPartId);

VSTATUS VDEV_IpServiceConfig(IN SChnl * pstChnl, IN U8 ucChksumVer, IN U8 ucEncaps);

VSTATUS VDEV_SetEthMacAddr(gtl_msg_t *pstMsg, IN U16 usMSPChnlId, IN U8 * pastSrcEthMac, IN U8 * pastDestEthMac, IN U16 usVlanId);

VSTATUS VDEV_SendEthMacAddr(IN SChnl * pstChnl, IN U8 * pastSrcEthMac, IN U8 * pastDestEthMac, IN U16 usVlanId);

VSTATUS VDEV_GetEthMacAddr(IN SChnl * pstChnl);

VSTATUS VDEV_GetDevIP(IN SChnl * pstChnl);

VSTATUS VDEV_GetCsmeMulti(IN SChnl * pstChnl);

VSTATUS VDEV_GetSpuFeature(IN SChnl * pstChnl);

VSTATUS VDEV_SetIpHdrChnl(gtl_msg_t *pstMsg, IN struct _SET_IP_HDR_CHANNEL *pstIpUdpInfo, IN SChnl * pstChnl);

VSTATUS VDEV_SendIpHdrChnl(IN SChnl * pstChnl, IN struct _SET_IP_HDR_CHANNEL *pstIpUdpInfo);

VSTATUS VDEV_SetIpAddr(IN SChnl * pstChnl, IN U32 uiIpAddr);

VSTATUS VDEV_SetIpAddrList(IN SChnl * pstChnl, IN U32 * pauiIpAddr, IN U8 ucNumOfIpAddr);

VSTATUS VDEV_HoldParticipant(IN SChnl * pstChnl,
			      IN EHoldState eHoldState, IN U16 usSrcPartId, IN U16 usMSPConfId, IN U16 usMSPPartId);

VSTATUS VDEV_PLTypeSet(IN SChnl * pstChnl, IN U16 usPTIndex, IN U8 ucPtVal, IN U8 ucTempDir);

VSTATUS VDEV_SendNteCmd(IN SChnl * pstChnl,
			 IN U32 uiNtePyLd,
			 IN U32 uiSsrc, IN U16 usOverRideBitField, IN U16 usPyLdType, IN U16 usRedundancyInterval);
VSTATUS VDEV_EnableARP(IN SChnl * pstChnl);

/*Globals*/
VSTATUS VDEV_EnableICMP(IN SChnl * pstChnl);

VSTATUS VDEV_TdmEnableBus(IN SChnl * pstChnl, IN U8 usNoOfBus);

VSTATUS VDEV_SetFlowControl(IN SChnl * pstChnl);

VSTATUS VDEV_SetMediaHost(IN SChnl * pstChnl, IN U8 ucMediaHost);

VSTATUS VDEV_SetChnlMode(IN SChnl * pstChnl, IN ERecPlayState eRecPlayState, IN SHostSpeechData * pstUserData);

VSTATUS VDEV_SetDrainPlayRecBuffer(IN SChnl * pstChnl);

VSTATUS VDEV_SetAs_Stop(IN SChnl * pstChnl);

VSTATUS VDEV_PlaybackSetRate(IN SChnl * pstChnl, IN EPlaybackRate ePlaybackRate);

VSTATUS VDEV_SendData(IN SChnl * pstChnl, IN SFrameInfo * pstFrame, IN U16 usFuncCode);

VSTATUS VDEV_SendDataExtended(IN SChnl * pstChnl, IN SFrameInfo * pstFrame);

VSTATUS VDEV_SendDataInd(IN SChnl * pstChnl, IN U16 usFuncCode);

VSTATUS VDEV_SendH254(IN SChnl * pstChnl, IN SH245Packet *pstH245Packet);

VSTATUS VDEV_SPUFeatureControl(IN SChnl * pstChnl);

VSTATUS VDEV_CIDDetectionSetup(IN SChnl * pstChnl, IN SCIDDetectionParams * pstCIDDetectionParams);

VSTATUS VDEV_SetCidDetParams(IN SChnl * pstChnl);

VSTATUS VDEV_TransConnect(IN SChnl *pstChnl, IN STransConnectParams * pstTransConnectParams);

VSTATUS VDEV_CNDDETCtrlSend(IN SChnl * pstChnl, IN U8 ucOnOffhk);

VSTATUS VDEV_SetCidCtrl(IN SChnl * pstChnl, struct _CNDDETCTL *cid_det_ctrl);

VSTATUS VDEV_CESoPSN_Mapper(IN SChnl *pstSupvsrChnl, 
			SFsmCesoPsnMapChannelInfo *pstSFsmCesoPsnMapChannelInfo);

VSTATUS VDEV_SetConfLatency(IN SChnl* pstChnl, IN U16 usLatency);

VSTATUS VDEV_SetConfDgain(IN SChnl* pstChnl, IN U16 usGain);

VSTATUS VDEV_RunCheckSum(IN SChnl * pstChnl, IN U32 uiLoadAddr);

VSTATUS VDEV_EnableMultiCmds(IN SChnl * pstChnl, U8 bEnable);

VSTATUS VDEV_WordWrite(IN SChnl * pstChnl, IN U32 uAddr, IN U16 uData);

VSTATUS VDEV_WordRead(IN SChnl * pstChnl, IN U32 uAddr);
/** Used to assign PHYID over POS */
VSTATUS VDEV_POSPhyIdAssign(SChnl * pstChnl);
/** Sets the clock multiplier value for PLL during POS boot */
VSTATUS VDEV_POSSetPLL(SChnl * pstChnl);
/** Programs the SDRAM during POS boot */
VSTATUS VDEV_POSSetSDRAM(SChnl * pstChnl, IN SHwCfg * pstHwCfg);
/** Run checksum routine after POS download of MSP image */
VSTATUS VDEV_POSChksum(IN SChnl * pstChnl, IN U32 uiAddress);
/** Start MSP */
VSTATUS VDEV_POSProgStart(IN SChnl * pstChnl, IN U32 uiStartAddr);
/** Used to download the MSP file over POS */
VSTATUS VDEV_POSDownload(IN SChnl * pstChnl, IN void *pvBuffer, IN U16 usSize, IN U32 uiLoadAddr);
/** Used to read coredump from MSP over POS */
VSTATUS VDEV_POSMemRead(IN SChnl * pstChnl, IN U32 ulReadAddr, IN U16 usSize);

VSTATUS VDEV_ForceAlert(IN SChnl *pstChnl);
/**Get Major Release number */
VSTATUS VDEV_GetMR(IN SChnl *pstChnl);
/**Get device model number */
VSTATUS VDEV_GetDevModel(IN SChnl * pstChnl);
/**Set query command */
VSTATUS VDEV_SetQueryCommand(IN gtl_msg_t *pstMsg, IN U16 *pvComm, IN U16 usNumComm);
/**Modify queried command */
VSTATUS VCORE_ModifyQueriedCommand(IN gtl_msg_t * pstMsg, IN SModifyConnectionInfo *pstModConnInfo, IN U16 usModifyNum);
VSTATUS VDEV_C2CConnectUP(IN SChnl *pstChnl, IN struct _C2C_CONNECT_UMA_UP *pstC2CConnectParams);

VSTATUS VDEV_ChannelsReset(IN SChnl * pstChnl);

 /*VCORE Interface Functions*/

/*VCORE Interface Functions*/

/** Initialize VCORE*/
VSTATUS VCORE_Init(void);

/** Start VAPI request processing*/
VSTATUS VCORE_ProcessRequest(IN SChnl * pstChnl, IN SVapiReq * pstReq);

VSTATUS VCORE_ProcessRequestList(IN SChnl * pstChnl);

/** Free VCORE resources*/
void VCORE_Close(void);

/** Register event callback, should be called when events are received by MSP*/
VSTATUS VCORE_RegisterEventCallback(IN U32 uiID, IN U8 ucLevel, IN PFNEventCallback pfnEventcallback);

/** The callback registered with GTL*/
void VCORE_GTLReadCallback(IN S32 deviceid, IN gtl_msg_t * msg);

/*VCORE Private Functions*/

/*VCORE GENERIC FUNCTIONS*/
/** Sends a MSP request to GTL*/
VSTATUS VCORE_SendMSPReq(IN SChnl * pstChnl, IN gtl_msg_t * pstMsg);

/** Sends Indication to MSP */
VSTATUS VCORE_SendIndToMsp(IN SChnl * pstChnl, IN gtl_msg_t * pstMsg);

/** Handles response timeout*/
void VCORE_RespTimeoutHdlr(IN void *pvData);

/** Identifies whether the given message is the special timeout message*/
Boolean VCORE_IsTimeoutMessage(IN gtl_msg_t * pstMsg);

/** Gets the next command in a multiple commands message*/
int VCORE_GetNextCmd(SMsg * pstMsg);

/** Check a command length integrity*/
VSTATUS VCORE_CheckCmd(SDevice *pstDevice, SMsg * pstMsg);

/** Checks the received Comcerto message for correctness*/
VSTATUS VCORE_CheckStatus(U16 Event, IN gtl_msg_t * pstMsg,
			  IN U16 usExpChnlId, IN U8 ucExpCmdCls, IN U8 ucExpCmdTyp, IN U16 usExpFCode);

VSTATUS VCORE_CheckReadyReceived(U16 Event, IN gtl_msg_t * pstMsg);

/** Checks the received internal Multi command Comcerto message for correctness*/
VSTATUS VCORE_CheckStatusMulti(SChnl * pstChnl, gtl_msg_t * pstReqMsg, U16 Event, gtl_msg_t * pstMsg);
/** Checks the received Passthru Multi command Comcerto message for correctness*/
VSTATUS VCORE_CheckPassThruStatus(SChnl * pstChnl, gtl_msg_t * pstReqMsg, U16 Event, gtl_msg_t * pstMsg);

/** Does the cleanup of the completed request and launches pending request*/
void VCORE_DoReqCompletion(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, VSTATUS Status);

VSTATUS VCORE_HandleFrame(IN gtl_msg_t * pstMsg, IN OUT SFrameInfo * pstFrameInfo);

void VCORE_RecPlayTerminator(IN void *pvData);

void VCORE_ChannelResetTimeoutHdlr(IN void *pvData);

Boolean VCORE_IsRecPlayTerminatorMsg(gtl_msg_t * pstMsg);
/**Used to start request processing for T38 switch*/
void VCORE_SendProcessFaxEvent(SChnl * pstChnl, U16 usSwEvent);

/** Pointer for storing events callback(registered by application)*/
extern PFNEventCallback pfnEventCallback_g;

void VCORE_ProcessAifHeader(struct _AIF_HEADER *pstAifHd);

VSTATUS VCORE_ConnectionGenericCheck(IN CONNID ConnId, char *FName, SChnl **ppstChnl);

VSTATUS VCORE_DeviceGenericCheck(IN DEVID DevId, char *FName, SDevice **ppstDevice);

VSTATUS VCORE_ConferenceGenericCheck(IN CONFID ConfId, char *FName, SConference **ppstConf);

void VCORE_SetRequest(SVapiReq * pstVapiReq,
			       SRequest * pstRequest, void *vcore_function, U32 id);

void VCORE_SetConnectionRequest(SVapiReq * pstVapiReq,
				SRequest * pstRequest, void *vcore_function, U32 id);

void VCORE_SetDeviceRequest(SVapiReq * pstVapiReq,
			   	SRequest * pstRequest, void *vcore_function, U32 id);

void VCORE_SetConferenceRequest(SVapiReq * pstVapiReq, 
				SRequest * pstRequest, void *vcore_function, U32 id);

SVapiReq *VCORE_AllocateRequest(size_t szUserDataSize);

void VCORE_FreeRequest(SVapiReq *pstVapiReq);

void VCORE_CleanParticipant(IN SChnl *pstChnl);

void VCORE_ProcessFSMhandler(IN SChnl *pstChnl, U16 Event, IN gtl_msg_t *pstMsg);

void VCORE_ProcessResponse(SDevice *pstDevice, IN gtl_msg_t *pstMsg);

void VCORE_SetChildRequest(IN SVapiReq *pstChildVapiReq, IN SVapiReq *pstVapiReq,
			PFNReqFsmHdlr pfnChildReqFSMHdlr, U16 usReqStartState);

VSTATUS  VCORE_StartChannelChildRequest(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq);

void VCORE_CheckPassThruParams(IN SChnl *pstChnl, gtl_msg_t *pstReqMsg);

/** Extract Voip chnl Params from the Message Fifo*/
void VCORE_ExtractVoIPParams(IN SChnl * pstChnl, OUT SVoIPChnlParams * pstVoIPParams, IN U16 * pausFifo);

/** Add a connection structure to the AVL tree*/
VSTATUS VCORE_AddConnection(IN SChnl *pstChnl);

/** Check a connection structure weather it's in AVL tree*/
VSTATUS VCORE_CheckConnection(IN SChnl *pstChnl);

/** Remove a connection structure from the AVL tree*/
void VCORE_RemoveConnection(IN SChnl *pstChnl);

/** Initializes a new connection structure*/
VSTATUS VCORE_OpenConnection(IN SChnl *pstChnl);

/** Does the cleanup of the connection*/
void VCORE_CloseConnection(IN SChnl * pstChnl);

/** Does the purge of the device*/
int VCORE_PurgeDevResources(SDevice * pstDevice);

/** Add a conference structure to the AVL tree*/
VSTATUS VCORE_AddConference(IN SConference *pstConf);
/** Remove a conference structure from the AVL tree*/
void VCORE_RemoveConference(IN SConference *pstConf);

U8 VCORE_SetEchoCan(IN SChnl * pstChnl);

VSTATUS VCORE_ProcessLockRequest(IN SChnl * pstChnl, IN SVapiReq * pstReq);

/** Update the MR number for the device */
VSTATUS VCORE_UpdateMR(struct _SDevice *pstDev, void *pvFifo);

VSTATUS VCORE_UpdateEth(struct _SDevice *pstDev, void *pvFifo);

VSTATUS VCORE_UpdateIP(struct _SDevice *pstDev, void *pvFifo);

VSTATUS VCORE_UpdateCsmeMulti(struct _SDevice *pstDev, void *pvFifo);

VSTATUS VCORE_UpdateSpuFeature(struct _SDevice *pstDev, void *pvFifo);

VSTATUS VCORE_SetupBootCmdMsg(OUT gtl_msg_t * pstMsg, IN U8 ucCmdType, EDevItfType eItfType);
void VCORE_SetupCmdHdrMsg(OUT gtl_msg_t * pstMsg, IN U8 ucCmdClass, IN U8 ucCmdType, IN U16 usFcode);
void VCORE_InitMsg(gtl_msg_t *pstMsg, U8 *pusFifo, U16 usMaxLen);
VSTATUS VCORE_CheckMessage(SDevice *pstDevice, IN SMsg * pstMsg, IN U8 ucLevel);
/** Checks the received BRM ack for correctness*/
VSTATUS VCORE_CheckPCIBootStatus(U16 Event, IN gtl_msg_t * pstMsg);

/** reset the device and GTL */
VSTATUS VCORE_ResetDevice(IN SDevice *pstDev);

/** copy user fax option to internal fax options structure*/
VSTATUS VCORE_SetUserFaxOption(SFaxConfigOpts *pstUserFaxOption, IN SFsmFaxOptions *pstFsmFaxOptions);

/** ccheck cmd class/type validity for VAPI_Passthru */
VSTATUS VCORE_CheckCtCcValidity(U16 usFcode, U8 ucCmdClass, U8 ucCmdType);

/*VCORE REQ FSM HANDLER FUNCTIONS*/
/** Remove all pending pariciapant of a conference*/
VSTATUS VFSM_PurgeConference(IN SChnl * pstSupvChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);

/** SUPERVISOR only Child request to stop and destroy a channel or participant*/
VSTATUS VFSM_KillConnection(IN SChnl * pstSupvChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);

VSTATUS VFSM_GetCoreDump(IN SChnl * pstSupvChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);

VSTATUS VFSM_SetDeviceHardware(IN SChnl * pstSupvChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);

VSTATUS VFSM_SetDeviceHardware900(IN SChnl * pstSupvChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);

VSTATUS VFSM_SetDeviceHardware300(IN SChnl * pstSupvChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);

VSTATUS VFSM_SetSdram_300_1(IN SChnl * pstSupvChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);

VSTATUS VFSM_SetSdram_300_2(IN SChnl * pstSupvChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);

VSTATUS VFSM_StopConnection(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);
/** Req-FSM Handler for VAPI_EnableConnection*/
VSTATUS VFSM_StartConnectionPacket(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);
/** Req-FSM Handler for VAPI_DisableConnection*/
VSTATUS VFSM_StartConnectionTDM(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);

VSTATUS VFSM_DestroyChannel(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);

VSTATUS VFSM_CreateChannel(IN SChnl * pstSupvChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);

VSTATUS VFSM_StartPacket(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);

VSTATUS VFSM_ChangeChannelType(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);

VSTATUS VFSM_InitChannelTransport(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);

VSTATUS VFSM_SetNetworkParams(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);

VSTATUS VFSM_InitChannel(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);
/** Loopback voice data single channel*/
VSTATUS VFSM_LoopbackSingle(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);
/** Loopback voice data inter channel*/
VSTATUS VFSM_LoopbackInter(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);
/** Loopback voice TDM Hairpin*/
VSTATUS VFSM_LoopbackTHC(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);
/** Loopback voice TDM Hairpin child FSM */
VSTATUS VFSM_InterChannelLoopback(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);

VSTATUS VFSM_CreateParticipant(IN SChnl * pstSupvChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);

VSTATUS VFSM_AllocateParticipant(IN SChnl * pstSupvChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);

VSTATUS VFSM_DestroyParticipant(IN SChnl * pstSupvChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);

VSTATUS VFSM_StartRecord(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);

VSTATUS VFSM_StartPlayback(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);

VSTATUS VFSM_PlaybackSetRate(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);

VSTATUS VFSM_ConvertHostSpeechData(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);

VSTATUS VFSM_EnableCIDDetection(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);

VSTATUS VFSM_SetCIDDetection(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);

/** Req-FSM Handler for VAPI_CreateConnection*/
VSTATUS VFSM_CreateConnection(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);
/** Req-FSM Handler for VAPI_AllocateConnection*/
VSTATUS VFSM_AllocateConnection(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);
/** Req-FSM Handler for VAPI_PassThru*/
VSTATUS VFSM_PassThru(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);
/** Req-FSM Handler for VAPI_DestroyConnection*/
VSTATUS VFSM_DestroyConnection(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);
/** Req-FSM Handler for VAPI_ChangeConnectionType*/
VSTATUS VFSM_DestroyOldConnection(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);
/** Req-FSM Handler for VAPI_BootDevice*/
VSTATUS VFSM_BootDevice(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);
/** Req-FSM Handler for VAPI_DeviceInit*/
VSTATUS VFSM_InitDevice(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);
/** Req-FSM Handler for VAPI_DeviceInit*/
VSTATUS VFSM_InitRecover(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);
/** Req-FSM Handler for VAPI_AssignBootMAC */
VSTATUS VFSM_AssignBootMAC(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);
/** Req-FSM Handler 1 for VAPI_GetCoreDump*/
VSTATUS VFSM_SetDeviceForDump(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);
/** Req-FSM Handler 2 for VAPI_GetCoreDump*/
VSTATUS VCORE_ReadDeviceMemory(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);
/** Req-FSM Handler for VAPI_StartCallerId */
VSTATUS VFSM_StartCallerId(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);
VSTATUS VFSM_PlayCid(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);
/** Req-FSM Handler for VAPI_StopCallerId */
VSTATUS VFSM_StopCallerId(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);
/** Req-FSM Handler for VAPI_StartTone */
VSTATUS VFSM_StartTone(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);
/** Req-FSM Handler for VAPI_PlayTone */
VSTATUS VFSM_PlayTone(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);
/** Req-FSM Handler for VAPI_StopTone */
VSTATUS VFSM_StopTone(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);
/** Req-FSM Handler for VAPI_SetTDMParams */
VSTATUS VFSM_SetTDMParams(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);
/** Req-FSM Handler for VAPI_CreateConference */
VSTATUS VFSM_CreateConference(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);
/** Req-FSM Handler for VAPI_CreateDeviceParticipant */
VSTATUS VFSM_CreateDeviceParticipant(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);
/** Req-FSM Handler for VAPI_DestroyConference */
VSTATUS VFSM_DestroyConference(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);

VSTATUS VFSM_SetDeviceIPAddr(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);

VSTATUS VFSM_SetSrcDestConIpUdp(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);

VSTATUS VFSM_SetCodecType(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);

VSTATUS VFSM_SetPacketInterval(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);

VSTATUS VFSM_SetPayloadType(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);

VSTATUS VFSM_EchoCancellerReset(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);

VSTATUS VFSM_SetRtpSsrcHeader(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);

VSTATUS VFSM_PutParticipantOnHold(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);

VSTATUS VFSM_MutePartId(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);

VSTATUS VFSM_SetPartDgain(IN SChnl *pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t *pstMsg);

VSTATUS VFSM_SetPartOpt(IN SChnl *pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t *pstMsg);

VSTATUS VFSM_SetConnectionIPParams(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);

VSTATUS VFSM_SetDevEthMac(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);

VSTATUS VFSM_SetConnEthMac(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);

VSTATUS VFSM_SendNte(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);

VSTATUS VFSM_SwitchToT38(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);

VSTATUS VFSM_SetT38Options(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);

VSTATUS VFSM_TranscodingSession(IN SChnl *pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t *pstMsg);

VSTATUS VFSM_SetTransConnect(IN SChnl * pstSupvChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);

VSTATUS VFSM_LockConnection(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);

VSTATUS VFSM_EnableTHC(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);

VSTATUS VFSM_ModConn(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);

VSTATUS VFSM_RecoverConnection(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);

VSTATUS VFSM_RecoverChannel(IN SChnl * pstSupvChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);

VSTATUS VFSM_CESoPSN_Mapper(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);

VSTATUS VFSM_SetConfLatency(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);

VSTATUS VFSM_SetConfDgain(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);

VSTATUS VFSM_SendH245Msg(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);

VSTATUS VFSM_ChangeConnection(IN SChnl * pstChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);

VSTATUS VFSM_C2CConnectUP(IN SChnl * pstSupvChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);

VSTATUS VFSM_PurgeMspResources(IN SChnl * pstSupvChnl, IN SVapiReq * pstVapiReq, IN U16 Event, IN gtl_msg_t * pstMsg);

VSTATUS VRES_CheckRes(IN SChnl * pstChnl, IN SResRequest *pstResRequest, SConnResources *pstConRes);

VSTATUS VRES_IsResourceValid (U8 ucResourceNum, U8 *pucRequiredResource);

void VRES_GetDeviceRes(int usResourceCount, U16 usNumOfRes, U16 *pusReferenceRes, U16 *pusUserData);

void VRES_InitDeviceRes(int usResourceCount, U16 usNumOfRes, U16 *pusReferenceRes, U16 *pusCurrentResources);

U16 VRES_GetMaxRes(IN SDevice *pstDevice, IN U8 ucNumOfRes, IN U8 *pucRequiredRes);

#endif

