/*! \file vapi_profile.h */

/* Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */


#ifndef _VAPI_PROFILE_H
#define _VAPI_PROFILE_H

#define VAPI_DEV_OPMODE_DEFAULT			0 	/**<  send SPU CTRL + MULTICMD */
#define VAPI_DEV_OPMODE_RECOVER			0xff 	/**<  set Dev in ready state (Device UP, initialized, enable MULTICMD) 
							and retrieve next variables by inquiring device: F/W MR, Eth MAC, Dev IP */

#define VAPI_DEV_PROF_DEFAULT			0	/**<  used by DeviceInit enable FSK */
#define VAPI_DEV_PROF_SPU_FIRMWARE_DEFAULT	1	/**<  used by DeviceInit does not enable any SPU features */
#define VAPI_DEV_PROF_SPU_DFECAN_ENABLE		2	/**<  used by DeviceInit enable FSK + DFECAN */
#define VAPI_DEV_PROF_SPU_FSK_IP_DETECTION 	3	/**<  used by DeviceInit enable FSK + IP detect */
#define VAPI_DEV_PROF_SPU_CUSTOM		4	/**<  used by DeviceInit enable according custom setting of pulUserParams*/

#define VAPI_T38_OPMODE_NONE			0 	/**<  No command is sent to the FoIP channel after switch */
#define VAPI_T38_OPMODE_TYPICAL			1 	/**<  FaxOPT and FaxLVL commands are sent to the FoIP channel */
#define VAPI_T38_OPMODE_NETWORK			2 	/**<  TYPICAL + IP Parameters heritated from VoIP */
#define VAPI_T38_OPMODE_ENABLE			3 	/**<  NETWORK + Enable the channel for UDPTL or RTP transmission */

#endif

