/*! \file vapi_device_config.h 
 * Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

#ifndef _DEVICE_CONFIG_H_
#define _DEVICE_CONFIG_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "vapi_config.h"

/** Device memories 
 * #.0 A check for ucMemCnt <= DEV_MAX_MEM_CNT can be added in GTL_Init
 */
#define DEV_MAX_MEMORY_INDEX 3

/** Structure containing information about device's 
various memories (internal & external)*/
typedef struct {
	U32 aulMemBase[DEV_MAX_MEMORY_INDEX + 1];	/*Memory base information for DEV_MAX_MEMORY_INDEX memories */
	U32 aulMemSize[DEV_MAX_MEMORY_INDEX + 1];	/*Memory size information for DEV_MAX_MEMORY_INDEX memories */
} SDevMemInfo;

typedef struct _SCodecInfo {
	Boolean bIsSupported;
	U16 usPTIndex;
	U8 ucNumRange;
} SCodecInfo;

/*VAPI Defaults*/
typedef struct _SVAPIDeviceConfig {
	SCodecInfo astCodecInfo[NUM_CODECS];
	SCodecInfo astVideoCodecInfo[NUM_VIDEO_CODECS];
	SDevMemInfo stMemInfo;
	SHwCfg stSHwCfg;
} SVAPIDeviceConfig;

#ifdef __cplusplus
};
#endif

#endif		/* _DEVICE_CONFIG_H_ */
