/*! \file vapi_device_config.c 
 * Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

#include "ut.h"
#include "vapi.h"
#include "vapi_device_config.h"
#include "gtl.h"
#include "msp.h"
#include "hwcfg.h"

void DMGR_SetVAPIDeviceConfig(SVAPIDeviceConfig * pastDeviceConfig)
{
	SCodecInfo *pstCodecInfo;
	SCodecInfo *pstVideoCodecInfo;
	SHwCfg *pstSHwCfg;
	
	static U32 uiSdramParam_C300_2[] = {
			0x10080080, 0x00130010,
			0x10080080, 0x00930010,
			0x10080078, 0x08000000,
			0x10080078, 0x8F000000,
			0x10080078, 0x8F000000,
			0x10080078, 0x8A000400,
			0x10080078, 0x88020000,
			0x10080078, 0x88030000,
			0x10080078, 0x88010000,
			0x10080078, 0x88000332,
			0x10080078, 0x8A000400,
			0x10080078, 0x89000000,
			0x10080078, 0x89000000,
			0x10080078, 0x88000232,
			0x10080078, 0x88010380,
			0x10080078, 0x88010404,
			0x10080018, 0x00000200,
			0x10080010, 0x0B262333,
			0x10080014, 0x01102223,
			0x1008007C, 0x00001961,
			0x10080084, 0x00000000,
			0x10080088, 0x00000000,
			0x1008008C, 0x00000000,	/* for -11 revision value is 0, for -12 revision value is 0xA7 (see VFSM_SetSdram_300_2) */
			0x10080080, 0x00930010,
			};

	UT_MemSet(pastDeviceConfig, 0, sizeof(SVAPIDeviceConfig) * NUM_DEV_TYPES);

	/*Fill Codec Info For DEV_TYPE_M825XX */
	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M825XX].astCodecInfo[eGeneric_Comfort_Noise]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eGeneric_Comfort_Noise;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M825XX].astCodecInfo[eRedundant_Scheme_for_DTMF]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eRedundant_Scheme_for_DTMF;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M825XX].astCodecInfo[eDTMF_RTP]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eDTMF_RTP;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M825XX].astCodecInfo[eIFP]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eIFP;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M825XX].astCodecInfo[eG711_ULAW_PCM]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG711_ULAW_PCM;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M825XX].astCodecInfo[eG711_ALAW_PCM]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG711_ALAW_PCM;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M825XX].astCodecInfo[eG723_1]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG723_1;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M825XX].astCodecInfo[eG728_Audio]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eG728_Audio;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M825XX].astCodecInfo[eG729_A]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG729_A;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M825XX].astCodecInfo[eG726_32]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG726_32;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M825XX].astCodecInfo[eGSM_FR_Audio]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eGSM_FR_Audio;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M825XX].astCodecInfo[eClear_Channel]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eClear_Channel;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M825XX].astCodecInfo[ePassthrough_ULAW]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = ePassthrough_ULAW;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M825XX].astCodecInfo[ePassthrough_ALAW]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = ePassthrough_ALAW;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M825XX].astCodecInfo[eG726_16_audio]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG726_16_audio;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M825XX].astCodecInfo[eG726_24_audio]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG726_24_audio;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M825XX].astCodecInfo[eG726_40_audio]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG726_40_audio;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M825XX].astCodecInfo[eGSM_EFR]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eGSM_EFR;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M825XX].astCodecInfo[eAMR]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eAMR;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M825XX].astCodecInfo[eEVRC]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eEVRC;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M825XX].astCodecInfo[eCNF_SEC]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCNF_SEC;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M825XX].astCodecInfo[eSMV]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eSMV;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M825XX].astCodecInfo[eQCELP_13K]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eQCELP_13K;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M825XX].astCodecInfo[eQCELP_8K]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eQCELP_8K;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M825XX].astCodecInfo[eCRBT_ADPCM]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCRBT_ADPCM;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M825XX].astCodecInfo[eG729_EG]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG729_EG;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M825XX].astCodecInfo[eFEC]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eFEC;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M825XX].astCodecInfo[eI_LBC_15K]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eI_LBC_15K;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M825XX].astCodecInfo[eI_LBC_13K]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eI_LBC_15K;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M825XX].astCodecInfo[eRFC2833_EVENT]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eRFC2833_EVENT;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M825XX].astCodecInfo[eGSM_AMR_BWE]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eGSM_AMR_BWE;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M825XX].astCodecInfo[e4GV]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = e4GV;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M825XX].astCodecInfo[eRFC2833_TONE]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eRFC2833_TONE;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M825XX].astCodecInfo[eAMR_WB]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eAMR_WB;
	 
	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M825XX].astCodecInfo[eG729_MSPD]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG729_MSPD;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M825XX].astCodecInfo[eCESoPSN]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCESoPSN;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M825XX].astCodecInfo[eGSM_HR]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eGSM_HR;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M825XX].astCodecInfo[eCSD_BS30T_64k]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCSD_BS30T_64k;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M825XX].astCodecInfo[eCSD_BS30T_32k]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCSD_BS30T_32k;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M825XX].astCodecInfo[eCSD_BS30T_33k6]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCSD_BS30T_33k6;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M825XX].astCodecInfo[eCSD_BS30T_28k8]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCSD_BS30T_28k8;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M825XX].astCodecInfo[eCSD_BS20NT_57k6]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCSD_BS20NT_57k6;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M825XX].astCodecInfo[eCSD_BS20NT_28k8]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCSD_BS20NT_28k8;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M825XX].astCodecInfo[eCSD_BS20NT_14k4]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCSD_BS20NT_14k4;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M825XX].astCodecInfo[eG729_1]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG729_1;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M825XX].astCodecInfo[eAMR_WB_ba]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eAMR_WB_ba;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M825XX].astCodecInfo[eCCISoIP]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCCISoIP;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M825XX].astCodecInfo[eG722]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG722;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M825XX].astCodecInfo[eAMR_IF1]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eAMR_IF1;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M825XX].astCodecInfo[eAMR_IF2]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eAMR_IF2;

	pstVideoCodecInfo = &(pastDeviceConfig[DEV_TYPE_M825XX].astVideoCodecInfo[eH263_ID]);
	pstVideoCodecInfo->bIsSupported = False;
	pstVideoCodecInfo->usPTIndex = eH263_ID;

	pstVideoCodecInfo = &(pastDeviceConfig[DEV_TYPE_M825XX].astVideoCodecInfo[eRFC2190_ID]);
	pstVideoCodecInfo->bIsSupported = False;
	pstVideoCodecInfo->usPTIndex = eRFC2190_ID;

	pstVideoCodecInfo = &(pastDeviceConfig[DEV_TYPE_M825XX].astVideoCodecInfo[eH264_ID]);
	pstVideoCodecInfo->bIsSupported = False;
	pstVideoCodecInfo->usPTIndex = eH264_ID;

	pstVideoCodecInfo = &(pastDeviceConfig[DEV_TYPE_M825XX].astVideoCodecInfo[eMPEG4_ID]);
	pstVideoCodecInfo->bIsSupported = False;
	pstVideoCodecInfo->usPTIndex = eMPEG4_ID;

	/*Fill Codec Info For DEV_TYPE_M826XX */
	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M826XX].astCodecInfo[eGeneric_Comfort_Noise]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eGeneric_Comfort_Noise;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M826XX].astCodecInfo[eRedundant_Scheme_for_DTMF]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eRedundant_Scheme_for_DTMF;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M826XX].astCodecInfo[eDTMF_RTP]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eDTMF_RTP;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M826XX].astCodecInfo[eIFP]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eIFP;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M826XX].astCodecInfo[eG711_ULAW_PCM]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG711_ULAW_PCM;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M826XX].astCodecInfo[eG711_ALAW_PCM]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG711_ALAW_PCM;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M826XX].astCodecInfo[eG723_1]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG723_1;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M826XX].astCodecInfo[eG728_Audio]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG728_Audio;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M826XX].astCodecInfo[eG729_A]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG729_A;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M826XX].astCodecInfo[eG726_32]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG726_32;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M826XX].astCodecInfo[eGSM_FR_Audio]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eGSM_FR_Audio;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M826XX].astCodecInfo[eClear_Channel]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eClear_Channel;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M826XX].astCodecInfo[ePassthrough_ULAW]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = ePassthrough_ULAW;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M826XX].astCodecInfo[ePassthrough_ALAW]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = ePassthrough_ALAW;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M826XX].astCodecInfo[eG726_16_audio]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG726_16_audio;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M826XX].astCodecInfo[eG726_24_audio]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG726_24_audio;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M826XX].astCodecInfo[eG726_40_audio]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG726_40_audio;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M826XX].astCodecInfo[eGSM_EFR]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eGSM_EFR;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M826XX].astCodecInfo[eAMR]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eAMR;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M826XX].astCodecInfo[eEVRC]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eEVRC;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M826XX].astCodecInfo[eCNF_SEC]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCNF_SEC;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M826XX].astCodecInfo[eSMV]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eSMV;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M826XX].astCodecInfo[eQCELP_13K]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eQCELP_13K;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M826XX].astCodecInfo[eQCELP_8K]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eQCELP_8K;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M826XX].astCodecInfo[eCRBT_ADPCM]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCRBT_ADPCM;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M826XX].astCodecInfo[eG729_EG]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG729_EG;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M826XX].astCodecInfo[eFEC]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eFEC;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M826XX].astCodecInfo[eI_LBC_15K]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eI_LBC_15K;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M826XX].astCodecInfo[eI_LBC_13K]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eI_LBC_15K;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M826XX].astCodecInfo[eRFC2833_EVENT]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eRFC2833_EVENT;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M826XX].astCodecInfo[eGSM_AMR_BWE]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eGSM_AMR_BWE;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M826XX].astCodecInfo[e4GV]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = e4GV;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M826XX].astCodecInfo[eRFC2833_TONE]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eRFC2833_TONE;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M826XX].astCodecInfo[eAMR_WB]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eAMR_WB;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M826XX].astCodecInfo[eG729_MSPD]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG729_MSPD;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M826XX].astCodecInfo[eCESoPSN]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCESoPSN;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M826XX].astCodecInfo[eGSM_HR]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eGSM_HR;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M826XX].astCodecInfo[eCSD_BS30T_64k]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCSD_BS30T_64k;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M826XX].astCodecInfo[eCSD_BS30T_32k]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCSD_BS30T_32k;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M826XX].astCodecInfo[eCSD_BS30T_33k6]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCSD_BS30T_33k6;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M826XX].astCodecInfo[eCSD_BS30T_28k8]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCSD_BS30T_28k8;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M826XX].astCodecInfo[eCSD_BS20NT_57k6]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCSD_BS20NT_57k6;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M826XX].astCodecInfo[eCSD_BS20NT_28k8]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCSD_BS20NT_28k8;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M826XX].astCodecInfo[eCSD_BS20NT_14k4]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCSD_BS20NT_14k4;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M826XX].astCodecInfo[eG729_1]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG729_1;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M826XX].astCodecInfo[eAMR_WB_ba]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eAMR_WB_ba;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M826XX].astCodecInfo[eCCISoIP]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCCISoIP;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M826XX].astCodecInfo[eG722]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG722;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M826XX].astCodecInfo[eAMR_IF1]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eAMR_IF1;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M826XX].astCodecInfo[eAMR_IF2]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eAMR_IF2;

	pstVideoCodecInfo = &(pastDeviceConfig[DEV_TYPE_M826XX].astVideoCodecInfo[eH263_ID]);
	pstVideoCodecInfo->bIsSupported = False;
	pstVideoCodecInfo->usPTIndex = eH263_ID;

	pstVideoCodecInfo = &(pastDeviceConfig[DEV_TYPE_M826XX].astVideoCodecInfo[eRFC2190_ID]);
	pstVideoCodecInfo->bIsSupported = False;
	pstVideoCodecInfo->usPTIndex = eRFC2190_ID;

	pstVideoCodecInfo = &(pastDeviceConfig[DEV_TYPE_M826XX].astVideoCodecInfo[eH264_ID]);
	pstVideoCodecInfo->bIsSupported = False;
	pstVideoCodecInfo->usPTIndex = eH264_ID;

	pstVideoCodecInfo = &(pastDeviceConfig[DEV_TYPE_M826XX].astVideoCodecInfo[eMPEG4_ID]);
	pstVideoCodecInfo->bIsSupported = False;
	pstVideoCodecInfo->usPTIndex = eMPEG4_ID;

	/*Fill Codec Info For DEV_TYPE_M826XX */
	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M826XX].astCodecInfo[eGeneric_Comfort_Noise]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eGeneric_Comfort_Noise;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M826XX].astCodecInfo[eRedundant_Scheme_for_DTMF]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eRedundant_Scheme_for_DTMF;

	/*Fill Codec Info For DEV_TYPE_M827XX */
	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M827XX].astCodecInfo[eGeneric_Comfort_Noise]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eGeneric_Comfort_Noise;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M827XX].astCodecInfo[eRedundant_Scheme_for_DTMF]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eRedundant_Scheme_for_DTMF;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M827XX].astCodecInfo[eDTMF_RTP]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eDTMF_RTP;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M827XX].astCodecInfo[eIFP]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eIFP;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M827XX].astCodecInfo[eG711_ULAW_PCM]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG711_ULAW_PCM;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M827XX].astCodecInfo[eG711_ALAW_PCM]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG711_ALAW_PCM;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M827XX].astCodecInfo[eG723_1]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG723_1;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M827XX].astCodecInfo[eG728_Audio]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG728_Audio;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M827XX].astCodecInfo[eG729_A]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG729_A;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M827XX].astCodecInfo[eG726_32]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG726_32;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M827XX].astCodecInfo[eGSM_FR_Audio]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eGSM_FR_Audio;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M827XX].astCodecInfo[eClear_Channel]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eClear_Channel;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M827XX].astCodecInfo[ePassthrough_ULAW]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = ePassthrough_ULAW;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M827XX].astCodecInfo[ePassthrough_ALAW]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = ePassthrough_ALAW;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M827XX].astCodecInfo[eG726_16_audio]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG726_16_audio;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M827XX].astCodecInfo[eG726_24_audio]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG726_24_audio;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M827XX].astCodecInfo[eG726_40_audio]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG726_40_audio;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M827XX].astCodecInfo[eGSM_EFR]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eGSM_EFR;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M827XX].astCodecInfo[eAMR]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eAMR;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M827XX].astCodecInfo[eEVRC]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eEVRC;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M827XX].astCodecInfo[eCNF_SEC]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCNF_SEC;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M827XX].astCodecInfo[eSMV]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eSMV;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M827XX].astCodecInfo[eQCELP_13K]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eQCELP_13K;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M827XX].astCodecInfo[eQCELP_8K]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eQCELP_8K;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M827XX].astCodecInfo[eCRBT_ADPCM]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCRBT_ADPCM;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M827XX].astCodecInfo[eG729_EG]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG729_EG;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M827XX].astCodecInfo[eFEC]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eFEC;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M827XX].astCodecInfo[eI_LBC_15K]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eI_LBC_15K;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M827XX].astCodecInfo[eI_LBC_13K]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eI_LBC_15K;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M827XX].astCodecInfo[eRFC2833_EVENT]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eRFC2833_EVENT;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M827XX].astCodecInfo[eGSM_AMR_BWE]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eGSM_AMR_BWE;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M827XX].astCodecInfo[e4GV]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = e4GV;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M827XX].astCodecInfo[eRFC2833_TONE]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eRFC2833_TONE;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M827XX].astCodecInfo[eAMR_WB]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eAMR_WB;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M827XX].astCodecInfo[eG729_MSPD]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG729_MSPD;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M827XX].astCodecInfo[eCESoPSN]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCESoPSN;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M827XX].astCodecInfo[eGSM_HR]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eGSM_HR;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M827XX].astCodecInfo[eCSD_BS30T_64k]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCSD_BS30T_64k;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M827XX].astCodecInfo[eCSD_BS30T_32k]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCSD_BS30T_32k;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M827XX].astCodecInfo[eCSD_BS30T_33k6]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCSD_BS30T_33k6;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M827XX].astCodecInfo[eCSD_BS30T_28k8]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCSD_BS30T_28k8;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M827XX].astCodecInfo[eCSD_BS20NT_57k6]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCSD_BS20NT_57k6;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M827XX].astCodecInfo[eCSD_BS20NT_28k8]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCSD_BS20NT_28k8;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M827XX].astCodecInfo[eCSD_BS20NT_14k4]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCSD_BS20NT_14k4;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M827XX].astCodecInfo[eG729_1]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG729_1;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M827XX].astCodecInfo[eAMR_WB_ba]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eAMR_WB_ba;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M827XX].astCodecInfo[eCCISoIP]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCCISoIP;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M827XX].astCodecInfo[eG722]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG722;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M827XX].astCodecInfo[eAMR_IF1]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eAMR_IF1;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M827XX].astCodecInfo[eAMR_IF2]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eAMR_IF2;

	pstVideoCodecInfo = &(pastDeviceConfig[DEV_TYPE_M827XX].astVideoCodecInfo[eH263_ID]);
	pstVideoCodecInfo->bIsSupported = False;
	pstVideoCodecInfo->usPTIndex = eH263_ID;

	pstVideoCodecInfo = &(pastDeviceConfig[DEV_TYPE_M827XX].astVideoCodecInfo[eRFC2190_ID]);
	pstVideoCodecInfo->bIsSupported = False;
	pstVideoCodecInfo->usPTIndex = eRFC2190_ID;

	pstVideoCodecInfo = &(pastDeviceConfig[DEV_TYPE_M827XX].astVideoCodecInfo[eH264_ID]);
	pstVideoCodecInfo->bIsSupported = False;
	pstVideoCodecInfo->usPTIndex = eH264_ID;

	pstVideoCodecInfo = &(pastDeviceConfig[DEV_TYPE_M827XX].astVideoCodecInfo[eMPEG4_ID]);
	pstVideoCodecInfo->bIsSupported = False;
	pstVideoCodecInfo->usPTIndex = eMPEG4_ID;

	/*Fill Codec Info For DEV_TYPE_M828XX */
	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M828XX].astCodecInfo[eGeneric_Comfort_Noise]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eGeneric_Comfort_Noise;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M828XX].astCodecInfo[eRedundant_Scheme_for_DTMF]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eRedundant_Scheme_for_DTMF;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M828XX].astCodecInfo[eDTMF_RTP]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eDTMF_RTP;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M828XX].astCodecInfo[eIFP]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eIFP;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M828XX].astCodecInfo[eG711_ULAW_PCM]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG711_ULAW_PCM;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M828XX].astCodecInfo[eG711_ALAW_PCM]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG711_ALAW_PCM;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M828XX].astCodecInfo[eG723_1]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG723_1;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M828XX].astCodecInfo[eG728_Audio]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eG728_Audio;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M828XX].astCodecInfo[eG729_A]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG729_A;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M828XX].astCodecInfo[eG726_32]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG726_32;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M828XX].astCodecInfo[eGSM_FR_Audio]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eGSM_FR_Audio;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M828XX].astCodecInfo[eClear_Channel]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eClear_Channel;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M828XX].astCodecInfo[ePassthrough_ULAW]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = ePassthrough_ULAW;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M828XX].astCodecInfo[ePassthrough_ALAW]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = ePassthrough_ALAW;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M828XX].astCodecInfo[eG726_16_audio]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG726_16_audio;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M828XX].astCodecInfo[eG726_24_audio]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG726_24_audio;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M828XX].astCodecInfo[eG726_40_audio]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG726_40_audio;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M828XX].astCodecInfo[eGSM_EFR]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eGSM_EFR;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M828XX].astCodecInfo[eAMR]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eAMR;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M828XX].astCodecInfo[eEVRC]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eEVRC;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M828XX].astCodecInfo[eCNF_SEC]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCNF_SEC;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M828XX].astCodecInfo[eSMV]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eSMV;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M828XX].astCodecInfo[eQCELP_13K]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eQCELP_13K;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M828XX].astCodecInfo[eQCELP_8K]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eQCELP_8K;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M828XX].astCodecInfo[eCRBT_ADPCM]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCRBT_ADPCM;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M828XX].astCodecInfo[eG729_EG]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG729_EG;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M828XX].astCodecInfo[eFEC]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eFEC;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M828XX].astCodecInfo[eI_LBC_15K]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eI_LBC_15K;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M828XX].astCodecInfo[eI_LBC_13K]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eI_LBC_15K;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M828XX].astCodecInfo[eRFC2833_EVENT]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eRFC2833_EVENT;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M828XX].astCodecInfo[eGSM_AMR_BWE]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eGSM_AMR_BWE;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M828XX].astCodecInfo[e4GV]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = e4GV;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M828XX].astCodecInfo[eRFC2833_TONE]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eRFC2833_TONE;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M828XX].astCodecInfo[eAMR_WB]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eAMR_WB;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M828XX].astCodecInfo[eG729_MSPD]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eG729_MSPD;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M828XX].astCodecInfo[eCESoPSN]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eCESoPSN;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M828XX].astCodecInfo[eGSM_HR]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eGSM_HR;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M828XX].astCodecInfo[eCSD_BS30T_64k]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eCSD_BS30T_64k;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M828XX].astCodecInfo[eCSD_BS30T_32k]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eCSD_BS30T_32k;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M828XX].astCodecInfo[eCSD_BS30T_33k6]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eCSD_BS30T_33k6;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M828XX].astCodecInfo[eCSD_BS30T_28k8]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eCSD_BS30T_28k8;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M828XX].astCodecInfo[eCSD_BS20NT_57k6]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eCSD_BS20NT_57k6;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M828XX].astCodecInfo[eCSD_BS20NT_28k8]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eCSD_BS20NT_28k8;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M828XX].astCodecInfo[eCSD_BS20NT_14k4]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eCSD_BS20NT_14k4;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M828XX].astCodecInfo[eG729_1]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eG729_1;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M828XX].astCodecInfo[eAMR_WB_ba]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eAMR_WB_ba;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M828XX].astCodecInfo[eCCISoIP]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eCCISoIP;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M828XX].astCodecInfo[eG722]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eG722;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M828XX].astCodecInfo[eAMR_IF1]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eAMR_IF1;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M828XX].astCodecInfo[eAMR_IF2]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eAMR_IF2;

	pstVideoCodecInfo = &(pastDeviceConfig[DEV_TYPE_M828XX].astVideoCodecInfo[eH263_ID]);
	pstVideoCodecInfo->bIsSupported = False;
	pstVideoCodecInfo->usPTIndex = eH263_ID;

	pstVideoCodecInfo = &(pastDeviceConfig[DEV_TYPE_M828XX].astVideoCodecInfo[eRFC2190_ID]);
	pstVideoCodecInfo->bIsSupported = False;
	pstVideoCodecInfo->usPTIndex = eRFC2190_ID;

	pstVideoCodecInfo = &(pastDeviceConfig[DEV_TYPE_M828XX].astVideoCodecInfo[eH264_ID]);
	pstVideoCodecInfo->bIsSupported = False;
	pstVideoCodecInfo->usPTIndex = eH264_ID;

	pstVideoCodecInfo = &(pastDeviceConfig[DEV_TYPE_M828XX].astVideoCodecInfo[eMPEG4_ID]);
	pstVideoCodecInfo->bIsSupported = False;
	pstVideoCodecInfo->usPTIndex = eMPEG4_ID;

	/*Fill Codec Info For DEV_TYPE_M829XX */
	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M829XX].astCodecInfo[eGeneric_Comfort_Noise]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eGeneric_Comfort_Noise;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M829XX].astCodecInfo[eRedundant_Scheme_for_DTMF]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eRedundant_Scheme_for_DTMF;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M829XX].astCodecInfo[eDTMF_RTP]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eDTMF_RTP;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M829XX].astCodecInfo[eIFP]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eIFP;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M829XX].astCodecInfo[eG711_ULAW_PCM]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG711_ULAW_PCM;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M829XX].astCodecInfo[eG711_ALAW_PCM]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG711_ALAW_PCM;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M829XX].astCodecInfo[eG723_1]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG723_1;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M829XX].astCodecInfo[eG728_Audio]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG728_Audio;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M829XX].astCodecInfo[eG729_A]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG729_A;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M829XX].astCodecInfo[eG726_32]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG726_32;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M829XX].astCodecInfo[eGSM_FR_Audio]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eGSM_FR_Audio;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M829XX].astCodecInfo[eClear_Channel]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eClear_Channel;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M829XX].astCodecInfo[ePassthrough_ULAW]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = ePassthrough_ULAW;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M829XX].astCodecInfo[ePassthrough_ALAW]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = ePassthrough_ALAW;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M829XX].astCodecInfo[eG726_16_audio]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG726_16_audio;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M829XX].astCodecInfo[eG726_24_audio]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG726_24_audio;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M829XX].astCodecInfo[eG726_40_audio]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG726_40_audio;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M829XX].astCodecInfo[eGSM_EFR]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eGSM_EFR;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M829XX].astCodecInfo[eAMR]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eAMR;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M829XX].astCodecInfo[eEVRC]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eEVRC;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M829XX].astCodecInfo[eCNF_SEC]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCNF_SEC;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M829XX].astCodecInfo[eSMV]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eSMV;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M829XX].astCodecInfo[eQCELP_13K]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eQCELP_13K;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M829XX].astCodecInfo[eQCELP_8K]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eQCELP_8K;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M829XX].astCodecInfo[eCRBT_ADPCM]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCRBT_ADPCM;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M829XX].astCodecInfo[eG729_EG]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG729_EG;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M829XX].astCodecInfo[eFEC]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eFEC;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M829XX].astCodecInfo[eI_LBC_15K]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eI_LBC_15K;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M829XX].astCodecInfo[eI_LBC_13K]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eI_LBC_15K;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M829XX].astCodecInfo[eRFC2833_EVENT]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eRFC2833_EVENT;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M829XX].astCodecInfo[eGSM_AMR_BWE]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eGSM_AMR_BWE;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M829XX].astCodecInfo[e4GV]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = e4GV;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M829XX].astCodecInfo[eRFC2833_TONE]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eRFC2833_TONE;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M829XX].astCodecInfo[eAMR_WB]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eAMR_WB;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M829XX].astCodecInfo[eG729_MSPD]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG729_MSPD;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M829XX].astCodecInfo[eCESoPSN]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCESoPSN;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M829XX].astCodecInfo[eGSM_HR]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eGSM_HR;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M829XX].astCodecInfo[eCSD_BS30T_64k]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCSD_BS30T_64k;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M829XX].astCodecInfo[eCSD_BS30T_32k]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCSD_BS30T_32k;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M829XX].astCodecInfo[eCSD_BS30T_33k6]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCSD_BS30T_33k6;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M829XX].astCodecInfo[eCSD_BS30T_28k8]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCSD_BS30T_28k8;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M829XX].astCodecInfo[eCSD_BS20NT_57k6]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCSD_BS20NT_57k6;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M829XX].astCodecInfo[eCSD_BS20NT_28k8]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCSD_BS20NT_28k8;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M829XX].astCodecInfo[eCSD_BS20NT_14k4]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCSD_BS20NT_14k4;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M829XX].astCodecInfo[eG729_1]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG729_1;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M829XX].astCodecInfo[eAMR_WB_ba]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eAMR_WB_ba;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M829XX].astCodecInfo[eCCISoIP]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCCISoIP;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M829XX].astCodecInfo[eG722]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG722;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M829XX].astCodecInfo[eAMR_IF1]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eAMR_IF1;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M829XX].astCodecInfo[eAMR_IF2]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eAMR_IF2;

	pstVideoCodecInfo = &(pastDeviceConfig[DEV_TYPE_M829XX].astVideoCodecInfo[eH263_ID]);
	pstVideoCodecInfo->bIsSupported = True;
	pstVideoCodecInfo->usPTIndex = eH263_ID;

	pstVideoCodecInfo = &(pastDeviceConfig[DEV_TYPE_M829XX].astVideoCodecInfo[eRFC2190_ID]);
	pstVideoCodecInfo->bIsSupported = True;
	pstVideoCodecInfo->usPTIndex = eRFC2190_ID;

	pstVideoCodecInfo = &(pastDeviceConfig[DEV_TYPE_M829XX].astVideoCodecInfo[eH264_ID]);
	pstVideoCodecInfo->bIsSupported = True;
	pstVideoCodecInfo->usPTIndex = eH264_ID;

	pstVideoCodecInfo = &(pastDeviceConfig[DEV_TYPE_M829XX].astVideoCodecInfo[eMPEG4_ID]);
	pstVideoCodecInfo->bIsSupported = True;
	pstVideoCodecInfo->usPTIndex = eMPEG4_ID;

	/*Fill Codec Info For DEV_TYPE_M823XX */
	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX].astCodecInfo[eGeneric_Comfort_Noise]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eGeneric_Comfort_Noise;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX].astCodecInfo[eRedundant_Scheme_for_DTMF]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eRedundant_Scheme_for_DTMF;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX].astCodecInfo[eDTMF_RTP]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eDTMF_RTP;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX].astCodecInfo[eIFP]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eIFP;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX].astCodecInfo[eG711_ULAW_PCM]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG711_ULAW_PCM;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX].astCodecInfo[eG711_ALAW_PCM]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG711_ALAW_PCM;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX].astCodecInfo[eG723_1]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG723_1;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX].astCodecInfo[eG728_Audio]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eG728_Audio;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX].astCodecInfo[eG729_A]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG729_A;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX].astCodecInfo[eG726_32]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG726_32;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX].astCodecInfo[eGSM_FR_Audio]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eGSM_FR_Audio;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX].astCodecInfo[eClear_Channel]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eClear_Channel;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX].astCodecInfo[ePassthrough_ULAW]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = ePassthrough_ULAW;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX].astCodecInfo[ePassthrough_ALAW]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = ePassthrough_ALAW;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX].astCodecInfo[eG726_16_audio]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG726_16_audio;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX].astCodecInfo[eG726_24_audio]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG726_24_audio;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX].astCodecInfo[eG726_40_audio]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG726_40_audio;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX].astCodecInfo[eGSM_EFR]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eGSM_EFR;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX].astCodecInfo[eAMR]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eAMR;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX].astCodecInfo[eEVRC]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eEVRC;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX].astCodecInfo[eCNF_SEC]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCNF_SEC;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX].astCodecInfo[eSMV]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eSMV;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX].astCodecInfo[eQCELP_13K]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eQCELP_13K;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX].astCodecInfo[eQCELP_8K]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eQCELP_8K;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX].astCodecInfo[eCRBT_ADPCM]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCRBT_ADPCM;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX].astCodecInfo[eG729_EG]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG729_EG;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX].astCodecInfo[eFEC]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eFEC;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX].astCodecInfo[eI_LBC_15K]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eI_LBC_15K;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX].astCodecInfo[eI_LBC_13K]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eI_LBC_15K;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX].astCodecInfo[eRFC2833_EVENT]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eRFC2833_EVENT;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX].astCodecInfo[eGSM_AMR_BWE]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eGSM_AMR_BWE;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX].astCodecInfo[e4GV]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = e4GV;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX].astCodecInfo[eRFC2833_TONE]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eRFC2833_TONE;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX].astCodecInfo[eAMR_WB]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eAMR_WB;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX].astCodecInfo[eG729_MSPD]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG729_MSPD;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX].astCodecInfo[eCESoPSN]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCESoPSN;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX].astCodecInfo[eGSM_HR]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eGSM_HR;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX].astCodecInfo[eCSD_BS30T_64k]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCSD_BS30T_64k;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX].astCodecInfo[eCSD_BS30T_32k]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCSD_BS30T_32k;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX].astCodecInfo[eCSD_BS30T_33k6]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCSD_BS30T_33k6;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX].astCodecInfo[eCSD_BS30T_28k8]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCSD_BS30T_28k8;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX].astCodecInfo[eCSD_BS20NT_57k6]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCSD_BS20NT_57k6;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX].astCodecInfo[eCSD_BS20NT_28k8]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCSD_BS20NT_28k8;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX].astCodecInfo[eCSD_BS20NT_14k4]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCSD_BS20NT_14k4;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX].astCodecInfo[eG729_1]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG729_1;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX].astCodecInfo[eAMR_WB_ba]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eAMR_WB_ba;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX].astCodecInfo[eCCISoIP]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCCISoIP;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX].astCodecInfo[eG722]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG722;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX].astCodecInfo[eAMR_IF1]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eAMR_IF1;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX].astCodecInfo[eAMR_IF2]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eAMR_IF2;

	pstVideoCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX].astVideoCodecInfo[eH263_ID]);
	pstVideoCodecInfo->bIsSupported = False;
	pstVideoCodecInfo->usPTIndex = eH263_ID;

	pstVideoCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX].astVideoCodecInfo[eRFC2190_ID]);
	pstVideoCodecInfo->bIsSupported = False;
	pstVideoCodecInfo->usPTIndex = eRFC2190_ID;

	pstVideoCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX].astVideoCodecInfo[eH264_ID]);
	pstVideoCodecInfo->bIsSupported = False;
	pstVideoCodecInfo->usPTIndex = eH264_ID;

	pstVideoCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX].astVideoCodecInfo[eMPEG4_ID]);
	pstVideoCodecInfo->bIsSupported = False;
	pstVideoCodecInfo->usPTIndex = eMPEG4_ID;

	/*Fill Codec Info For DEV_TYPE_M821XX */
	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M821XX].astCodecInfo[eGeneric_Comfort_Noise]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eGeneric_Comfort_Noise;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M821XX].astCodecInfo[eRedundant_Scheme_for_DTMF]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eRedundant_Scheme_for_DTMF;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M821XX].astCodecInfo[eDTMF_RTP]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eDTMF_RTP;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M821XX].astCodecInfo[eIFP]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eIFP;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M821XX].astCodecInfo[eG711_ULAW_PCM]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG711_ULAW_PCM;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M821XX].astCodecInfo[eG711_ALAW_PCM]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG711_ALAW_PCM;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M821XX].astCodecInfo[eG723_1]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG723_1;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M821XX].astCodecInfo[eG728_Audio]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eG728_Audio;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M821XX].astCodecInfo[eG729_A]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG729_A;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M821XX].astCodecInfo[eG726_32]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG726_32;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M821XX].astCodecInfo[eGSM_FR_Audio]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eGSM_FR_Audio;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M821XX].astCodecInfo[eClear_Channel]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eClear_Channel;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M821XX].astCodecInfo[ePassthrough_ULAW]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = ePassthrough_ULAW;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M821XX].astCodecInfo[ePassthrough_ALAW]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = ePassthrough_ALAW;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M821XX].astCodecInfo[eG726_16_audio]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG726_16_audio;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M821XX].astCodecInfo[eG726_24_audio]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG726_24_audio;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M821XX].astCodecInfo[eG726_40_audio]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG726_40_audio;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M821XX].astCodecInfo[eGSM_EFR]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eGSM_EFR;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M821XX].astCodecInfo[eAMR]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eAMR;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M821XX].astCodecInfo[eEVRC]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eEVRC;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M821XX].astCodecInfo[eCNF_SEC]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eCNF_SEC;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M821XX].astCodecInfo[eSMV]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eSMV;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M821XX].astCodecInfo[eQCELP_13K]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eQCELP_13K;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M821XX].astCodecInfo[eQCELP_8K]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eQCELP_8K;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M821XX].astCodecInfo[eCRBT_ADPCM]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eCRBT_ADPCM;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M821XX].astCodecInfo[eG729_EG]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG729_EG;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M821XX].astCodecInfo[eFEC]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eFEC;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M821XX].astCodecInfo[eI_LBC_15K]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eI_LBC_15K;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M821XX].astCodecInfo[eI_LBC_13K]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eI_LBC_15K;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M821XX].astCodecInfo[eRFC2833_EVENT]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eRFC2833_EVENT;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M821XX].astCodecInfo[eGSM_AMR_BWE]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eGSM_AMR_BWE;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M821XX].astCodecInfo[e4GV]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = e4GV;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M821XX].astCodecInfo[eRFC2833_TONE]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eRFC2833_TONE;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M821XX].astCodecInfo[eAMR_WB]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eAMR_WB;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M821XX].astCodecInfo[eG729_MSPD]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eG729_MSPD;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M821XX].astCodecInfo[eCESoPSN]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eCESoPSN;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M821XX].astCodecInfo[eGSM_HR]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eGSM_HR;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M821XX].astCodecInfo[eCSD_BS30T_64k]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eCSD_BS30T_64k;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M821XX].astCodecInfo[eCSD_BS30T_32k]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eCSD_BS30T_32k;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M821XX].astCodecInfo[eCSD_BS30T_33k6]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eCSD_BS30T_33k6;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M821XX].astCodecInfo[eCSD_BS30T_28k8]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eCSD_BS30T_28k8;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M821XX].astCodecInfo[eCSD_BS20NT_57k6]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eCSD_BS20NT_57k6;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M821XX].astCodecInfo[eCSD_BS20NT_28k8]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eCSD_BS20NT_28k8;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M821XX].astCodecInfo[eCSD_BS20NT_14k4]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eCSD_BS20NT_14k4;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M821XX].astCodecInfo[eG729_1]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG729_1;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M821XX].astCodecInfo[eAMR_WB_ba]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eAMR_WB_ba;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M821XX].astCodecInfo[eCCISoIP]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eCCISoIP;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M821XX].astCodecInfo[eG722]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG722;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M821XX].astCodecInfo[eAMR_IF1]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eAMR_IF1;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M821XX].astCodecInfo[eAMR_IF2]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eAMR_IF2;

	pstVideoCodecInfo = &(pastDeviceConfig[DEV_TYPE_M821XX].astVideoCodecInfo[eH263_ID]);
	pstVideoCodecInfo->bIsSupported = False;
	pstVideoCodecInfo->usPTIndex = eH263_ID;

	pstVideoCodecInfo = &(pastDeviceConfig[DEV_TYPE_M821XX].astVideoCodecInfo[eRFC2190_ID]);
	pstVideoCodecInfo->bIsSupported = False;
	pstVideoCodecInfo->usPTIndex = eRFC2190_ID;

	pstVideoCodecInfo = &(pastDeviceConfig[DEV_TYPE_M821XX].astVideoCodecInfo[eH264_ID]);
	pstVideoCodecInfo->bIsSupported = False;
	pstVideoCodecInfo->usPTIndex = eH264_ID;

	pstVideoCodecInfo = &(pastDeviceConfig[DEV_TYPE_M821XX].astVideoCodecInfo[eMPEG4_ID]);
	pstVideoCodecInfo->bIsSupported = False;
	pstVideoCodecInfo->usPTIndex = eMPEG4_ID;

	/*Fill Codec Info For DEV_TYPE_M83XXX */
	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M83XXX].astCodecInfo[eGeneric_Comfort_Noise]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eGeneric_Comfort_Noise;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M83XXX].astCodecInfo[eRedundant_Scheme_for_DTMF]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eRedundant_Scheme_for_DTMF;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M83XXX].astCodecInfo[eDTMF_RTP]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eDTMF_RTP;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M83XXX].astCodecInfo[eIFP]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eIFP;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M83XXX].astCodecInfo[eG711_ULAW_PCM]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG711_ULAW_PCM;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M83XXX].astCodecInfo[eG711_ALAW_PCM]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG711_ALAW_PCM;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M83XXX].astCodecInfo[eG723_1]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG723_1;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M83XXX].astCodecInfo[eG728_Audio]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eG728_Audio;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M83XXX].astCodecInfo[eG729_A]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG729_A;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M83XXX].astCodecInfo[eG726_32]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG726_32;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M83XXX].astCodecInfo[eGSM_FR_Audio]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eGSM_FR_Audio;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M83XXX].astCodecInfo[eClear_Channel]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eClear_Channel;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M83XXX].astCodecInfo[ePassthrough_ULAW]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = ePassthrough_ULAW;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M83XXX].astCodecInfo[ePassthrough_ALAW]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = ePassthrough_ALAW;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M83XXX].astCodecInfo[eG726_16_audio]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG726_16_audio;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M83XXX].astCodecInfo[eG726_24_audio]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG726_24_audio;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M83XXX].astCodecInfo[eG726_40_audio]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG726_40_audio;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M83XXX].astCodecInfo[eGSM_EFR]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eGSM_EFR;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M83XXX].astCodecInfo[eAMR]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eAMR;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M83XXX].astCodecInfo[eEVRC]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eEVRC;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M83XXX].astCodecInfo[eCNF_SEC]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eCNF_SEC;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M83XXX].astCodecInfo[eSMV]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eSMV;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M83XXX].astCodecInfo[eQCELP_13K]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eQCELP_13K;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M83XXX].astCodecInfo[eQCELP_8K]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eQCELP_8K;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M83XXX].astCodecInfo[eCRBT_ADPCM]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eCRBT_ADPCM;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M83XXX].astCodecInfo[eG729_EG]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG729_EG;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M83XXX].astCodecInfo[eFEC]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eFEC;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M83XXX].astCodecInfo[eI_LBC_15K]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eI_LBC_15K;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M83XXX].astCodecInfo[eI_LBC_13K]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eI_LBC_15K;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M83XXX].astCodecInfo[eRFC2833_EVENT]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eRFC2833_EVENT;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M83XXX].astCodecInfo[eGSM_AMR_BWE]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eGSM_AMR_BWE;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M83XXX].astCodecInfo[e4GV]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = e4GV;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M83XXX].astCodecInfo[eRFC2833_TONE]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eRFC2833_TONE;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M83XXX].astCodecInfo[eAMR_WB]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eAMR_WB;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M83XXX].astCodecInfo[eG729_MSPD]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eG729_MSPD;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M83XXX].astCodecInfo[eCESoPSN]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eCESoPSN;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M83XXX].astCodecInfo[eGSM_HR]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eGSM_HR;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M83XXX].astCodecInfo[eCSD_BS30T_64k]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eCSD_BS30T_64k;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M83XXX].astCodecInfo[eCSD_BS30T_32k]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eCSD_BS30T_32k;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M83XXX].astCodecInfo[eCSD_BS30T_33k6]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eCSD_BS30T_33k6;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M83XXX].astCodecInfo[eCSD_BS30T_28k8]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eCSD_BS30T_28k8;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M83XXX].astCodecInfo[eCSD_BS20NT_57k6]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eCSD_BS20NT_57k6;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M83XXX].astCodecInfo[eCSD_BS20NT_28k8]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eCSD_BS20NT_28k8;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M83XXX].astCodecInfo[eCSD_BS20NT_14k4]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eCSD_BS20NT_14k4;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M83XXX].astCodecInfo[eG729_1]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG729_1;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M83XXX].astCodecInfo[eAMR_WB_ba]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eAMR_WB_ba;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M83XXX].astCodecInfo[eCCISoIP]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eCCISoIP;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M83XXX].astCodecInfo[eG722]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG722;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M83XXX].astCodecInfo[eAMR_IF1]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eAMR_IF1;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M83XXX].astCodecInfo[eAMR_IF2]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eAMR_IF2;

	pstVideoCodecInfo = &(pastDeviceConfig[DEV_TYPE_M83XXX].astVideoCodecInfo[eH263_ID]);
	pstVideoCodecInfo->bIsSupported = False;
	pstVideoCodecInfo->usPTIndex = eH263_ID;

	pstVideoCodecInfo = &(pastDeviceConfig[DEV_TYPE_M83XXX].astVideoCodecInfo[eRFC2190_ID]);
	pstVideoCodecInfo->bIsSupported = False;
	pstVideoCodecInfo->usPTIndex = eRFC2190_ID;

	pstVideoCodecInfo = &(pastDeviceConfig[DEV_TYPE_M83XXX].astVideoCodecInfo[eH264_ID]);
	pstVideoCodecInfo->bIsSupported = False;
	pstVideoCodecInfo->usPTIndex = eH264_ID;

	pstVideoCodecInfo = &(pastDeviceConfig[DEV_TYPE_M83XXX].astVideoCodecInfo[eMPEG4_ID]);
	pstVideoCodecInfo->bIsSupported = False;
	pstVideoCodecInfo->usPTIndex = eMPEG4_ID;

	/*Fill Codec Info For DEV_TYPE_M823XX_2 */
	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX_2].astCodecInfo[eGeneric_Comfort_Noise]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eGeneric_Comfort_Noise;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX_2].astCodecInfo[eRedundant_Scheme_for_DTMF]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eRedundant_Scheme_for_DTMF;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX_2].astCodecInfo[eDTMF_RTP]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eDTMF_RTP;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX_2].astCodecInfo[eIFP]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eIFP;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX_2].astCodecInfo[eG711_ULAW_PCM]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG711_ULAW_PCM;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX_2].astCodecInfo[eG711_ALAW_PCM]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG711_ALAW_PCM;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX_2].astCodecInfo[eG723_1]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG723_1;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX_2].astCodecInfo[eG728_Audio]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eG728_Audio;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX_2].astCodecInfo[eG729_A]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG729_A;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX_2].astCodecInfo[eG726_32]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG726_32;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX_2].astCodecInfo[eGSM_FR_Audio]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eGSM_FR_Audio;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX_2].astCodecInfo[eClear_Channel]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eClear_Channel;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX_2].astCodecInfo[ePassthrough_ULAW]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = ePassthrough_ULAW;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX_2].astCodecInfo[ePassthrough_ALAW]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = ePassthrough_ALAW;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX_2].astCodecInfo[eG726_16_audio]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG726_16_audio;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX_2].astCodecInfo[eG726_24_audio]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG726_24_audio;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX_2].astCodecInfo[eG726_40_audio]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG726_40_audio;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX_2].astCodecInfo[eGSM_EFR]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eGSM_EFR;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX_2].astCodecInfo[eAMR]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eAMR;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX_2].astCodecInfo[eEVRC]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eEVRC;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX_2].astCodecInfo[eCNF_SEC]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCNF_SEC;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX_2].astCodecInfo[eSMV]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eSMV;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX_2].astCodecInfo[eQCELP_13K]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eQCELP_13K;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX_2].astCodecInfo[eQCELP_8K]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eQCELP_8K;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX_2].astCodecInfo[eCRBT_ADPCM]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCRBT_ADPCM;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX_2].astCodecInfo[eG729_EG]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG729_EG;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX_2].astCodecInfo[eFEC]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eFEC;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX_2].astCodecInfo[eI_LBC_15K]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eI_LBC_15K;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX_2].astCodecInfo[eI_LBC_13K]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eI_LBC_15K;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX_2].astCodecInfo[eRFC2833_EVENT]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eRFC2833_EVENT;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX_2].astCodecInfo[eGSM_AMR_BWE]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eGSM_AMR_BWE;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX_2].astCodecInfo[e4GV]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = e4GV;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX_2].astCodecInfo[eRFC2833_TONE]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eRFC2833_TONE;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX_2].astCodecInfo[eAMR_WB]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eAMR_WB;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX_2].astCodecInfo[eG729_MSPD]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG729_MSPD;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX_2].astCodecInfo[eCESoPSN]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCESoPSN;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX_2].astCodecInfo[eGSM_HR]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eGSM_HR;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX_2].astCodecInfo[eCSD_BS30T_64k]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCSD_BS30T_64k;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX_2].astCodecInfo[eCSD_BS30T_32k]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCSD_BS30T_32k;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX_2].astCodecInfo[eCSD_BS30T_33k6]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCSD_BS30T_33k6;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX_2].astCodecInfo[eCSD_BS30T_28k8]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCSD_BS30T_28k8;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX_2].astCodecInfo[eCSD_BS20NT_57k6]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCSD_BS20NT_57k6;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX_2].astCodecInfo[eCSD_BS20NT_28k8]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCSD_BS20NT_28k8;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX_2].astCodecInfo[eCSD_BS20NT_14k4]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCSD_BS20NT_14k4;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX_2].astCodecInfo[eG729_1]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG729_1;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX_2].astCodecInfo[eAMR_WB_ba]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eAMR_WB_ba;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX_2].astCodecInfo[eCCISoIP]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eCCISoIP;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX_2].astCodecInfo[eG722]);
	pstCodecInfo->bIsSupported = True;
	pstCodecInfo->usPTIndex = eG722;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX_2].astCodecInfo[eAMR_IF1]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eAMR_IF1;

	pstCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX_2].astCodecInfo[eAMR_IF2]);
	pstCodecInfo->bIsSupported = False;
	pstCodecInfo->usPTIndex = eAMR_IF2;

	pstVideoCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX_2].astVideoCodecInfo[eH263_ID]);
	pstVideoCodecInfo->bIsSupported = False;
	pstVideoCodecInfo->usPTIndex = eH263_ID;

	pstVideoCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX_2].astVideoCodecInfo[eRFC2190_ID]);
	pstVideoCodecInfo->bIsSupported = False;
	pstVideoCodecInfo->usPTIndex = eRFC2190_ID;

	pstVideoCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX_2].astVideoCodecInfo[eH264_ID]);
	pstVideoCodecInfo->bIsSupported = False;
	pstVideoCodecInfo->usPTIndex = eH264_ID;

	pstVideoCodecInfo = &(pastDeviceConfig[DEV_TYPE_M823XX_2].astVideoCodecInfo[eMPEG4_ID]);
	pstVideoCodecInfo->bIsSupported = False;
	pstVideoCodecInfo->usPTIndex = eMPEG4_ID;	

	/* Filling the default SHwCfg for each device DEV_TYPE_M825XX */
	pstSHwCfg = &(pastDeviceConfig[DEV_TYPE_M825XX].stSHwCfg);
	pstSHwCfg->usSdramParamTiming1 = SDRAM_PARAM_TIMING1;
	pstSHwCfg->usSdramParamTiming2 = SDRAM_PARAM_TIMING2;
	pstSHwCfg->usSdramRefresh = SDRAM_PARAM_REF_FREQ;
	pstSHwCfg->usSdramPoweron = SDRAM_PARAM_POWERON;
	pstSHwCfg->usCSparamTiming = CS0_PARAM_TIMING;

	/* Filling the default SHwCfg for each device DEV_TYPE_M826XX */
	pstSHwCfg = &(pastDeviceConfig[DEV_TYPE_M826XX].stSHwCfg);
	pstSHwCfg->usSdramParamTiming1 = SDRAM_PARAM_TIMING1;	
	pstSHwCfg->usSdramParamTiming2 = SDRAM_PARAM_TIMING2;
	pstSHwCfg->usSdramRefresh = SDRAM_PARAM_REF_FREQ;
	pstSHwCfg->usSdramPoweron = SDRAM_PARAM_POWERON;
	pstSHwCfg->usCSparamTiming = CS0_PARAM_TIMING;

	/* Filling the default SHwCfg for each device DEV_TYPE_M827XX */
	pstSHwCfg = &(pastDeviceConfig[DEV_TYPE_M827XX].stSHwCfg);
	pstSHwCfg->usSdramParamTiming1 = SDRAM_PARAM_TIMING1;	
	pstSHwCfg->usSdramParamTiming2 = SDRAM_PARAM_TIMING2;
	pstSHwCfg->usSdramRefresh = SDRAM_PARAM_REF_FREQ;
	pstSHwCfg->usSdramPoweron = SDRAM_PARAM_POWERON;
	pstSHwCfg->usCSparamTiming = CS0_PARAM_TIMING;

	/* Filling the default SHwCfg for each device DEV_TYPE_M829XX */
	pstSHwCfg = &(pastDeviceConfig[DEV_TYPE_M829XX].stSHwCfg);
	pstSHwCfg->usSdramParamTiming1 = SDRAM_PARAM_TIMING1_M829XX;	
	pstSHwCfg->usSdramParamTiming2 = SDRAM_PARAM_TIMING2_M829XX;
	pstSHwCfg->usSdramRefresh = SDRAM_PARAM_REF_FREQ_M829XX;
	pstSHwCfg->usSdramPoweron = SDRAM_PARAM_POWERON;
	pstSHwCfg->usCSparamTiming = CS0_PARAM_TIMING;

	/* Filling the default SHwCfg for each device DEV_TYPE_M823XX */
	pstSHwCfg = &(pastDeviceConfig[DEV_TYPE_M823XX].stSHwCfg);
	pstSHwCfg->usSdramParamTiming1 = SDRAM_PARAM_TIMING1_M823XX;	
	pstSHwCfg->usSdramParamTiming2 = SDRAM_PARAM_TIMING2_M823XX;
	pstSHwCfg->usSdramRefresh = SDRAM_PARAM_REF_FREQ_M823XX;
	pstSHwCfg->usSdramPoweron = SDRAM_PARAM_POWERON;
	pstSHwCfg->usCSparamTiming = CS0_PARAM_TIMING;
	pstSHwCfg->usDeviceRefclk = DEVICE_REFCLK_25MHZ;

	/* Filling the default SHwCfg for each device DEV_TYPE_M823XX_2 */
	pstSHwCfg = &(pastDeviceConfig[DEV_TYPE_M823XX_2].stSHwCfg);
	pstSHwCfg->usSdramParamTiming1 = SDRAM_PARAM_TIMING1_M823XX_2;
	pstSHwCfg->usSdramParamTiming2 = SDRAM_PARAM_TIMING2_M823XX;
	pstSHwCfg->usSdramRefresh = SDRAM_PARAM_REF_FREQ_M823XX_2;
	pstSHwCfg->usSdramPoweron = SDRAM_PARAM_POWERON;
	pstSHwCfg->usCSparamTiming = CS0_PARAM_TIMING_M823XX_2;
	pstSHwCfg->ptrSdramParam_C300_2 = uiSdramParam_C300_2;
	pstSHwCfg->usSdramParamNum = UT_ARRAY_SIZE(uiSdramParam_C300_2) / 2;
	pstSHwCfg->usDeviceAmbaClkM823V2 = DEVICE_AMBA_M823V2_137MHZ;

	 /*SDRAM*/ pastDeviceConfig[DEV_TYPE_M825XX].stMemInfo.aulMemBase[SDRAM_INDEX] = M825XX_SDRAM_START;
	pastDeviceConfig[DEV_TYPE_M825XX].stMemInfo.aulMemSize[SDRAM_INDEX] = M825XX_SDRAM_SIZE;
	 /*IRAM*/ pastDeviceConfig[DEV_TYPE_M825XX].stMemInfo.aulMemBase[IRAM_INDEX] = M825XX_IRAM_START;
	pastDeviceConfig[DEV_TYPE_M825XX].stMemInfo.aulMemSize[IRAM_INDEX] = M825XX_IRAM_SIZE;
	 /*ERAM*/ pastDeviceConfig[DEV_TYPE_M825XX].stMemInfo.aulMemBase[ERAM_INDEX] = M825XX_ERAM_START;
	pastDeviceConfig[DEV_TYPE_M825XX].stMemInfo.aulMemSize[ERAM_INDEX] = M825XX_ERAM_SIZE;

	 /*SDRAM*/ pastDeviceConfig[DEV_TYPE_M826XX].stMemInfo.aulMemBase[SDRAM_INDEX] = M826XX_SDRAM_START;
	pastDeviceConfig[DEV_TYPE_M826XX].stMemInfo.aulMemSize[SDRAM_INDEX] = M826XX_SDRAM_SIZE;
	 /*IRAM*/ pastDeviceConfig[DEV_TYPE_M826XX].stMemInfo.aulMemBase[IRAM_INDEX] = M826XX_IRAM_START;
	pastDeviceConfig[DEV_TYPE_M826XX].stMemInfo.aulMemSize[IRAM_INDEX] = M826XX_IRAM_SIZE;
	 /*ERAM*/ pastDeviceConfig[DEV_TYPE_M826XX].stMemInfo.aulMemBase[ERAM_INDEX] = M826XX_ERAM_START;
	pastDeviceConfig[DEV_TYPE_M826XX].stMemInfo.aulMemSize[ERAM_INDEX] = M826XX_ERAM_SIZE;

	 /*SDRAM*/ pastDeviceConfig[DEV_TYPE_M827XX].stMemInfo.aulMemBase[SDRAM_INDEX] = M827XX_SDRAM_START;
	pastDeviceConfig[DEV_TYPE_M827XX].stMemInfo.aulMemSize[SDRAM_INDEX] = M827XX_SDRAM_SIZE;
	 /*IRAM*/ pastDeviceConfig[DEV_TYPE_M827XX].stMemInfo.aulMemBase[IRAM_INDEX] = M827XX_IRAM_START;
	pastDeviceConfig[DEV_TYPE_M827XX].stMemInfo.aulMemSize[IRAM_INDEX] = M827XX_IRAM_SIZE;
	 /*ERAM*/ pastDeviceConfig[DEV_TYPE_M827XX].stMemInfo.aulMemBase[ERAM_INDEX] = M827XX_ERAM_START;
	pastDeviceConfig[DEV_TYPE_M827XX].stMemInfo.aulMemSize[ERAM_INDEX] = M827XX_ERAM_SIZE;
	 /*ARAM*/ pastDeviceConfig[DEV_TYPE_M827XX].stMemInfo.aulMemBase[ARAM_INDEX] = M827XX_ARAM_START;
	pastDeviceConfig[DEV_TYPE_M827XX].stMemInfo.aulMemSize[ARAM_INDEX] = M827XX_ARAM_SIZE;

	 /*SDRAM*/ pastDeviceConfig[DEV_TYPE_M828XX].stMemInfo.aulMemBase[SDRAM_INDEX] = M828XX_SDRAM_START;
	pastDeviceConfig[DEV_TYPE_M828XX].stMemInfo.aulMemSize[SDRAM_INDEX] = M828XX_SDRAM_SIZE;
	 /*IRAM*/ pastDeviceConfig[DEV_TYPE_M828XX].stMemInfo.aulMemBase[IRAM_INDEX] = M828XX_IRAM_START;
	pastDeviceConfig[DEV_TYPE_M828XX].stMemInfo.aulMemSize[IRAM_INDEX] = M828XX_IRAM_SIZE;
	 /*ERAM*/ pastDeviceConfig[DEV_TYPE_M828XX].stMemInfo.aulMemBase[ERAM_INDEX] = M828XX_ERAM_START;
	pastDeviceConfig[DEV_TYPE_M828XX].stMemInfo.aulMemSize[ERAM_INDEX] = M828XX_ERAM_SIZE;
	 /*ARAM*/ pastDeviceConfig[DEV_TYPE_M828XX].stMemInfo.aulMemBase[ARAM_INDEX] = M828XX_ARAM_START;
	pastDeviceConfig[DEV_TYPE_M828XX].stMemInfo.aulMemSize[ARAM_INDEX] = M828XX_ARAM_SIZE;
	
	 /*SDRAM*/ pastDeviceConfig[DEV_TYPE_M829XX].stMemInfo.aulMemBase[SDRAM_INDEX] = M829XX_SDRAM_START;
	pastDeviceConfig[DEV_TYPE_M829XX].stMemInfo.aulMemSize[SDRAM_INDEX] = M829XX_SDRAM_SIZE;
	 /*IRAM*/ pastDeviceConfig[DEV_TYPE_M829XX].stMemInfo.aulMemBase[IRAM_INDEX] = M829XX_IRAM_START;
	pastDeviceConfig[DEV_TYPE_M829XX].stMemInfo.aulMemSize[IRAM_INDEX] = M829XX_IRAM_SIZE;
	 /*ERAM*/ pastDeviceConfig[DEV_TYPE_M829XX].stMemInfo.aulMemBase[ERAM_INDEX] = M829XX_ERAM_START;
	pastDeviceConfig[DEV_TYPE_M829XX].stMemInfo.aulMemSize[ERAM_INDEX] = M829XX_ERAM_SIZE;
	 /*ARAM*/ pastDeviceConfig[DEV_TYPE_M829XX].stMemInfo.aulMemBase[ARAM_INDEX] = M829XX_ARAM_START;
	pastDeviceConfig[DEV_TYPE_M829XX].stMemInfo.aulMemSize[ARAM_INDEX] = M829XX_ARAM_SIZE;

	 /*SDRAM*/ pastDeviceConfig[DEV_TYPE_M823XX].stMemInfo.aulMemBase[SDRAM_INDEX] = M823XX_SDRAM_START;
	pastDeviceConfig[DEV_TYPE_M823XX].stMemInfo.aulMemSize[SDRAM_INDEX] = M823XX_SDRAM_SIZE;
	 /*ERAM*/ pastDeviceConfig[DEV_TYPE_M823XX].stMemInfo.aulMemBase[ERAM_INDEX] = M823XX_ERAM_START;
	pastDeviceConfig[DEV_TYPE_M823XX].stMemInfo.aulMemSize[ERAM_INDEX] = M823XX_ERAM_SIZE;
	 /*ARAM*/ pastDeviceConfig[DEV_TYPE_M823XX].stMemInfo.aulMemBase[ARAM_INDEX] = M823XX_ARAM_START;
	pastDeviceConfig[DEV_TYPE_M823XX].stMemInfo.aulMemSize[ARAM_INDEX] = M823XX_ARAM_SIZE;

	 /*SDRAM*/ pastDeviceConfig[DEV_TYPE_M823XX_2].stMemInfo.aulMemBase[SDRAM_INDEX] = M823XX_2_SDRAM_START;
	pastDeviceConfig[DEV_TYPE_M823XX_2].stMemInfo.aulMemSize[SDRAM_INDEX] = M823XX_2_SDRAM_SIZE;
	 /*ERAM*/ pastDeviceConfig[DEV_TYPE_M823XX_2].stMemInfo.aulMemBase[ERAM_INDEX] = M823XX_2_ERAM_START;
	pastDeviceConfig[DEV_TYPE_M823XX_2].stMemInfo.aulMemSize[ERAM_INDEX] = M823XX_2_ERAM_SIZE;
	 /*ARAM*/ pastDeviceConfig[DEV_TYPE_M823XX_2].stMemInfo.aulMemBase[ARAM_INDEX] = M823XX_2_ARAM_START;
	pastDeviceConfig[DEV_TYPE_M823XX_2].stMemInfo.aulMemSize[ARAM_INDEX] = M823XX_2_ARAM_SIZE;	

	return;
}
